/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.jms.evSource.dequeue;

import com.streamscape.Trace;
import com.streamscape.omf.serializer.TextSerializer;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerException;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricRuntimeException;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.file.evSink.OutputFormat;
import com.streamscape.service.jms.evSource.dequeue.Version;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.config.TransportFactoryPropertyValue;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.transports.ExceptionEventListener;
import com.streamscape.service.osf.transports.StateNotificationEventListener;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class JmsDequeueService
extends AbstractDaemonService
implements StateNotificationEventListener,
ExceptionEventListener {
    private boolean connected = false;
    private long pollingInterval = 5000L;
    private TransportFactory transportFactory = null;
    protected TransportConnection connection = null;
    protected Session session = null;
    protected MessageConsumer msgReceiver = null;
    protected Queue sourceQueue = null;
    private String sourceQueueName = null;
    private OutputFormat inboundFormat = OutputFormat.SPECIFIC;
    EventDatagramFactory eventFactory = null;
    private TextSerializer serializer = null;
    private String eventId = null;

    public void doInit() {
        try {
            super.doInit();
            this.eventFactory = EventDatagramFactory.getInstance();
            this.ctx.logInfo("Service initializing...");
            this.sourceQueueName = this.ctx.lookupStringProperty("source.queue.name");
            this.ctx.logDebug("Source Queue Name: " + this.sourceQueueName);
            this.inboundFormat = OutputFormat.valueOf(this.ctx.lookupEnumProperty("inbound.format"));
            this.ctx.logDebug("Inbound Format: " + String.valueOf((Object)this.inboundFormat));
            this.pollingInterval = this.ctx.lookupNumericProperty("polling.interval");
            this.ctx.logDebug("Polling interval: " + this.pollingInterval);
            this.eventId = this.ctx.lookupStringProperty("event.id");
            this.ctx.logDebug("Outbound EventId: " + this.eventId);
            this.transportFactory = this.ctx.lookupTransportFactoryProperty("transport.factory");
            this.ctx.logInfo("Transport factory created successfully.");
            this.connection = this.transportFactory.createConnection();
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.connection.setExceptionEventListener((ExceptionEventListener)this);
            if (this.ctx.getLogger() != null) {
                this.connection.setServiceLogger(this.ctx.getLogger());
            }
            if (this.connection == null) {
                throw new RuntimeException("Unable to create connection to message broker.");
            }
            this.ctx.logInfo("Transport connection created successfully.");
            switch (this.inboundFormat) {
                case XML: 
                case SPECIFIC: {
                    XSerializerFactory factory = this.context.getXSerializerFactory();
                    XSerializer xSerializer = factory.createSerializer("JmsDequeueSerializer");
                    xSerializer.mapAttribute("SemanticType", "class");
                    this.serializer = xSerializer;
                    break;
                }
                case JSON: {
                    this.serializer = this.context.getJSONSerializerFactory().getDefaultSerializer().withPrettyPrint(true);
                }
            }
            this.ctx.logInfo("Service initialized.");
        }
        catch (Throwable error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new FabricRuntimeException(error.getMessage());
        }
    }

    public void start() throws ServiceFrameworkException {
        this.ctx.logInfo("Starting service...");
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoaderChain = this.ctx.getPackageManifestManager().getManifestClassLoader();
        Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
        try {
            this.connection.connect();
        }
        catch (TransportException error) {
            this.ctx.logError(error.getMessage());
            this.raiseException((IAbstractExceptionEvent)error);
        }
        Thread.currentThread().setContextClassLoader(loader);
        super.start();
        this.ctx.logInfo("Service started.");
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Transport connection state changed: " + e.getState().toString());
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (e.getState() == ConnectionState.CONNECTED) {
            try {
                this.connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException exception) {
                        JmsDequeueService.this.connected = false;
                    }
                });
                this.session = this.connection.createSession(false, 1);
                if (this.session == null) {
                    this.ctx.logError("Unable to create queue session.");
                }
                this.ctx.logInfo("Queue session created successfully.");
                this.sourceQueue = this.session.createQueue(this.sourceQueueName);
                if (this.sourceQueue == null) {
                    this.ctx.logError("Unable to resolve source queue.");
                }
                this.ctx.logInfo("Source queue resolved successfully: " + String.valueOf(this.sourceQueue));
                this.msgReceiver = this.session.createConsumer((Destination)this.sourceQueue);
                this.ctx.logInfo("Source queue receiver created successfully.");
                this.ctx.logInfo("Connection to the messaging broker opened.");
                this.connected = true;
                this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
            }
            catch (JMSException error) {
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                this.ctx.logError(error.getMessage());
            }
            catch (Throwable error) {
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            }
        } else {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Transport connection state changed to " + e.getState().toString());
        }
    }

    protected void doRepeatableServiceLogic() {
        try {
            if (!this.connected) {
                Thread.sleep(this.pollingInterval);
            } else {
                Message msg = this.msgReceiver.receive(this.pollingInterval);
                if (msg != null) {
                    this.ctx.logDebug("JMS Message [" + msg.getJMSMessageID() + "] received.");
                    EventDatagram event = EventDatagramFactory.getInstance().createEvent(this.eventId);
                    if (msg instanceof TextMessage) {
                        Object data;
                        TextMessage txt = (TextMessage)msg;
                        Trace.logDebug(JmsDequeueService.class, (String)("\n\nJMS Text Message\n----------------\n" + txt.getText() + "\n----------------\n"));
                        if (event instanceof DataEvent) {
                            switch (this.inboundFormat) {
                                case SPECIFIC: {
                                    ((DataEvent)event).setData((Object)txt.getText());
                                    break;
                                }
                                case XML: 
                                case JSON: {
                                    data = this.serializer.deserialize(txt.getText());
                                    ((DataEvent)event).setData(data);
                                    break;
                                }
                            }
                        }
                        if (event instanceof OpaqueEvent) {
                            switch (this.inboundFormat) {
                                case SPECIFIC: {
                                    ((OpaqueEvent)event).setData((Object)txt.getText());
                                    break;
                                }
                                case XML: 
                                case JSON: {
                                    data = this.serializer.deserialize(txt.getText());
                                    ((OpaqueEvent)event).setData(data);
                                    break;
                                }
                            }
                        } else if (event instanceof XMLEvent) {
                            ((XMLEvent)event).setXML(txt.getText());
                        } else if (event instanceof TextEvent) {
                            ((TextEvent)event).setText(txt.getText());
                        }
                        this.raiseEvent(event);
                    } else if (msg instanceof MapMessage) {
                        if (event instanceof MapEvent) {
                            while (((MapMessage)msg).getMapNames().hasMoreElements()) {
                                String key = (String)((MapMessage)msg).getMapNames().nextElement();
                                ((MapEvent)event).setObject(key, ((MapMessage)msg).getObject(key));
                            }
                        }
                    } else if (msg instanceof ObjectMessage) {
                        if (event instanceof DataEvent) {
                            ((DataEvent)event).setData((Object)((ObjectMessage)msg).getObject());
                        }
                    } else if (msg instanceof BytesMessage) {
                        int BUFFER_LENGTH = 0x400000;
                        byte[] BUFFER = new byte[BUFFER_LENGTH];
                        if (event instanceof BytesEvent) {
                            int read = 0;
                            for (long total = 0L; total < ((BytesMessage)msg).getBodyLength(); total += (long)read) {
                                read = ((BytesMessage)msg).readBytes(BUFFER, BUFFER_LENGTH);
                                ((BytesEvent)event).writeBytes(BUFFER, 0, read);
                            }
                            BUFFER = null;
                        }
                    } else {
                        Trace.logDebug(JmsDequeueService.class, (String)("Unsupported JMS Message Type '" + msg.getClass().getName() + "' received."));
                        TransportException ex = new TransportException("JMS-235", "Unsupported JMS Message Type '" + msg.getClass().getName() + "' received.");
                        ex.setConnectionName(this.connection.getName());
                        ex.setSeverity(Severity.WARNING);
                        ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
                        this.raiseException((IAbstractExceptionEvent)ex);
                    }
                } else {
                    Trace.logDebug(JmsDequeueService.class, (String)"No message is available on the queue.");
                }
            }
        }
        catch (JMSException error) {
            this.connection.forceStateCheck();
            TransportException ex = new TransportException(error);
            ex.setConnectionName(this.connection.getName());
            ex.setSeverity(Severity.SEVERE);
            ex.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.raiseException((IAbstractExceptionEvent)ex);
            this.connected = false;
        }
        catch (XSerializerException error) {
            this.ctx.logError("XML Serialization error: " + error.getMessage());
        }
        catch (Throwable error) {
            this.ctx.logError("Runtime Error: " + error.getClass().getName());
            this.ctx.logError(error.getMessage());
        }
    }

    public void stop() throws ServiceFrameworkException {
        this.ctx.logInfo("Stopping service...");
        super.stop();
        try {
            this.msgReceiver.close();
            this.session.close();
            this.connection.disconnect();
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unexpected error during service shutdown: " + error.getMessage()));
        }
        this.ctx.logInfo("Service stopped.");
    }

    private void raiseException(IAbstractExceptionEvent exception) {
        try {
            this.ctx.logError(exception.getMessage() != null ? exception.getMessage() : "Raise Exception with null message.");
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            System.out.println("Event dispatch error in raiseException(): " + exception.getMessage());
        }
    }

    private void raiseEvent(EventDatagram event) {
        try {
            this.ctx.logDebug("Raise event [" + event.getEventId() + "].");
            event.resetReplyTo();
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (Exception ex) {
            this.reportAndRethrowError(ex);
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void onEvent(TransportException e) {
        this.printTransportException(e);
    }

    private void printTransportException(TransportException event) {
        this.ctx.logError("TransportException: Connection: " + event.getConnectionName() + "\nSeverity: " + String.valueOf(event.getSeverity()) + "\nError Code: " + event.getErrorCodeAsString() + "\nMessaage: " + event.getMessage());
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"JmsDequeue", (boolean)false);
        sco.setServiceClassName(JmsDequeueService.class.getName());
        sco.setServiceDescription("Polls configured JMS server and publishes retrieved messages on specified EventId.");
        sco.setServiceDisplayName("JMS Dequeue Service");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty("polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies queue polling interval.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty("transport.factory", ServicePropertyType.TRANSPORT_FACTORY, null);
        prop.setLabel("Transport Connection Factory");
        prop.setDescription("Specifies JMS connection factory for connection establishment.");
        prop.setValue((Object)new TransportFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty("event.id", ServicePropertyType.STRING, null);
        prop.setLabel("Publish Event Id");
        prop.setDescription("Specifies EventId of event which is used to publish retrived messages.");
        prop.setValue("event.message");
        sco.addProperty(prop);
        prop = sco.createProperty("source.queue.name", ServicePropertyType.STRING, null);
        prop.setLabel("Source Queue Name");
        prop.setDescription("Specifies name of the queue for message retrieval.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("inbound.format", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Inbound Format");
        prop.setDescription("Specifies wheather inbound JMS message should be mapped to corresponding event or just deserialized and posted.");
        prop.setRange(String.valueOf((Object)OutputFormat.SPECIFIC) + "," + String.valueOf((Object)OutputFormat.XML) + "," + String.valueOf((Object)OutputFormat.JSON));
        prop.setValue(OutputFormat.XML.name());
        sco.addProperty(prop);
        sco.addActionableEvent("event.message");
        sco.addException("exception.mpi.Transport");
        return sco;
    }
}

