/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.jms.evSink;

import com.streamscape.Trace;
import com.streamscape.omf.xml.XSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractExceptionEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.excp.TransportException;
import com.streamscape.sef.FabricEventDispatcher;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.jms.evSink.Version;
import com.streamscape.service.osf.Service;
import com.streamscape.service.osf.config.ConfigurationObject;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.transports.StateNotificationEventListener;
import com.streamscape.service.osf.transports.TransportConnection;
import com.streamscape.service.osf.transports.TransportFactory;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;

public class QueueWriter
implements Service,
StateNotificationEventListener {
    private boolean running = true;
    private long pollingInterval = 5000L;
    private Thread executor = null;
    private ConfigurationObject sco = null;
    protected TransportConnection connection = null;
    protected Session session = null;
    protected MessageConsumer ackReceiver = null;
    protected MessageProducer msgSender = null;
    protected Queue sourceQueue = null;
    protected Queue ackQueue = null;
    private String sourceQueueName = null;
    private String ackQueueName = null;
    private TransportFactory transportFactory = null;
    EventDatagramFactory eventFactory = null;
    private FabricEventDispatcher dispatcher = null;
    private ServiceContext ctx = null;
    private XSerializer serializer = null;
    private String eventId = null;
    private int reconnectRetries = 0;
    private final int MAX_RECONNECT_ATTEMPTS = 5;
    private boolean connected = false;
    private PackageManifestManager mManager = null;
    private ClassLoader loader = null;

    public void destroy() {
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void init() {
        RuntimeContext runtimeCtx = RuntimeContext.getInstance();
        try {
            this.ctx = runtimeCtx.lookupServiceContext((Service)this);
            this.mManager = this.ctx.getPackageManifestManager();
            this.sco = this.ctx.getServiceConfiguration();
            this.eventFactory = EventDatagramFactory.getInstance();
            this.ctx.logInfo("Service initializing...");
            ServiceConfigurationProperties props = this.sco.getServiceConfigurationProperties();
            this.sourceQueueName = props.getProperty("source.queue.name").toString();
            this.ackQueueName = props.getProperty("ack.queue.name").toString();
            this.pollingInterval = Long.parseLong(props.getProperty("polling.interval").toString());
            this.eventId = props.getProperty("event.id").toString();
            this.transportFactory = this.ctx.lookupTransportFactoryProperty("transport.factory");
            this.ctx.logInfo("Transport factory created successfully.");
            this.connection = this.transportFactory.createConnection();
            this.connection.setStateNotificationEventListener((StateNotificationEventListener)this);
            if (this.connection == null) {
                throw new RuntimeException("Unable to create connection to message broker.");
            }
            this.ctx.logInfo("Transport connection created successfully.");
            this.serializer = RuntimeContext.getInstance().getXSerializerFactory().getDefaultSerializer();
        }
        catch (ServiceConfigurationException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (RuntimeContextException error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        catch (Exception error) {
            this.ctx.logError("Service initialization error: " + error.getMessage());
        }
        this.ctx.logInfo("Service initialized.");
    }

    public void resume() {
    }

    public void start() {
        this.ctx.logInfo("Starting service...");
        this.running = true;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader systemClassLoaderChain = RuntimeContext.getInstance().getPackageManifestManager().getManifestClassLoader();
        Thread.currentThread().setContextClassLoader(systemClassLoaderChain);
        try {
            this.connection.connect();
            this.executor = this.createMainPollerThread();
            this.executor.start();
        }
        catch (TransportException error) {
            this.ctx.logError(error.getMessage());
            throw new RuntimeException(error);
        }
        this.ctx.logInfo("Service started.");
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("Transport connection state changed: " + e.getState().toString());
        if (e.getState() == ConnectionState.CONNECTED) {
            try {
                this.connection.setExceptionListener(new ExceptionListener(){

                    public void onException(JMSException exception) {
                        QueueWriter.this.connected = false;
                    }
                });
                this.session = this.connection.createSession(false, 1);
                if (this.session == null) {
                    this.ctx.logError("Unable to create queue session.");
                }
                this.ctx.logInfo("Queue session created successfully.");
                this.sourceQueue = this.session.createQueue(this.sourceQueueName);
                if (this.sourceQueue == null) {
                    this.ctx.logError("Unable to resolve source queue.");
                }
                this.ctx.logInfo("Source queue resolved successfully: " + String.valueOf(this.sourceQueue));
                this.ackQueue = this.session.createQueue(this.ackQueueName);
                if (this.ackQueue == null) {
                    this.ctx.logError("Unable to resolve acknowledge queue.");
                }
                this.ctx.logInfo("Acknowledge queue resolved successfully: " + String.valueOf(this.ackQueue));
                this.msgSender = this.session.createProducer((Destination)this.sourceQueue);
                this.ctx.logInfo("Source queue receiver created successfully.");
                this.ackReceiver = this.session.createConsumer((Destination)this.ackQueue);
                this.ctx.logInfo("Ack queue sender created successfully.");
                this.ctx.logInfo("Connection to the messaging broker opened.");
                this.connected = true;
            }
            catch (JMSException error) {
                this.raiseException((IAbstractExceptionEvent)new TransportException(error));
            }
        }
    }

    private Thread createMainPollerThread() {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                while (QueueWriter.this.running) {
                    try {
                        if (!QueueWriter.this.connected) {
                            Thread.sleep(QueueWriter.this.pollingInterval);
                            continue;
                        }
                        Message msg = QueueWriter.this.ackReceiver.receive(QueueWriter.this.pollingInterval);
                        if (msg == null) continue;
                        QueueWriter.this.ctx.logInfo("Ack message [" + msg.getJMSMessageID() + "] has been picked up from the ack queue.");
                        if (!(msg instanceof TextMessage)) continue;
                        TextMessage txt = (TextMessage)msg;
                        QueueWriter.this.ctx.logDebug("The acknowledge message: \n" + txt.getText());
                    }
                    catch (JMSException error) {
                        QueueWriter.this.connected = false;
                    }
                    catch (Exception error) {
                        QueueWriter.this.ctx.logError("RuntimeError: " + error.getClass().getName());
                        QueueWriter.this.ctx.logError(error.getMessage());
                    }
                }
            }
        });
    }

    public void push(DataEvent event) {
        try {
            this.ctx.logInfo("New data to enqueue.");
            TextMessage message = this.session.createTextMessage();
            String msgText = this.serializer.serialize((Object)event);
            message.setText(msgText);
            this.msgSender.send((Message)message);
            this.ctx.logInfo("Message has been enqueued.");
            this.ctx.logDebug("Message content:\n" + msgText);
        }
        catch (JMSException error) {
            this.raiseException((IAbstractExceptionEvent)new ServiceFrameworkException(6108, (Throwable)error));
        }
        catch (Exception error) {
            this.ctx.logError("Unable to compose acknowledge message: " + error.getMessage());
        }
    }

    public void stop() {
        this.ctx.logInfo("Stopping service...");
        try {
            this.running = false;
            if (this.executor != null && this.executor.isAlive()) {
                this.executor.join();
            }
            this.ackReceiver.close();
            this.msgSender.close();
            this.session.close();
            this.connection.close();
        }
        catch (Exception error) {
            Trace.logError((Object)this, (String)("Unexpected error during service shutdown: " + error.getMessage()));
        }
        this.ctx.logInfo("Service stopped.");
    }

    private void raiseException(IAbstractExceptionEvent exception) {
        try {
            this.ctx.logError(exception.getMessage() != null ? exception.getMessage() : (exception.getErrorMessage() != null ? exception.getErrorMessage() : "Exception with an empty message has been thrown."));
            this.ctx.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception error) {
            System.out.println("Event dispatch error in raiseException(): " + exception.getMessage());
        }
    }

    private void raiseEvent(EventDatagram event) {
        try {
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 5000L);
            this.ctx.logDebug("[" + event.getEventId() + "] event fired.");
        }
        catch (Exception ex) {
            this.reportAndRethrowError(ex);
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    public void suspend() {
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public void cancel() throws ServiceFrameworkException {
    }
}

