/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.http.evSource;

import com.streamscape.Trace;
import com.streamscape.lib.http.client.HTTPConnection;
import com.streamscape.omf.serializer.Serializer;
import com.streamscape.omf.serializer.SerializerException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.SDOException;
import com.streamscape.sdo.SecurityViolationException;
import com.streamscape.sdo.advisory.ConnectionStateChangeAdvisory;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.http.HTTPRequest;
import com.streamscape.sdo.http.HTTPResponse;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.http.evSource.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.clients.ExceptionEventListener;
import com.streamscape.service.osf.clients.StateNotificationEventListener;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import java.util.Map;

public class HTTPEventSource
extends AbstractDaemonService
implements StateNotificationEventListener,
ExceptionEventListener {
    private static final String CONNECTION = "connection.http";
    private static final String POLLING_INTERVAL = "polling.interval";
    private static final String EVENT_ID = "event.id";
    private static final String REQUEST_URI = "request.uri";
    private static final String HTTP_METHOD = "http.method";
    private static final String ENABLE_BUFFERING = "enable.buffering";
    private static final String RESPONSE_FORMAT = "response.format";
    private static final String INCLUDE_HTTP_HEADERS = "include.http.headers";
    private EventDatagramFactory datagramFactory = null;
    private HTTPConnection httpConnection = null;
    private HTTPRequest httpRequest = null;
    private ClientFactory connectionFactory = null;
    private long pollingInterval = 10000L;
    private String eventId = null;
    private boolean enableBuffering = false;
    private boolean includeHTTPHeaders = false;
    private ResponseFormat responseFormat = ResponseFormat.TEXT;
    private Serializer serializer = null;
    private EventDatagram previousEvent = null;
    private String lastException = null;
    private long lastExceptionTime = 0L;

    protected void doRepeatableServiceLogic() {
        HTTPResponse response = null;
        try {
            this.httpConnection.connect();
            response = this.httpConnection.execute(this.httpRequest);
            if (response.getStatusCode() != 200) {
                throw new ClientException(1026, "HTTP response code is not OK, response: " + String.valueOf(response));
            }
            if (response.getData() == null) {
                throw new ClientException(1026, "HTTP response contains null data.");
            }
            this.ctx.logInfo("HTTP response retrieved:  " + String.valueOf(response));
            EventDatagram event = this.convertHTTPResponseToEvent(response);
            this.raiseEvent(event);
            this.ctx.resetSuspectState(SuspectState.SuspectStateOriginator.service());
        }
        catch (ClientException clientException) {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), clientException.getMessage());
            this.raiseClientException(clientException);
        }
        catch (Exception exception) {
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), exception.getMessage());
            ClientException clientException = new ClientException(1026, "Failed to handle http request, error: " + exception.getMessage(), (Throwable)exception);
            this.raiseClientException(clientException);
        }
        try {
            Thread.sleep(this.pollingInterval);
        }
        catch (InterruptedException e) {
            Trace.logError((Object)((Object)this), (String)("HTTP polling interrupt: " + e.getMessage()));
        }
    }

    protected void doInit() {
        try {
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service instantiation error: " + error.getMessage());
        }
        try {
            super.doInit();
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            this.httpConnection = (HTTPConnection)this.connectionFactory.createConnection();
            this.httpConnection.setStateNotificationEventListener((StateNotificationEventListener)this);
            this.httpConnection.setExceptionEventListener((ExceptionEventListener)this);
            this.httpConnection.setServiceLogger(this.ctx.getLogger());
            this.pollingInterval = this.ctx.lookupNumericProperty(POLLING_INTERVAL);
            this.enableBuffering = this.ctx.lookupBooleanProperty(ENABLE_BUFFERING);
            this.includeHTTPHeaders = this.ctx.lookupBooleanProperty(INCLUDE_HTTP_HEADERS);
            this.responseFormat = ResponseFormat.valueOf(this.ctx.lookupStringProperty(RESPONSE_FORMAT).toUpperCase());
            this.eventId = this.ctx.lookupStringProperty(EVENT_ID);
            if (!this.checkProtorype((ImmutableEventDatagram)this.datagramFactory.createEvent(this.eventId))) {
                throw new RuntimeException("Event prototype [" + this.eventId + "] does not correspond to responseFormat '" + String.valueOf((Object)this.responseFormat) + "'.");
            }
            if (this.responseFormat == ResponseFormat.XML) {
                this.serializer = RuntimeContext.getInstance().getXSerializerFactory().createSerializer("HTTPResponseXMLDeserializer");
            } else if (this.responseFormat == ResponseFormat.JSON) {
                this.serializer = RuntimeContext.getInstance().getJSONSerializerFactory().createSerializer("HTTPResponseJSONDeserializer");
            }
            this.httpRequest = new HTTPRequest();
            this.httpRequest.setMethod(this.ctx.lookupStringProperty(HTTP_METHOD));
            this.httpRequest.setUri(this.ctx.lookupStringProperty(REQUEST_URI));
            this.ctx.logInfo("HTTPEventSource initialized: " + this.toString());
        }
        catch (Exception badConfiguration) {
            this.reportAndRethrowError(badConfiguration);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cauae: " + exception.getMessage());
            }
        }
    }

    private EventDatagram convertHTTPResponseToEvent(HTTPResponse response) throws DatagramFactoryException, SecurityViolationException, SDOException, SerializerException {
        EventDatagram event = this.datagramFactory.createEvent(this.eventId);
        switch (this.responseFormat.ordinal()) {
            case 0: {
                ((TextEvent)event).setText(new String(response.getData()));
                break;
            }
            case 3: {
                ((BytesEvent)event).setBytes(response.getData());
                break;
            }
            case 1: 
            case 2: {
                ((DataEvent)event).setData(this.serializer.deserialize(response.getData()));
            }
        }
        if (this.includeHTTPHeaders) {
            for (Map.Entry entry : response.getHeaders().entrySet()) {
                event.setEventStringProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.enableBuffering) {
            this.previousEvent = event;
        }
        return event;
    }

    boolean checkProtorype(ImmutableEventDatagram event) {
        switch (this.responseFormat.ordinal()) {
            case 0: {
                return event instanceof TextEvent;
            }
            case 1: 
            case 2: {
                return event instanceof DataEvent;
            }
            case 3: {
                return event instanceof BytesEvent;
            }
        }
        return true;
    }

    public String toString() {
        return "Pollig interval: " + this.pollingInterval + " ms., EventId: " + this.eventId + ", responseFormat: " + String.valueOf((Object)this.responseFormat) + ", includeHTTPHeaders: " + this.includeHTTPHeaders + ", enableBuffering: " + this.enableBuffering + ", request: " + String.valueOf(this.httpRequest) + ", connection: " + String.valueOf(this.httpConnection);
    }

    private void raiseClientException(ClientException clientException) {
        if (this.lastException != null && this.lastException.equals(clientException.toString()) && System.currentTimeMillis() - this.lastExceptionTime < 60000L) {
            return;
        }
        this.lastException = clientException.toString();
        this.lastExceptionTime = System.currentTimeMillis();
        try {
            clientException.setConnectionName(this.httpConnection.getUrl());
            clientException.setSeverity(Severity.SEVERE);
            this.ctx.logError("HTTP Client Exception: " + clientException.getMessage());
            this.ctx.raiseException((ExceptionEventDatagram)clientException);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch exception: " + ex.getMessage() + " for HTTP Error: " + clientException.getErrorMessage());
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    private void raiseEvent(EventDatagram event) {
        try {
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            this.ctx.logDebug("Actionable event [" + event.getEventId() + "] event has been raised. Even class: " + String.valueOf(event.getClass()));
        }
        catch (Exception ex) {
            this.reportAndRethrowError(ex);
        }
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void onEvent(ClientException e) {
        this.ctx.logError("HTTP Exception: " + e.toString());
    }

    public void onEvent(ConnectionStateChangeAdvisory e) {
        this.ctx.logInfo("HTTP connection state changed: " + e.getState().toString());
        try {
            e.setComponentName(this.ctx.getType() + "." + this.ctx.getName());
            this.ctx.raiseAdvisory((AdvisoryEventDatagram)e);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch error in raiseAdvisory(): " + ex.getMessage() + " HTTP message: " + e.getMessage());
        }
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"HTTPEventSource", (boolean)false);
        sco.setServiceClassName(HTTPEventSource.class.getName());
        sco.setServiceDescription("Allows to send HTTP requests with specified interval to the configured HTTP server.");
        sco.setServiceDisplayName("HTTP Event Source");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("HTTP Connection Factory");
        prop.setDescription("Specifies HTTP connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(ENABLE_BUFFERING, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Enable Buffering");
        prop.setDescription("Specifies whether buffering of HTTP responses should be enabled.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty(INCLUDE_HTTP_HEADERS, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Include HTTP Headers");
        prop.setDescription("Specifies whether HTTP headers should be included into response.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty(EVENT_ID, ServicePropertyType.STRING, null);
        prop.setLabel("Publish Event Id");
        prop.setDescription("Specifies event Id of the event which will be used for HTTP responses publishing.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(HTTP_METHOD, ServicePropertyType.STRING, null);
        prop.setLabel("HTTP Method Name");
        prop.setDescription("Specifies HTTP method which should be used to call HTTP server (GET, POST, etc...).");
        prop.setValue("GET");
        sco.addProperty(prop);
        prop = sco.createProperty(POLLING_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies interval of HTTP server polling.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty(REQUEST_URI, ServicePropertyType.STRING, null);
        prop.setLabel("Request URI");
        prop.setDescription("Specifies request URI which should be sent to HTTP server.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(RESPONSE_FORMAT, ServicePropertyType.STRING, null);
        prop.setLabel("Response Format");
        prop.setDescription("Specifies format of HTTP response.");
        prop.setRange("TEXT,XML,JSON,BINARY");
        prop.setValue("TEXT");
        sco.addProperty(prop);
        sco.addException("exception.cli.Interface");
        return sco;
    }

    static enum ResponseFormat {
        TEXT,
        XML,
        JSON,
        BINARY;

    }
}

