/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ftp.evSink;

import com.streamscape.Trace;
import com.streamscape.lib.ftp.client.FTPConnection;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.BytesEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.service.ftp.evSink.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import java.io.File;

public class FTPEventSink
extends AbstractService {
    private static String CONNECTION = "connection.ftp";
    private static String TARGET_FILE = "put.file.name";
    private static String EVENT_TYPE = "put.request.event.type";
    private FTPConnection ftpConnection = null;
    private boolean isFileEventMode = true;
    private EventDatagramFactory datagramFactory = null;
    private String targetFileName;
    private ClientFactory connectionFactory = null;

    public FileEvent uploadFile(FileEvent fileEvent) throws ClientException {
        if (this.ftpConnection == null) {
            throw this.createClientException("FTP connection is not initialized.");
        }
        if (!this.isFileEventMode) {
            throw this.createClientException("'BytesEvent' mode - doesn't support FileEvent events");
        }
        try {
            String localFilePath = fileEvent.getAbsoluteFileName();
            String remoteFileName = this.getRemoteFileName(this.targetFileName);
            String remoteFileDir = this.getRemoteFileDir(this.targetFileName);
            if (remoteFileName.length() == 0) {
                remoteFileName = fileEvent.getName();
            }
            this.upload(remoteFileName, remoteFileDir, localFilePath, null);
            FileEvent resultFileEvent = (FileEvent)this.ctx.createResponseEvent("uploadFile");
            resultFileEvent.init(new File(fileEvent.getAbsoluteFileName()), fileEvent.getLastState());
            resultFileEvent.setFileData(fileEvent.getFileData());
            return resultFileEvent;
        }
        catch (Exception exception) {
            throw this.createClientException("Unable to get remote file info. Cause: " + exception.getMessage());
        }
    }

    public FileEvent uploadFileFromBytes(BytesEvent bytesEvent) throws ClientException {
        if (this.ftpConnection == null) {
            throw this.createClientException("FTP connection is not initialized.");
        }
        if (this.isFileEventMode) {
            throw this.createClientException("'FileEvent' mode - doesn't support BytesEvent events");
        }
        String remoteFileName = this.getRemoteFileName(this.targetFileName);
        String remoteFileDir = this.getRemoteFileDir(this.targetFileName);
        try {
            this.upload(remoteFileName, remoteFileDir, null, bytesEvent.getBytes());
            FileEvent resultFileEvent = (FileEvent)this.ctx.createResponseEvent("uploadFileFromBytes");
            resultFileEvent.init(new File(remoteFileName), FileState.STATIC);
            resultFileEvent.setFileData(bytesEvent.getBytes());
            return resultFileEvent;
        }
        catch (Exception exception) {
            throw this.createClientException(exception.getMessage());
        }
    }

    public String toString() {
        return (this.isFileEventMode ? "File-event" : "Bytes-event") + ", connection: user = " + this.connectionFactory.getDefaultUser() + ", host = " + this.ftpConnection.getHost();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    protected String getRemoteFileName(String path) {
        int slashIndex = path.lastIndexOf(47);
        return path.substring(slashIndex + 1);
    }

    protected String getRemoteFileDir(String path) {
        int slashIndex = path.lastIndexOf(47);
        if (slashIndex > 0) {
            return path.substring(0, slashIndex);
        }
        return null;
    }

    protected void upload(String remoteFileName, String remoteFileDir, String localFilePath, byte[] data) throws ClientException {
        try {
            Trace.logInfo((Object)((Object)this), (String)"Connecting to FTP site..");
            try {
                this.ftpConnection.connect();
            }
            catch (Exception ftpError) {
                throw this.createClientException("[FTP OPEN] " + ftpError.getMessage());
            }
            try {
                if (remoteFileDir != null) {
                    this.ftpConnection.ftpChangeDir(remoteFileDir);
                }
            }
            catch (Exception ftpError) {
                throw this.createClientException("[FTP CHANGEDIR] " + ftpError.getMessage());
            }
            if (localFilePath != null) {
                Trace.logDebug((Object)((Object)this), (String)("Uploading file " + localFilePath + " as " + (remoteFileDir == null ? "" : remoteFileDir) + "/" + remoteFileName));
                this.ctx.logInfo("Put file '" + localFilePath + "' as '" + (remoteFileDir == null ? "" : remoteFileDir) + "/" + remoteFileName + "'");
                this.ftpConnection.ftpPutFileAsFile(localFilePath, remoteFileName, false);
                this.ctx.logInfo("File '" + remoteFileName + "' has been uploaded to FTP site.");
            } else {
                Trace.logDebug((Object)((Object)this), (String)("Uploading " + data.length + " bytes to " + (remoteFileDir == null ? "" : remoteFileDir) + "/" + remoteFileName));
                this.ctx.logInfo("Put " + data.length + " bytes as " + (remoteFileDir == null ? "" : remoteFileDir) + "/" + remoteFileName);
                this.ftpConnection.ftpPutFileAsBytes(data, remoteFileName, false);
                this.ctx.logInfo("Incoming data has been uploaded to FTP site as '" + remoteFileName + "' file.");
            }
        }
        catch (Exception ftpError) {
            throw this.createClientException("[FTP PUT] " + ftpError.getMessage());
        }
        finally {
            try {
                if (this.ftpConnection.getState() == ConnectionState.OPEN) {
                    this.ftpConnection.disconnect();
                }
            }
            catch (ClientException error) {
                Trace.logError((Object)((Object)this), (String)("FTP disconnect failed: " + error.getMessage()));
            }
        }
    }

    protected ClientException createClientException(String error) {
        Trace.logDebug((Object)((Object)this), (String)("FTP Client Exception: " + error));
        this.ctx.logDebug("FTP Client Exception: " + error);
        ClientException exception = new ClientException(1020, error, Severity.SEVERE);
        if (this.ftpConnection != null) {
            exception.setConnectionName(this.ftpConnection.getUrl());
        }
        return exception;
    }

    protected void doInit() {
        try {
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            this.ftpConnection = (FTPConnection)this.connectionFactory.createConnection();
            this.assertPropertyExistAndNotNull(EVENT_TYPE);
            String eventType = this.ctx.lookupStringProperty(EVENT_TYPE);
            if (!eventType.equals("File Change Event")) {
                this.isFileEventMode = false;
            }
            this.ctx.logInfo("Event type: " + eventType);
            this.assertPropertyExistAndNotNull(TARGET_FILE);
            this.targetFileName = this.ctx.lookupStringProperty(TARGET_FILE);
            this.datagramFactory = this.context.getEventDatagramFactory();
            Trace.logDebug((Object)((Object)this), (String)("FTPEventSink initialized: " + this.toString()));
        }
        catch (Exception badConfiguration) {
            badConfiguration.printStackTrace();
            throw new RuntimeException(badConfiguration);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cauae: " + exception.getMessage());
            }
        }
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addEventPrototype((String)"BytesEvent", (String)"event.bytes.to.upload");
        SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.file.to.upload");
        SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.uploaded.file.response");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"FTPEventSink", (boolean)false);
        sco.setServiceClassName(FTPEventSink.class.getName());
        sco.setServiceDescription("Performs upload to the configured FTP server.");
        sco.setServiceDisplayName("FTP Event Sink");
        sco.setInvokeMode(InvokeMode.ASYNC);
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "uploadFile", "FileUploadHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.file.to.upload");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        prototype = EventDatagramFactory.getInstance().createEvent("event.uploaded.file.response");
        handler.bindResponseEvent((ImmutableEventDatagram)prototype);
        sco.addEventHandler(handler);
        handler = new EventHandler((AbstractServiceConfigurationObject)sco, "uploadFileFromBytes", "BytesUploadHandler");
        prototype = EventDatagramFactory.getInstance().createEvent("event.bytes.to.upload");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        prototype = EventDatagramFactory.getInstance().createEvent("event.uploaded.file.response");
        handler.bindResponseEvent((ImmutableEventDatagram)prototype);
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("FTP Connection Factory");
        prop.setDescription("Specifies FTP connection factory.");
        prop.setValue((Object)new ClientFactoryPropertyValue("FactoryName", "FactoryType"));
        sco.addProperty(prop);
        prop = sco.createProperty(TARGET_FILE, ServicePropertyType.STRING, null);
        prop.setLabel("Target File Name");
        prop.setDescription("Specifies name of the uploading file on FTP server side.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(EVENT_TYPE, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Request Event Type");
        prop.setDescription("Specifies uploading mode, either from File Event or from BytesEvent.");
        prop.setRange("File Change Event,BytesEvent");
        prop.setValue("BytesEvent");
        sco.addProperty(prop);
        sco.addException("exception.cli.Interface");
        return sco;
    }
}

