/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.ftp.daemon;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.ftp.client.FTPConnection;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.IllegalStateException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.enums.FileState;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.sef.service.SuspectState;
import com.streamscape.service.ftp.daemon.Version;
import com.streamscape.service.osf.clients.ClientFactory;
import com.streamscape.service.osf.config.ClientFactoryPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EVFTPDaemon
extends AbstractDaemonService {
    public static String SERVICE_NAME = "prototype";
    public static final String SERVICE_TYPE = "EVFTPDaemon";
    public static final String EVENT_ID = "event.ftpFile.StateChange";
    public static final String CONNECTION = "ftp.connection";
    public static final String ROOT_FOLDER = "root.folder";
    public static final String POLLING_INTERVAL = "polling.interval";
    public static final String PERSISTENT_SNAPSHOT = "persistent.snapshot";
    public static final String DATASPACE_NAME = "dataspace.name";
    public static final String COLLECTION_NAME = "collection.name";
    public static final String RECOVERY_WINDOW = "recovery.window";
    public static final String SORT_STRATEGY = "sort.strategy";
    public static final String USE_MDTM = "use.mdtm";
    public static final String MONITORS = "monitors";
    public static final String MONITOR = "monitor";
    public static final String MONITOR_NAME = "monitor.name";
    public static final String MONITOR_PATTERN = "monitor.pattern";
    public static final String MONITOR_ACTION = "monitor.action";
    public static final String MONITOR_ACTION_PARAMETER = "monitor.action.parameter";
    static File FTP_TEMP_FOLDER = new File(".ftp");
    private FTPConnection ftpConnection = null;
    private ClientFactory connectionFactory = null;
    String rootFolder = null;
    long pollingInterval = 60000L;
    int recoveryWindow = 0;
    TimeUnit recoveryWindowUnit = TimeUnit.SECONDS;
    boolean persistentSnapshot = false;
    String dataspaceName = null;
    String collectionName = null;
    private SortStrategy sortStrategy = SortStrategy.MODIFICATION_TIME;
    private boolean useMdtm = false;
    private List<FileMonitor> monitors = new ArrayList<FileMonitor>();
    private TreeMap<String, FileEntry> snapshot = null;
    DataspaceAccessor accessor = null;
    private boolean needToCloseAccessor = false;
    long fileCounter = 0L;

    protected void doInit() {
        try {
            String recoveryWindowString;
            super.doInit();
            this.rootFolder = this.ctx.lookupStringProperty(ROOT_FOLDER);
            this.ctx.logInfo("FTP Root Folder : " + this.rootFolder);
            if (this.rootFolder == null || this.rootFolder.trim().equals("/")) {
                this.rootFolder = "";
            }
            this.pollingInterval = this.ctx.lookupNumericProperty(POLLING_INTERVAL);
            this.ctx.logInfo("Polling Interval : " + this.pollingInterval);
            this.persistentSnapshot = this.ctx.lookupBooleanProperty(PERSISTENT_SNAPSHOT);
            this.ctx.logInfo("Persistent Snapshot : " + this.persistentSnapshot);
            if (this.persistentSnapshot) {
                this.dataspaceName = this.ctx.lookupStringProperty(DATASPACE_NAME);
                this.ctx.logInfo("Snapshot Dataspace : " + this.dataspaceName);
                this.collectionName = this.ctx.lookupStringProperty(COLLECTION_NAME);
                this.ctx.logInfo("Snapshot Collection : " + this.collectionName);
            }
            if ((recoveryWindowString = this.ctx.lookupStringProperty(RECOVERY_WINDOW)).length() > 0) {
                this.setRecoveryWindow(recoveryWindowString);
                this.ctx.logInfo("Recovery Window : " + this.recoveryWindow + " " + this.recoveryWindowUnit.name());
            }
            if (this.ctx.existsProperty(SORT_STRATEGY)) {
                try {
                    this.sortStrategy = SortStrategy.valueOf(this.ctx.lookupEnumProperty(SORT_STRATEGY));
                    this.ctx.logInfo("File Sort Strategy : " + this.sortStrategy.name());
                }
                catch (IllegalArgumentException error) {
                    this.ctx.logError("Invalid sort strategy '" + this.ctx.lookupEnumProperty(SORT_STRATEGY) + "' specified. Using default '" + this.sortStrategy.name() + "'.");
                }
            }
            if (this.ctx.existsProperty(USE_MDTM)) {
                this.useMdtm = this.ctx.lookupBooleanProperty(USE_MDTM);
                this.ctx.logInfo("Use MDTM : " + this.useMdtm);
            }
            List list = this.ctx.lookupListProperty(MONITORS);
            for (ServiceConfigurationProperty monitorSCO : list) {
                Hashtable table = (Hashtable)monitorSCO.getValue();
                String monitorName = table.get(MONITOR_NAME) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_NAME)).getValue().toString() : "";
                String monitorPattern = table.get(MONITOR_PATTERN) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_PATTERN)).getValue().toString() : "";
                monitorPattern = monitorPattern.replaceAll("\\*", ".*");
                monitorPattern = monitorPattern.replaceAll("\\?", ".");
                FileAction monitorAction = null;
                try {
                    monitorAction = table.get(MONITOR_ACTION) != null ? FileAction.valueOf(((ServiceConfigurationProperty)table.get(MONITOR_ACTION)).getValue().toString()) : null;
                }
                catch (IllegalArgumentException error) {
                    throw new ServiceConfigurationException("Invalid file action '" + ((ServiceConfigurationProperty)table.get(MONITOR_ACTION)).getValue().toString() + "' is specified for monitor '" + monitorName + ".");
                }
                String monitorActionParameter = table.get(MONITOR_ACTION_PARAMETER) != null ? ((ServiceConfigurationProperty)table.get(MONITOR_ACTION_PARAMETER)).getValue().toString() : null;
                FileMonitor monitor = new FileMonitor(this);
                monitor.name = monitorName;
                monitor.pattern = Pattern.compile(monitorPattern);
                monitor.action = monitorAction;
                monitor.actionParameter = monitorActionParameter;
                this.monitors.add(monitor);
                this.ctx.logDebug("File monitor '" + monitorName + "' looking for '" + monitorPattern + "' files has been created.");
            }
            this.assertPropertyExistAndNotNull(CONNECTION);
            this.connectionFactory = this.ctx.lookupClientFactoryProperty(CONNECTION);
            this.ftpConnection = (FTPConnection)this.connectionFactory.createConnection();
            this.ftpConnection.useMdtm(this.useMdtm);
            if (this.persistentSnapshot) {
                this.checkSnapshotCollection();
            }
            this.initSnapshot();
        }
        catch (Exception e) {
            Trace.logError((Object)((Object)this), (String)("Failed to initialize service. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)e)));
            throw new RuntimeException(e);
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.connectionFactory != null) {
            try {
                this.connectionFactory.destroyAll();
                this.connectionFactory = null;
            }
            catch (Exception exception) {
                this.ctx.logError("Failed to destroy connection factory '" + this.connectionFactory.toString() + "'. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            }
        }
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
        super.destroy();
    }

    private void checkSnapshotCollection() throws Exception {
        DataspaceManager manager = RuntimeContext.getInstance().getDataspaceManager();
        if (!manager.existsDataspace(this.dataspaceName)) {
            manager.createDataspace(DataspaceType.TSPACE, this.dataspaceName, EventScope.OBSERVABLE);
        }
        this.openAccessor();
        if (this.accessor == null || !this.accessor.isAvailable()) {
            throw new IllegalStateException("Unable to open accessor to dataspace with snapshot.");
        }
        try {
            RowSet rowSet = this.accessor.executeQuery("describe collection [" + this.collectionName + "] tuples");
            rowSet.next();
            rowSet.next();
            String type = rowSet.getString(2);
            if (!type.equalsIgnoreCase("SQLTIMESTAMP")) {
                try {
                    this.accessor.executeQuery("alter collection [" + this.collectionName + "] alter tuple ModifiedDate set data type sqltimestamp");
                }
                catch (Exception exception) {
                    Trace.logException((Object)((Object)this), (Throwable)exception, (boolean)true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.accessor.executeQuery("create persistent table if not exists [" + this.collectionName + "] (   FileName string, IsDirectory boolean, ModifiedDate sqltimestamp) ");
    }

    private void openAccessor() throws FabricComponentAccessorException {
        if (!this.ctx.getState().isRunning()) {
            return;
        }
        this.accessor = this.ctx.createDataspaceAccessor(DataspaceType.TSPACE, this.dataspaceName);
    }

    private void setRecoveryWindow(String window) throws ServiceConfigurationException {
        Pattern pattern = Pattern.compile("(\\d*)\\s*(\\w*)");
        Matcher matcher = pattern.matcher(window);
        String unit = null;
        if (matcher.find()) {
            this.recoveryWindow = Integer.valueOf(matcher.group(1));
            unit = matcher.group(2);
            try {
                this.recoveryWindowUnit = TimeUnit.valueOf(unit.toUpperCase());
            }
            catch (IllegalArgumentException error) {
                throw new ServiceConfigurationException("Unsupported recovery window time unit specified : " + unit + ".");
            }
        } else {
            this.recoveryWindow = Integer.valueOf(window.trim());
        }
    }

    private List<FileEntry> getFileList() throws ClientException {
        List<FileEntry> files = null;
        try {
            files = this.ftpConnection.ftpList(this.rootFolder, true);
        }
        catch (Exception ftpError) {
            throw this.createClientException("[FTP LIST] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)ftpError));
        }
        if (files != null && this.sortStrategy == SortStrategy.MODIFICATION_TIME) {
            Collections.sort(files, new Comparator<FileEntry>(this){

                @Override
                public int compare(FileEntry o1, FileEntry o2) {
                    if (o1 == null || o1.getModificationDate() == null) {
                        return -1;
                    }
                    if (o2 == null || o2.getModificationDate() == null) {
                        return 1;
                    }
                    return o1.getModificationDate().compareTo(o2.getModificationDate());
                }
            });
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRepeatableServiceLogic() {
        this.ctx.logDebug("Scanning remote folder '" + this.rootFolder + "' for any changes...");
        try {
            if (this.snapshot == null) {
                this.raiseException((ExceptionEventDatagram)this.createClientException("Snapshot not initialized."));
                return;
            }
            try {
                Trace.logDebug((Object)((Object)this), (String)("Accessing FTP site '" + this.ftpConnection.getUrl() + "' .."));
                this.ftpConnection.connect();
                Trace.logDebug((Object)((Object)this), (String)"Connected.");
            }
            catch (Exception exception) {
                throw this.createClientException("[FTP OPEN] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            }
            List<FileEntry> filesList = this.getFileList();
            if (filesList == null) {
                this.ctx.logDebug("Unable to retrieve file list from the server.");
                return;
            }
            ArrayList<FileEntry> notAppliedFiles = new ArrayList<FileEntry>();
            for (FileEntry file : filesList) {
                if (file.getFileName().equals(".") || file.getFileName().equals("..")) continue;
                FileEntry snapshotFile = this.snapshot.get(file.getFileName());
                if (snapshotFile == null) {
                    if (!this.applyMonitor(file)) {
                        notAppliedFiles.add(file);
                    }
                    this.sendStateChangeEvent(file, FileState.CREATED);
                    continue;
                }
                if (snapshotFile.getModificationDate() == null || file.getModificationDate() == null || snapshotFile.getModificationDate().equals(file.getModificationDate())) continue;
                this.sendStateChangeEvent(file, FileState.MODIFIED);
            }
            if (!notAppliedFiles.isEmpty()) {
                this.ctx.logError("Monitor was not applied for the following files: " + String.valueOf(notAppliedFiles) + ".");
                filesList.removeAll(notAppliedFiles);
            }
            TreeMap<String, FileEntry> filesMap = this.listToMap(filesList);
            filesList = null;
            for (Map.Entry<String, FileEntry> entry : this.snapshot.entrySet()) {
                if (filesMap.containsKey(entry.getKey())) continue;
                this.sendStateChangeEvent(entry.getValue(), FileState.DELETED);
            }
            if (this.persistentSnapshot) {
                this.persistSnapshot(filesMap);
            }
            this.snapshot = filesMap;
        }
        catch (ClientException exception) {
            this.raiseException((ExceptionEventDatagram)exception);
        }
        catch (Exception exception) {
            this.raiseException((ExceptionEventDatagram)this.createClientException("Download failed: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
        }
        finally {
            try {
                if (this.ftpConnection.getState() == ConnectionState.OPEN) {
                    this.ftpConnection.disconnect();
                }
            }
            catch (ClientException error) {
                Trace.logError((Object)((Object)this), (String)("FTP disconnect failed: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
            }
            try {
                Thread.sleep(this.pollingInterval);
            }
            catch (InterruptedException e) {
                this.activated = false;
                this.snapshot = null;
                Trace.logDebug((Object)((Object)this), (String)("FTP polling interrupt: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)e)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean applyMonitor(FileEntry file) {
        boolean applied = true;
        block17: for (FileMonitor monitor : this.monitors) {
            Matcher matcher = monitor.pattern.matcher(file.getFileName());
            if (!matcher.find()) continue;
            switch (monitor.action.ordinal()) {
                case 1: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Renaming new file '" + file.getFileName() + "' to '" + (String)targetDir + "'...");
                        this.ftpConnection.ftpRen(this.rootFolder + "/" + file.getFileName(), (String)targetDir);
                        this.ctx.logDebug("File '" + file.getFileName() + "' has been renamed.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to rename file '" + file.getFileName() + "'. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                        applied = false;
                    }
                    continue block17;
                }
                case 0: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Copying new file '" + file.getFileName() + "' to '" + (String)targetDir + "'...");
                        File tempFile = new File(FTP_TEMP_FOLDER, "TEMP_FTP_FILE_" + System.currentTimeMillis() + "_" + ++this.fileCounter + ".TMP");
                        try {
                            this.ftpConnection.ftpGetFileAsFile(this.rootFolder + "/" + file.getFileName(), tempFile.getAbsolutePath());
                            this.ftpConnection.ftpPutFileAsFile(tempFile.getAbsolutePath(), (String)targetDir + "/" + file.getFileName(), false);
                        }
                        finally {
                            if (tempFile != null && tempFile.exists()) {
                                tempFile.delete();
                                tempFile = null;
                            }
                        }
                        this.ctx.logDebug("File '" + file.getFileName() + "' has been copied.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to copy file '" + file.getFileName() + "'. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                        applied = false;
                    }
                    continue block17;
                }
                case 3: {
                    try {
                        this.ctx.logDebug("Deleting file '" + file.getFileName() + "'...");
                        this.ftpConnection.ftpDel(this.rootFolder + "/" + file.getFileName());
                        this.ctx.logDebug("File '" + file.getFileName() + "' has been deleted.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to delete file '" + file.getFileName() + "'. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                        applied = false;
                    }
                    continue block17;
                }
                case 2: {
                    Object targetDir;
                    try {
                        targetDir = monitor.actionParameter;
                        if (targetDir != null && !((String)targetDir).trim().startsWith("/")) {
                            targetDir = this.rootFolder + "/" + (String)targetDir;
                        }
                        this.ctx.logDebug("Moving new file '" + file.getFileName() + "' to '" + (String)targetDir + "'...");
                        this.ftpConnection.ftpRen(this.rootFolder + "/" + file.getFileName(), (String)targetDir + "/" + file.getFileName());
                        this.ctx.logDebug("File '" + file.getFileName() + "' has been moved to '" + (String)targetDir + "'.");
                    }
                    catch (Exception error) {
                        this.ctx.logError("Failed to move file '" + file.getFileName() + "'. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                        applied = false;
                    }
                    continue block17;
                }
            }
            this.ctx.logError("Unsupported file action '" + monitor.action.name() + "'.");
        }
        return applied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSnapshot() {
        if (this.persistentSnapshot && this.accessor != null) {
            this.ctx.logDebug("Initializing FTP folder snapshot from dataspace collection...");
            try {
                this.snapshot = this.selectFilesFromTable();
            }
            catch (Exception exception) {
                this.raiseException((ExceptionEventDatagram)this.createClientException("Unable to init FTP folder snapshot : " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
            }
        } else {
            this.ctx.logDebug("Initializing FTP folder snapshot from FTP server...");
            Date date = null;
            if (this.recoveryWindow > 0) {
                date = new Date();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                switch (this.recoveryWindowUnit) {
                    case SECONDS: {
                        calendar.add(13, -this.recoveryWindow);
                        break;
                    }
                    case MINUTES: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                    case HOURS: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                    case DAYS: {
                        calendar.add(12, -this.recoveryWindow);
                        break;
                    }
                }
                date = calendar.getTime();
            }
            try {
                try {
                    Trace.logDebug((Object)((Object)this), (String)("Accessing FTP site '" + this.ftpConnection.getUrl() + "' .."));
                    this.ftpConnection.connect();
                    Trace.logDebug((Object)((Object)this), (String)"Connected.");
                }
                catch (Exception exception) {
                    throw this.createClientException("[FTP OPEN] " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
                }
                List<FileEntry> files = this.getFileList();
                if (files == null) {
                    return;
                }
                for (FileEntry file : files) {
                    if (date == null || file.getModificationDate() == null || !file.getModificationDate().after(date)) continue;
                    this.applyMonitor(file);
                }
                this.snapshot = this.listToMap(files);
            }
            catch (ClientException exception) {
                this.raiseException((ExceptionEventDatagram)exception);
            }
            catch (Exception exception) {
                this.raiseException((ExceptionEventDatagram)this.createClientException("Unable to init FTP folder snapshot : " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
            }
            finally {
                try {
                    if (this.ftpConnection.getState() == ConnectionState.OPEN) {
                        this.ftpConnection.disconnect();
                    }
                }
                catch (ClientException error) {
                    Trace.logError((Object)((Object)this), (String)("FTP disconnect failed: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
                }
            }
        }
        if (this.snapshot != null) {
            this.ctx.logDebug("File snapshot initialized.");
        } else {
            this.ctx.logDebug("Unable to initialize file snapshot.");
            this.ctx.setSuspectState(SuspectState.SuspectStateOriginator.service(), "Unable to inialize FTP folder snapshot.");
        }
    }

    private TreeMap<String, FileEntry> selectFilesFromTable() throws IllegalStateException {
        TreeMap<String, FileEntry> tempSnapshot = new TreeMap<String, FileEntry>();
        try {
            RowSet rowSet = this.accessor.executeQuery("select FileName, IsDirectory,ModifiedDate from [" + this.collectionName + "]");
            while (rowSet.next()) {
                String fileName = rowSet.getString(1);
                boolean isDirectory = rowSet.getBoolean(2);
                Date modifiedDate = rowSet.getTimestamp(3);
                if (modifiedDate != null) {
                    modifiedDate = new Date(((Date)modifiedDate).getTime());
                }
                tempSnapshot.put(fileName, new FileEntry(fileName, modifiedDate, isDirectory));
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Unable to load snapshot from dataspace collection. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
        }
        return tempSnapshot;
    }

    private void persistSnapshot(TreeMap<String, FileEntry> files) {
        if (!this.ctx.getState().isRunning()) {
            return;
        }
        if (this.needToCloseAccessor) {
            try {
                if (this.accessor != null) {
                    this.accessor.close();
                    this.accessor = null;
                }
                this.needToCloseAccessor = false;
            }
            catch (Exception error) {
                this.needToCloseAccessor = true;
                this.ctx.logError("Close accessor failed. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                this.raiseException((ExceptionEventDatagram)this.createClientException("Close accessor failed. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
                return;
            }
        }
        if (this.accessor == null) {
            try {
                this.openAccessor();
            }
            catch (FabricComponentAccessorException exception) {
                this.ctx.logError("Opening accessor failed. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
                this.raiseException((ExceptionEventDatagram)this.createClientException("Opening accessor failed. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
                return;
            }
        }
        if (this.accessor == null || !this.accessor.isAvailable()) {
            this.ctx.logError("Dataspace accessor is closed or not available. Don't persist snapshot.");
            this.raiseException((ExceptionEventDatagram)this.createClientException("Dataspace accessor is closed or not available. Don't persist snapshot."));
            return;
        }
        this.ctx.logDebug("Storing the new file snapshot to underlying collection...");
        this.doPersistSnapshotWithUpdateDelete(files);
        this.ctx.logDebug("File snapshot synchronized with dataspace collection.");
    }

    private void doPersistSnapshotWithTruncate(TreeMap<String, FileEntry> files) {
        try {
            this.ctx.logDebug("Truncating underlying collection...");
            this.accessor.executeQuery("truncate collection [" + this.collectionName + "]");
        }
        catch (Throwable exception) {
            this.ctx.logError("Failed to truncate collection. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            this.raiseException((ExceptionEventDatagram)this.createClientException("Failed to truncate collection. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
        }
        this.executeInTransaction(() -> {
            this.ctx.logDebug("Inserting " + files.size() + " new files...");
            for (Map.Entry entry : files.entrySet()) {
                this.accessor.executeQuery("insert into [" + this.collectionName + "] (FileName, IsDirectory, ModifiedDate) values(?,?,?) ", new Object[]{((FileEntry)entry.getValue()).getFileName(), ((FileEntry)entry.getValue()).isDirectory(), ((FileEntry)entry.getValue()).getModificationDate()});
            }
        });
    }

    private void doPersistSnapshotWithUpdateDelete(TreeMap<String, FileEntry> newFiles) {
        try {
            this.ctx.logDebug("Selecting files from table...");
            TreeMap<String, FileEntry> persistedFiles = this.selectFilesFromTable();
            Iterator<Map.Entry<String, FileEntry>> persistedFilesIterator = persistedFiles.entrySet().iterator();
            Iterator<Map.Entry<String, FileEntry>> newFilesIterator = newFiles.entrySet().iterator();
            ArrayList<FileEntry> filesToInsert = new ArrayList<FileEntry>();
            ArrayList<FileEntry> filesToDelete = new ArrayList<FileEntry>();
            ArrayList<FileEntry> filesToUpdate = new ArrayList<FileEntry>();
            FileEntry persistedFile = null;
            FileEntry newFile = null;
            if (persistedFilesIterator.hasNext()) {
                persistedFile = persistedFilesIterator.next().getValue();
            }
            if (newFilesIterator.hasNext()) {
                newFile = newFilesIterator.next().getValue();
            }
            while (true) {
                if (persistedFile == null) {
                    if (newFile != null) {
                        filesToInsert.add(newFile);
                    }
                    while (newFilesIterator.hasNext()) {
                        filesToInsert.add(newFilesIterator.next().getValue());
                    }
                    newFile = null;
                }
                if (newFile == null) {
                    if (persistedFile != null) {
                        filesToDelete.add(persistedFile);
                    }
                    while (persistedFilesIterator.hasNext()) {
                        filesToDelete.add(persistedFilesIterator.next().getValue());
                    }
                    persistedFile = null;
                }
                if (persistedFile == null && newFile == null) break;
                if (persistedFile == null || newFile == null) continue;
                int c = persistedFile.getFileName().compareTo(newFile.getFileName());
                if (c == 0) {
                    if (persistedFile.isDirectory() != newFile.isDirectory() || !Objects.equals(persistedFile.getModificationDate(), newFile.getModificationDate())) {
                        filesToUpdate.add(newFile);
                    }
                    persistedFile = persistedFilesIterator.hasNext() ? persistedFilesIterator.next().getValue() : null;
                    if (newFilesIterator.hasNext()) {
                        newFile = newFilesIterator.next().getValue();
                        continue;
                    }
                    newFile = null;
                    continue;
                }
                if (c < 0) {
                    filesToDelete.add(persistedFile);
                    if (persistedFilesIterator.hasNext()) {
                        persistedFile = persistedFilesIterator.next().getValue();
                        continue;
                    }
                    persistedFile = null;
                    continue;
                }
                filesToInsert.add(newFile);
                if (newFilesIterator.hasNext()) {
                    newFile = newFilesIterator.next().getValue();
                    continue;
                }
                newFile = null;
            }
            this.ctx.logDebug("Old snapshot size: " + persistedFiles.size() + ", new snapshot size: " + newFiles.size() + ", new files: " + filesToInsert.size() + ", updated files: " + filesToUpdate.size() + ", deleted files: " + filesToDelete.size());
            if (filesToInsert.size() > 0) {
                this.ctx.logDebug("New files: " + String.valueOf(filesToInsert));
            }
            if (filesToUpdate.size() > 0) {
                this.ctx.logDebug("Updated files: " + String.valueOf(filesToUpdate));
            }
            if (filesToDelete.size() > 0) {
                this.ctx.logDebug("Deleted files: " + String.valueOf(filesToDelete));
            }
            if ((double)(filesToDelete.size() + filesToUpdate.size()) >= (double)persistedFiles.size() * 0.5 || (double)(filesToDelete.size() + filesToUpdate.size()) >= (double)newFiles.size() * 0.5) {
                this.doPersistSnapshotWithTruncate(newFiles);
                return;
            }
            this.executeInTransaction(() -> {
                if (filesToDelete.size() > 0) {
                    this.ctx.logDebug("Deleting " + filesToDelete.size() + " files...");
                    for (FileEntry file : filesToDelete) {
                        this.accessor.executeQuery("delete from [" + this.collectionName + "] where FileName = ?", new Object[]{file.getFileName()});
                    }
                }
                if (filesToUpdate.size() > 0) {
                    this.ctx.logDebug("Updating " + filesToUpdate.size() + " files...");
                    for (FileEntry file : filesToUpdate) {
                        this.accessor.executeQuery("update [" + this.collectionName + "] set IsDirectory=?, ModifiedDate=? where FileName = ?", new Object[]{file.isDirectory(), file.getModificationDate(), file.getFileName()});
                    }
                }
                if (filesToInsert.size() > 0) {
                    this.ctx.logDebug("Inserting " + filesToInsert.size() + " files...");
                    for (FileEntry file : filesToInsert) {
                        this.accessor.executeQuery("insert into [" + this.collectionName + "] (FileName, IsDirectory, ModifiedDate) values(?,?,?) ", new Object[]{file.getFileName(), file.isDirectory(), file.getModificationDate()});
                    }
                }
            });
        }
        catch (Throwable exception) {
            this.ctx.logError("Failed to persist snapshot. Cause " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            this.raiseException((ExceptionEventDatagram)this.createClientException("Failed to persist snapshot. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
        }
    }

    private void executeInTransaction(Executor executor) {
        try {
            this.accessor.setAutoCommit(false);
            executor.execute();
            this.accessor.commit();
        }
        catch (Exception exception) {
            this.ctx.logError("Unable to store file snapshot. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            Trace.logException((Object)((Object)this), (Throwable)exception, (boolean)true);
            this.raiseException((ExceptionEventDatagram)this.createClientException("Unable to store file snapshot. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception)));
            try {
                this.accessor.rollback();
            }
            catch (Exception error) {
                this.ctx.logError("Rollback is failed. Closing accessor. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
                this.raiseException((ExceptionEventDatagram)this.createClientException("Rollback is failed. Closing accessor. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
                try {
                    this.accessor.close();
                    this.accessor = null;
                }
                catch (Exception error1) {
                    this.needToCloseAccessor = true;
                    this.ctx.logError("Close accessor failed. Will be closed on next iteration. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                    this.raiseException((ExceptionEventDatagram)this.createClientException("Close accessor is failed. Will be closed on next iteration. Cause: " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
                }
            }
            try {
                this.accessor.setAutoCommit(true);
            }
            catch (DataspaceComponentException error) {
                this.ctx.logError("Set autocommit is failed. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
                this.raiseException((ExceptionEventDatagram)this.createClientException("Set autocommit failed. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error)));
            }
        }
    }

    private TreeMap<String, FileEntry> listToMap(List<FileEntry> files) {
        TreeMap<String, FileEntry> map = new TreeMap<String, FileEntry>();
        for (FileEntry file : files) {
            map.put(file.getFileName(), file);
        }
        return map;
    }

    private void sendStateChangeEvent(FileEntry entry, FileState state) {
        try {
            MapEvent event = (MapEvent)EventDatagramFactory.getInstance().createEvent(EVENT_ID);
            event.setString("FileName", entry.getFileName());
            event.setString("FileState", state.name());
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (Exception error) {
            this.ctx.logError("Failed to send file state change event. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)error));
        }
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            this.ctx.logError("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + error.getErrorMessage());
        }
    }

    protected ClientException createClientException(String error) {
        this.ctx.logError("FTP Client Exception: " + error);
        ClientException exception = new ClientException(1032, error, Severity.SEVERE);
        if (this.ftpConnection != null) {
            exception.setConnectionName(this.ftpConnection.getUrl());
        }
        return exception;
    }

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)SERVICE_TYPE, (boolean)false);
        sco.setServiceClassName(EVFTPDaemon.class.getName());
        sco.setServiceDescription("Polls the specified FTP folder and checks for new files.");
        sco.setServiceDisplayName("Event FTP System Daemon");
        sco.setInvokeMode(InvokeMode.ASYNC);
        ServiceConfigurationProperty prop = sco.createProperty(CONNECTION, ServicePropertyType.CLIENT_FACTORY, null);
        prop.setLabel("FTP Connection");
        prop.setDescription("Specifies FTP connection configuration.");
        prop.setValue((Object)new ClientFactoryPropertyValue("TestConnection", "FTPConnection"));
        sco.addProperty(prop);
        prop = sco.createProperty(ROOT_FOLDER, ServicePropertyType.STRING, null);
        prop.setLabel("Root Folder");
        prop.setDescription("Specifies root FTP folder.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(POLLING_INTERVAL, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies FTP site polling interval.");
        prop.setValue((Object)60000L);
        sco.addProperty(prop);
        prop = sco.createProperty(PERSISTENT_SNAPSHOT, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Persistent Snapshot");
        prop.setDescription("Specifies whether snapshot should be persistent.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty(DATASPACE_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Dataspace Name");
        prop.setDescription("Specifies name of the dataspace to store snapshot.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(COLLECTION_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Collection Name");
        prop.setDescription("Specifies name of the collection to store snapshot.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty(RECOVERY_WINDOW, ServicePropertyType.NUMERIC, null);
        prop.setLabel("Recovery Window");
        prop.setDescription("Specifies which existing files should be processed during the service start.");
        prop.setValue((Object)60000L);
        sco.addProperty(prop);
        prop = sco.createProperty(SORT_STRATEGY, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("File Sort Strategy");
        prop.setDescription("Specifies sort strategy for the files to be processed by monitors.");
        prop.setRange(SortStrategy.MODIFICATION_TIME.name() + "," + SortStrategy.SERVER_DEFAULT.name());
        prop.setValue(SortStrategy.MODIFICATION_TIME.name());
        sco.addProperty(prop);
        prop = sco.createProperty(USE_MDTM, ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Use MDTM Window");
        prop.setDescription("Specifies whether MDTM ftp command should be used for file modification time retrieval.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        ServiceConfigurationProperty monitors = sco.createProperty(MONITORS, ServicePropertyType.LIST, null);
        monitors.setLabel("Monitors");
        monitors.setDescription("Contains list of all monitors.");
        sco.addProperty(monitors);
        ServiceConfigurationProperty monitor = sco.createProperty(MONITOR, ServicePropertyType.TABLE, null);
        monitor.setLabel("Monitor");
        monitor.setDescription("Contains configuration of a monitor.");
        ((List)monitors.getValue()).add(monitor);
        Hashtable monitorConfig = (Hashtable)monitor.getValue();
        prop = sco.createProperty(MONITOR_NAME, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Name");
        prop.setDescription("Specifies name of the monitor.");
        prop.setValue("TestMonitor");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_PATTERN, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Pattern");
        prop.setDescription("Specifies pattern for the files which this monitor is supposed to process.");
        prop.setValue(".*.zip");
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_ACTION, ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Monitor Action");
        prop.setDescription("Specifies action which should be applied on matched file.");
        prop.setRange(FileAction.COPY.name() + "," + FileAction.MOVE.name() + "," + FileAction.DELETE.name() + "," + FileAction.RENAME.name() + ",");
        prop.setValue(FileAction.COPY.name());
        monitorConfig.put(prop.getName(), prop);
        prop = sco.createProperty(MONITOR_ACTION_PARAMETER, ServicePropertyType.STRING, null);
        prop.setLabel("Monitor Action Parameter");
        prop.setDescription("Specifies additional parameter for file action (if necessary).");
        prop.setValue("InboundFolder");
        monitorConfig.put(prop.getName(), prop);
        sco.addActionableEvent(EVENT_ID);
        sco.addException("exception.cli.Interface");
        return sco;
    }

    static {
        try {
            SDOUtils.addEventPrototype((String)"MapEvent", (String)EVENT_ID);
        }
        catch (Exception error) {
            Trace.logError(EVFTPDaemon.class, (String)"Unable to register default event prototypes.");
        }
        if (!FTP_TEMP_FOLDER.exists()) {
            FTP_TEMP_FOLDER.mkdir();
        }
    }

    static enum SortStrategy {
        SERVER_DEFAULT,
        MODIFICATION_TIME;

    }

    static enum FileAction {
        COPY,
        RENAME,
        MOVE,
        DELETE;

    }

    class FileMonitor {
        String name;
        Pattern pattern;
        FileAction action;
        String actionParameter;

        FileMonitor(EVFTPDaemon this$0) {
        }
    }

    static interface Executor {
        public void execute() throws DataspaceComponentException;
    }
}

