/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.file.evSource;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.file.AbstractRecordTypeDefinition;
import com.streamscape.lib.file.FileDescriptor;
import com.streamscape.lib.file.FileDescriptorFactory;
import com.streamscape.lib.file.FileDescriptorRecord;
import com.streamscape.lib.file.FileLinesReader;
import com.streamscape.lib.file.FileRecordsReader;
import com.streamscape.lib.file.RecordTypeDefinition;
import com.streamscape.lib.file.UntypedRecordTypeDefinition;
import com.streamscape.lib.reflection.ReflectionProvider;
import com.streamscape.lib.txfs.IsolationLevel;
import com.streamscape.lib.txfs.mf.admin.FileResourceManagerFactory;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.repository.IllegalStateException;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.Severity;
import com.streamscape.sdo.enums.StreamState;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.FileEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.service.AbstractDaemonService;
import com.streamscape.service.file.evSource.SourceDispatchModel;
import com.streamscape.service.file.evSource.StartFilePosition;
import com.streamscape.service.file.evSource.Version;
import com.streamscape.service.osf.config.AbstractServiceConfigurationObject;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.service.osf.evh.EventHandler;
import com.streamscape.service.xml.utils.EventSenders;
import com.streamscape.tools.tailer.FileTailerStateListener;
import com.streamscape.tools.tailer.impl.FileTailerInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.Path;
import java.sql.Timestamp;
import java.util.Map;

public class FileReader
extends AbstractDaemonService {
    private long pollingInterval = 0L;
    private String pollingFileName = null;
    private String encoding = null;
    private boolean sendOpenStreamEvent = false;
    private boolean sendCloseStreamEvent = false;
    private boolean sendAbortStreamEvent = false;
    private String streamStateEventId = null;
    private String fileActionEventId = null;
    private String recordGroupEventId = null;
    private EventDatagramFactory datagramFactory = null;
    private SourceDispatchModel dispatchModel = null;
    private StartFilePosition startFilePosition = null;
    private InputStream inputStream;
    private FileLinesReader fileLinesReader;
    private FileRecordsReader fileRecordsReader;
    private Exception lastException = null;
    private int noContentAlertTimeout = 0;
    private long lastContentReadTime = 0L;
    private FileDescriptor fileDescriptor = null;
    private FileDescriptorFactory fileDescriptorFactory = null;
    private boolean auditEnabled = false;
    private String auditDataspace = null;
    private String auditCollection = null;
    private DataspaceAccessor auditDsAccessor = null;
    long recordLimit = 0L;

    protected long getPassiveIterationInterval() {
        return this.pollingInterval;
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public void processFile(ImmutableEventDatagram event) throws IllegalStateException {
        if (event == null || !(event instanceof FileEvent)) {
            throw new IllegalStateException("Incoming event is in incompatible format");
        }
        if (!this.activated) {
            throw new IllegalStateException("Service is not started. Incoming request can't be processed.");
        }
        try {
            this.doProcessFile(((FileEvent)event).getAbsoluteFileName());
        }
        catch (Exception error) {
            throw new IllegalStateException("Failed to get filename from event: " + String.valueOf(error));
        }
    }

    protected void doRepeatableServiceLogic() {
        block4: {
            try {
                if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
                    this.doFilePoll();
                    break block4;
                }
                if (this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
                    this.doFileStream();
                    break block4;
                }
                throw new RuntimeException("Daemon service cannot be run for dispatch model '" + String.valueOf((Object)this.dispatchModel) + "'.");
            }
            catch (InterruptedException ex) {
                this.activated = false;
            }
        }
    }

    private void doFilePoll() throws InterruptedException {
        Thread.sleep(this.pollingInterval);
        this.doProcessFile(this.pollingFileName);
    }

    private void doFileStream() throws InterruptedException {
        if (this.inputStream == null) {
            int startLine = this.startFilePosition == StartFilePosition.HEAD ? 1 : 0;
            Path pollingFilePath = new File(this.pollingFileName).toPath();
            FileTailerStateListener fileTailerStateListener = new FileTailerStateListener(){

                public void onFileNotFound(String filename) {
                    if (FileReader.this.lastException == null || FileReader.this.lastException.getClass() != FileNotFoundException.class) {
                        FileReader.this.ctx.logError("Polling file '" + filename + "' doesn't exist.");
                    }
                }

                public void onFileFound(String filename) {
                }

                public void onFileRotated(String oldFilename, String newFilename) {
                    FileReader.this.ctx.logInfo("Polling file '" + oldFilename + "' has been rotated to '" + newFilename + "'.");
                }

                public void onFileTruncated(String filename) {
                    FileReader.this.ctx.logInfo("Polling file '" + filename + "' has been truncated.");
                    FileLinesReader flr = FileReader.this.fileLinesReader;
                    if (flr != null) {
                        flr.resetCurrentReads();
                    }
                    FileReader.this.sendStreamStateEvent("TRUNCATED", FileReader.this.pollingFileName, true);
                }

                public void onException(Exception exception) {
                    FileReader.this.ctx.logError("Exception while reading file '" + FileReader.this.pollingFileName + "'. Error: " + exception.getMessage());
                }
            };
            this.ctx.logInfo("File '" + this.pollingFileName + "' is being parsed in file stream mode...");
            this.inputStream = new FileTailerInputStream(pollingFilePath, startLine, null);
            ((FileTailerInputStream)this.inputStream).addStateListener(fileTailerStateListener);
            this.fileLinesReader = this.fileDescriptorFactory.createFileLinesReader((InputStream)new BufferedInputStream(this.inputStream), this.encoding, false);
            this.fileRecordsReader = this.createFileRecordsReader();
            this.sendStreamStateEvent(StreamState.OPEN.name(), this.pollingFileName, this.sendOpenStreamEvent);
        } else {
            Thread.sleep(this.pollingInterval);
        }
        try {
            this.fileRecordsReader.readStreamedFile(this.fileLinesReader, this.startFilePosition == StartFilePosition.HEAD, true);
            if (this.fileRecordsReader.getRecordCounter() > 0) {
                this.lastContentReadTime = System.currentTimeMillis();
            } else {
                if (this.lastContentReadTime == 0L) {
                    this.lastContentReadTime = System.currentTimeMillis();
                }
                if (this.noContentAlertTimeout > 0 && System.currentTimeMillis() - this.lastContentReadTime > (long)(this.noContentAlertTimeout * 1000)) {
                    this.sendStreamStateEvent("NO_CONTENT", this.pollingFileName, true);
                }
            }
            if (this.lastException instanceof FileNotFoundException) {
                this.sendStreamStateEvent("RECOVERED", this.pollingFileName, true);
            }
            this.lastException = null;
            if (this.fileRecordsReader.getRecordCounter() > 0) {
                this.ctx.logDebug("Part of file '" + this.pollingFileName + "' has been parsed. Total records processed: " + this.fileRecordsReader.getRecordCounter() + ", skipped: " + this.fileRecordsReader.getSkippedCounter() + ", rejected: " + this.fileRecordsReader.getRejectedCounter() + ".");
            }
        }
        catch (Exception exception) {
            if (this.lastException == null || this.lastException.getClass() != exception.getClass()) {
                if (exception instanceof FileNotFoundException) {
                    this.sendStreamStateEvent("UNAVAILABLE", this.pollingFileName, true);
                } else {
                    this.ctx.logError(exception.getMessage());
                    this.raiseException(exception);
                    this.sendStreamStateEvent("ERROR", this.pollingFileName, true);
                }
            }
            this.lastException = exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessFile(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            FileResourceManagerFactory.FileResource resource = null;
            FileInputStream inputStream = null;
            try {
                this.ctx.logInfo("File '" + fileName + "' is being parsed in polling mode...");
                long startProcessing = System.currentTimeMillis();
                resource = FileResourceManagerFactory.acquireResource((File)file, (IsolationLevel)IsolationLevel.READ_ONLY);
                this.sendStreamStateEvent(StreamState.OPEN.name(), fileName, this.sendOpenStreamEvent);
                inputStream = new FileInputStream(new File(fileName));
                FileLinesReader fileLinesReader = this.fileDescriptorFactory.createFileLinesReader((InputStream)new BufferedInputStream(inputStream), this.encoding, true);
                FileRecordsReader fileRecordsReader = this.createFileRecordsReader();
                fileRecordsReader.readSingleFile(fileLinesReader);
                long endProcessing = System.currentTimeMillis();
                this.closeInputStreamAndReleaseResource(inputStream, resource);
                inputStream = null;
                resource = null;
                this.sendStreamStateEvent(StreamState.CLOSE.name(), fileName, this.sendCloseStreamEvent);
                if (this.auditEnabled) {
                    this.writeAudit(file.getName(), file.length(), startProcessing, endProcessing, fileRecordsReader.getRecordCounter(), fileRecordsReader.getSkippedCounter(), fileRecordsReader.getRejectedCounter());
                }
                EventSenders.sendFileProcessedEvent(file, this.datagramFactory, this.ctx, this.fileActionEventId);
                this.ctx.logInfo("File '" + fileName + "' has been parsed. Total records processed: " + fileRecordsReader.getRecordCounter() + ", skipped: " + fileRecordsReader.getSkippedCounter() + ", rejected: " + fileRecordsReader.getRejectedCounter() + ".");
                this.closeInputStreamAndReleaseResource(inputStream, resource);
                inputStream = null;
                resource = null;
            }
            catch (Exception error) {
                try {
                    this.ctx.logError(error.getMessage());
                    this.raiseException(error);
                    this.closeInputStreamAndReleaseResource(inputStream, resource);
                    inputStream = null;
                    resource = null;
                    this.sendStreamStateEvent(StreamState.ABORT.name(), fileName, this.sendAbortStreamEvent);
                    this.closeInputStreamAndReleaseResource(inputStream, resource);
                    inputStream = null;
                    resource = null;
                }
                catch (Throwable throwable) {
                    this.closeInputStreamAndReleaseResource(inputStream, resource);
                    inputStream = null;
                    resource = null;
                    throw throwable;
                }
            }
        } else {
            this.ctx.logDebug("Specified file '" + fileName + "' does not exist. Skipping...");
        }
    }

    private void closeInputStreamAndReleaseResource(InputStream inputStream, FileResourceManagerFactory.FileResource resource) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resource != null) {
            FileResourceManagerFactory.releaseResource((FileResourceManagerFactory.FileResource)resource);
        }
    }

    private FileRecordsReader createFileRecordsReader() {
        FileRecordsReader fileReader = this.fileDescriptorFactory.createFileRecordsReader();
        fileReader.setRecordLimit(this.recordLimit);
        fileReader.setExceptionStrategy(new FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy(){

            public FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy.StrategyAction onException(FileDescriptorFactory.FileDescriptorProcessingException exception) {
                if (exception.getAction() == FileDescriptorFactory.FileDescriptorProcessingException.RecordAction.REJECTED) {
                    FileReader.this.ctx.logError(exception.getMessageForLog());
                } else {
                    FileReader.this.ctx.logDebug(exception.getMessageForLog());
                }
                return FileDescriptorFactory.FileDescriptorProcessorExceptionStrategy.StrategyAction.CONTINUTE;
            }
        });
        fileReader.setRecordListener(new FileDescriptorFactory.RecordListener(){

            public void onRecord(Object recordObject, AbstractRecordTypeDefinition recordDefinition) {
                if (recordObject != null) {
                    String eventId = ((RecordTypeDefinition)recordDefinition).getEventId();
                    try {
                        DataEvent event = (DataEvent)EventDatagramFactory.getInstance().createEvent(eventId);
                        event.setData(recordObject);
                        FileReader.this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
                        FileReader.this.ctx.logDebug("Actionable Event [" + eventId + "] raised with '" + recordDefinition.getTypeKey() + "' record.");
                    }
                    catch (Exception error) {
                        FileReader.this.ctx.logError("Raise of actionable event [" + eventId + "] failed. " + error.getMessage());
                    }
                }
            }

            public void onGroupRecord(Object recordObject, String type, String key) {
                if (FileReader.this.recordGroupEventId != null && FileReader.this.recordGroupEventId.length() > 0) {
                    try {
                        MapEvent mapEvent = (MapEvent)EventDatagramFactory.getInstance().createEvent(FileReader.this.recordGroupEventId);
                        mapEvent.setString("Position", type);
                        if (FileReader.this.fileDescriptor.getRecordGroupAnnotations() != null) {
                            for (Map.Entry entry : FileReader.this.fileDescriptor.getRecordGroupAnnotations().entrySet()) {
                                Object value = FileReader.this.fileDescriptorFactory.getSdrManager().getValueAtPath((String)entry.getValue(), recordObject);
                                mapEvent.setObject((String)entry.getKey(), value);
                            }
                        }
                        FileReader.this.ctx.raiseEvent((ImmutableEventDatagram)mapEvent, 0L);
                        FileReader.this.ctx.logDebug("Event [" + FileReader.this.recordGroupEventId + "] raised for " + type + " of record '" + key + "' group.");
                    }
                    catch (Exception error) {
                        FileReader.this.ctx.logError("Unable to raise record group event [" + FileReader.this.recordGroupEventId + "]. " + error.getMessage());
                    }
                }
            }
        });
        return fileReader;
    }

    private void writeAudit(String fileName, long fileSize, long processingStart, long processingEnd, int processedRecords, int skippedRecords, int rejectedRecords) throws FabricComponentAccessorException {
        if (this.auditDsAccessor != null) {
            try {
                RowSet rowSet = this.auditDsAccessor.executeQuery("update [" + this.auditDataspace + "].[" + this.auditCollection + "] set FileSize=?, ProcessingStart=?, ProcessingEnd=?, ProcessedRecords=?, SkippedRecords=?, RejectedRecords=? where FileName=?", new Object[]{fileSize, new Timestamp(processingStart), new Timestamp(processingEnd), processedRecords, skippedRecords, rejectedRecords, fileName});
                if (!rowSet.next() || rowSet.getInt(1) == 0) {
                    this.auditDsAccessor.executeQuery("insert into [" + this.auditDataspace + "].[" + this.auditCollection + "] values(?, ?, ?, ?, ?, ?, ?)", new Object[]{fileName, fileSize, new Timestamp(processingStart), new Timestamp(processingEnd), processedRecords, skippedRecords, rejectedRecords});
                }
            }
            catch (Exception exception) {
                this.ctx.logError("Unable to write audit for processed file '" + fileName + "'. " + Utils.formatExceptionWithUnrepeatedCauses((Throwable)exception));
            }
        }
    }

    protected void doInit() {
        try {
            super.doInit();
            if (!this.sco.getServiceConfigurationProperties().hasProperty("source.dispatch.model")) {
                throw new RuntimeException("Source Dispatch Model should be specified.");
            }
            this.dispatchModel = SourceDispatchModel.valueOf(this.ctx.lookupEnumProperty("source.dispatch.model"));
            this.ctx.logInfo("Source Dispatch Model : " + String.valueOf((Object)this.dispatchModel));
            if (this.dispatchModel == SourceDispatchModel.FILE_POLL || this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
                this.pollingInterval = this.ctx.lookupNumericProperty("polling.interval");
                this.ctx.logDebug("Polling Interval : " + this.pollingInterval);
                this.pollingFileName = this.ctx.lookupStringProperty("polling.file.name");
                this.ctx.logDebug("Polling File Name : " + this.pollingFileName);
            }
            if (this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
                this.startFilePosition = StartFilePosition.valueOf(this.ctx.lookupEnumProperty("start.file.position"));
                this.noContentAlertTimeout = this.ctx.lookupNumericProperty("no.content.alert.timeout").intValue();
            }
            this.streamStateEventId = this.ctx.lookupStringProperty("stream.state.eventid");
            this.ctx.logDebug("Stream State Event Id : [" + this.streamStateEventId + "]");
            this.fileActionEventId = this.ctx.lookupStringProperty("file.action.eventid");
            this.ctx.logDebug("File Action Event Id : [" + this.fileActionEventId + "]");
            this.recordGroupEventId = this.ctx.lookupStringProperty("file.record.group.eventid");
            this.ctx.logDebug("Record Group Event Id : [" + this.recordGroupEventId + "]");
            if (this.sco.getServiceConfigurationProperties().hasProperty("encoding") && this.sco.getServiceConfigurationProperties().getProperty("encoding") != null) {
                this.encoding = this.ctx.lookupStringProperty("encoding");
                this.ctx.logInfo("Encoding for parsing file : " + this.encoding);
            }
            ObjectPropertyValue fileMetadataProperty = this.ctx.lookupObjectProperty("file.descriptor");
            SemanticObjectReferenceStore.beginXact((FabricComponent)this.ctx);
            this.fileDescriptor = (FileDescriptor)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)fileMetadataProperty);
            SemanticObjectReferenceStore.commitXact();
            this.ctx.logInfo("File Descriptor " + fileMetadataProperty.getObjectName() + " at " + fileMetadataProperty.getReferenceContext().toString() + " is loaded.");
            if (this.fileDescriptor.getDelimiter() != null && this.fileDescriptor.getDelimiter().length() > 0) {
                this.ctx.logInfo("Delimited file mode. Delimiter: '" + this.fileDescriptor.getDelimiter() + "'.");
            } else {
                this.ctx.logInfo("Delimited is not specified. Positional file mode.");
            }
            this.fileDescriptorFactory = new FileDescriptorFactory();
            this.fileDescriptorFactory.init(this.fileDescriptor, this.context.getSystemClassLoaderChain(), (FabricContext)this.context);
            this.fileDescriptorFactory.setLogger(this.ctx.getLogger());
            FileDescriptorRecord untypedRecord = this.fileDescriptor.getRecords().stream().filter(r -> r instanceof UntypedRecordTypeDefinition).findAny().orElse(null);
            if (untypedRecord != null) {
                throw new ServiceConfigurationException("File reader service doesn't support untyped record types like '" + untypedRecord.getTypeName() + "'.");
            }
            this.sendOpenStreamEvent = this.ctx.lookupBooleanProperty("raise.open.stream.event");
            this.ctx.logDebug("Sending of open stream event enabled : " + this.sendOpenStreamEvent);
            this.sendCloseStreamEvent = this.ctx.lookupBooleanProperty("raise.close.stream.event");
            this.ctx.logDebug("Sending of close stream event enabled : " + this.sendCloseStreamEvent);
            this.sendAbortStreamEvent = this.ctx.lookupBooleanProperty("raise.abort.stream.event");
            this.ctx.logDebug("Sending of abort stream event enabled : " + this.sendAbortStreamEvent);
            if (this.sco.getServiceConfigurationProperties().hasProperty("record.limit")) {
                this.recordLimit = this.ctx.lookupNumericProperty("record.limit");
                if (this.recordLimit > 0L) {
                    this.ctx.logInfo("Record limit is set to " + this.recordLimit + " records.");
                }
            }
            if (this.sco.getServiceConfigurationProperties().hasProperty("audit.enabled")) {
                this.auditEnabled = this.ctx.lookupBooleanProperty("audit.enabled");
                if (this.auditEnabled) {
                    this.auditDataspace = this.ctx.lookupStringProperty("audit.dataspace");
                    this.auditCollection = this.ctx.lookupStringProperty("audit.collection");
                    this.checkAuditCollection();
                    this.ctx.logInfo("Processed file audit enabled. Audit dataspace : " + this.auditDataspace + ", audit collection : " + this.auditCollection + ".");
                }
            }
            this.datagramFactory = EventDatagramFactory.getInstance();
        }
        catch (ServiceConfigurationException error) {
            throw new RuntimeException(error);
        }
        catch (Exception error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
            throw new RuntimeException(error);
        }
    }

    public void start() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL || this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
            super.start();
        } else {
            this.activated = true;
        }
    }

    public void resume() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL || this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
            super.resume();
        } else {
            this.activated = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL) {
            super.stop();
            return;
        } else if (this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
            super.stop();
            if (this.fileRecordsReader != null) {
                this.fileRecordsReader.finish();
            }
            if (this.inputStream != null) {
                this.sendStreamStateEvent(StreamState.CLOSE.name(), this.pollingFileName, this.sendCloseStreamEvent);
            }
            try {
                InputStream is = this.inputStream;
                if (is == null) return;
                is.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
            finally {
                this.inputStream = null;
                this.fileRecordsReader = null;
                this.fileLinesReader = null;
            }
        } else {
            this.activated = false;
        }
    }

    public void suspend() throws ServiceFrameworkException {
        if (this.dispatchModel == SourceDispatchModel.FILE_POLL || this.dispatchModel == SourceDispatchModel.FILE_STREAM) {
            super.suspend();
        } else {
            this.activated = false;
        }
    }

    public void destroy() throws ServiceFrameworkException {
        if (this.auditDsAccessor != null) {
            this.auditDsAccessor.close();
            this.auditDsAccessor = null;
        }
        super.destroy();
    }

    public void sendStreamStateEvent(String state, String filename, boolean sendStreamEvent) {
        try {
            if (sendStreamEvent) {
                MapEvent event = (MapEvent)this.datagramFactory.createEvent(this.streamStateEventId);
                event.setString("StreamState", state);
                event.setString("Filename", filename);
                this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
            }
        }
        catch (Exception error) {
            Trace.logException((Object)((Object)this), (Throwable)error, (boolean)true);
        }
    }

    private void raiseException(Exception exception) {
        try {
            ServiceFrameworkException ex = new ServiceFrameworkException(6002, exception.getMessage());
            ex.setSeverity(Severity.SEVERE);
            this.ctx.raiseException((ExceptionEventDatagram)ex);
        }
        catch (Exception ex) {
            Trace.logError((Object)((Object)this), (String)ex.getMessage());
        }
    }

    private void checkAuditCollection() throws Exception {
        DataspaceManager manager = RuntimeContext.getInstance().getDataspaceManager();
        if (!manager.existsDataspace(this.auditDataspace)) {
            manager.createDataspace(DataspaceType.TSPACE, this.auditDataspace, EventScope.GLOBAL);
        }
        this.auditDsAccessor = this.ctx.createDataspaceAccessor(DataspaceType.TSPACE, this.auditDataspace);
        if (this.auditDsAccessor == null || !this.auditDsAccessor.isAvailable()) {
            throw new IllegalStateException("Unable to open accessor to dataspace with audit.");
        }
        SLResponse response = this.auditDsAccessor.invokeLanguageRequest("create persistent table if not exists [" + this.auditCollection + "] (   FileName string, FileSize long, ProcessingStart sqltimestamp, ProcessingEnd sqltimestamp, ProcessedRecords int, SkippedRecords int, RejectedRecords int) ");
        if (response == null || !response.isOK()) {
            throw new IllegalStateException("Unable to initialize snapshot collection.");
        }
    }

    protected Class<?> loadClass(String className) throws Exception {
        return ClassUtils.loadClass((String)className, (ClassLoader)this.ctx.getPackageManifestManager().getManifestClassLoader());
    }

    protected Object instantiateClass(Class<?> clazz) throws Exception {
        return ReflectionProvider.getInstance().newInstance(clazz);
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.file");
        SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.file.parsed");
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"FileReader", (boolean)false);
        sco.setServiceClassName(FileReader.class.getName());
        sco.setServiceDescription("Parses file and creates event stream out of it.");
        sco.setServiceDisplayName("File Reader");
        sco.setInvokeMode(InvokeMode.ASYNC);
        EventHandler handler = new EventHandler((AbstractServiceConfigurationObject)sco, "processFile", "ParseRequestHandler");
        EventDatagram prototype = EventDatagramFactory.getInstance().createEvent("event.file");
        handler.bindRequestEvent((ImmutableEventDatagram)prototype);
        handler.bindVoidResponseObject("event.file.parsing.completed");
        sco.addEventHandler(handler);
        ServiceConfigurationProperty prop = sco.createProperty("source.dispatch.model", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Source Dispatch Model");
        prop.setDescription("Specifies source dispatch model, whether poll specified folder for file or wait an event request.");
        prop.setRange(String.valueOf((Object)SourceDispatchModel.FILE_POLL) + "," + String.valueOf((Object)SourceDispatchModel.RAISED_EVENT) + "," + String.valueOf((Object)SourceDispatchModel.FILE_STREAM));
        prop.setValue(SourceDispatchModel.RAISED_EVENT.name());
        sco.addProperty(prop);
        prop = sco.createProperty("polling.file.name", ServicePropertyType.STRING, null);
        prop.setLabel("Polling File Name");
        prop.setDescription("Specifies name (mask) of the file for polling.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("polling.interval", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Polling Interval");
        prop.setDescription("Specifies polling interval.");
        prop.setValue((Object)1000);
        sco.addProperty(prop);
        prop = sco.createProperty("file.action.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("File Action Event Id");
        prop.setDescription("Specifies Event Id of FileEvent which will be emitted once file is parsed.");
        prop.setValue("event.file.parsed");
        sco.addProperty(prop);
        prop = sco.createProperty("encoding", ServicePropertyType.STRING, null);
        prop.setLabel("File Encoding");
        prop.setDescription("Specifies encoding of file to be parsed.");
        prop.setValue("ISO-8859-1");
        sco.addProperty(prop);
        prop = sco.createProperty("stream.state.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("Stream State Event Id");
        prop.setDescription("Specifies EventId of the MapEvent with StreamState and Filename which is sent on stream state change.Additionally to values of StreamState enum the following values added: UNAVAILABLE, RECOVERED, NO_CONTENT, TRUNCATED and ERROR.");
        prop.setValue("event.stream.state.changed");
        sco.addProperty(prop);
        prop = sco.createProperty("raise.abort.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Abort Stream Event");
        prop.setDescription("Specifies whether StreamState should be sent in case of stream abort.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.open.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Open Stream Event");
        prop.setDescription("Specifies whether StreamState should be sent in case of stream opened.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("raise.close.stream.event", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Raise Close Stream Event");
        prop.setDescription("Specifies whether StreamState should be sent in case of stream closed.");
        prop.setValue((Object)true);
        sco.addProperty(prop);
        prop = sco.createProperty("file.record.group.eventid", ServicePropertyType.STRING, null);
        prop.setLabel("Record Group Event Id");
        prop.setDescription("Specifies EventId of the MapEvent which is sent when a new group is started.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("file.descriptor", ServicePropertyType.OBJECT, null);
        prop.setLabel("File Descriptor");
        prop.setDescription("Specifies file descriptor with file meta information.");
        prop.setValue((Object)new ObjectPropertyValue("fileDescriptor", "FileDescriptor", new ReferenceContext(new ReferenceContext(null, null), FileDescriptor.FILE_DESCRIPTOR_OBJECTS_NAMESPACE)));
        sco.addProperty(prop);
        prop = sco.createProperty("record.limit", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Record Limit");
        prop.setDescription("Specifies maximum number of records which should be read from the file.");
        prop.setValue((Object)0L);
        sco.addProperty(prop);
        prop = sco.createProperty("audit.enabled", ServicePropertyType.BOOLEAN, null);
        prop.setLabel("Audit Enabled");
        prop.setDescription("Specifies whether the audit for processed file need to be written.");
        prop.setValue((Object)false);
        sco.addProperty(prop);
        prop = sco.createProperty("audit.dataspace", ServicePropertyType.STRING, null);
        prop.setLabel("Audit Dataspace Name");
        prop.setDescription("Specifies dataspace where audit information should be stored.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("audit.collection", ServicePropertyType.STRING, null);
        prop.setLabel("Audit Collection Name");
        prop.setDescription("Specifies collection name where audit information should be stored.");
        prop.setValue("");
        sco.addProperty(prop);
        prop = sco.createProperty("start.file.position", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Start File Position");
        prop.setDescription("Specifies file position where to start reading in case of FILE_STREAM dispatch model.");
        prop.setRange(StartFilePosition.HEAD.name() + "," + StartFilePosition.TAIL.name());
        prop.setValue(StartFilePosition.HEAD.name());
        sco.addProperty(prop);
        prop = sco.createProperty("no.content.alert.timeout", ServicePropertyType.NUMERIC, null);
        prop.setLabel("No Content Alert Timeout");
        prop.setDescription("Specifies time in seconds to wait since last data was read from the file and before sending alert. Value of 0 means don't send.");
        prop.setValue((Object)0);
        sco.addProperty(prop);
        sco.addActionableEvent("event.file.parsed");
        sco.addActionableEvent("event.file.record");
        sco.addActionableEvent("event.stream.state.changed");
        return sco;
    }

    static {
        try {
            SDOUtils.addEventPrototype((String)"FileEvent", (String)"event.file");
        }
        catch (Exception error) {
            Trace.logError(FileReader.class, (String)"Unable to add FileEvent event prototype {} for file records group.", (Object[])new Object[]{"event.file"});
        }
    }
}

