/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.file;

import com.streamscape.service.file.FileReaderEventListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileRecordEventSource {
    private FileReaderEventListener listener;
    private RandomAccessFile aFile;
    private String aFileBuffer = "ZZZ";
    private byte[] aBinaryBuffer;
    private String aRecordDelimiter = "";
    private int aBufferSize = 0;
    private boolean isBinary = false;
    private long recordCount = 0L;
    private long startTime;
    private long endTime;
    private long elapsedTime;

    public void setFileRecordEventListener(FileReaderEventListener llistener) {
        this.listener = llistener;
    }

    public FileReaderEventListener getFileRecordEventListener() {
        return this.listener;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    public void setRecordDelimiter(String delimiter) {
        if (this.isBinary) {
            this.aRecordDelimiter = delimiter;
        }
    }

    public void setBufferSize(int buffSz) {
        this.aBufferSize = buffSz;
    }

    public int getBufferSize() {
        return this.aBufferSize;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public long getFileSize() {
        if (this.aFile == null) {
            return -2L;
        }
        try {
            return this.aFile.length();
        }
        catch (IOException ex) {
            System.out.println("getFileSize() Exception: " + ex.getMessage());
            return 0L;
        }
    }

    public void openFile(String fileURL, boolean isBinaryFile) throws IOException {
        this.aFile = new RandomAccessFile(fileURL, "r");
        this.isBinary = isBinaryFile;
    }

    public long invoke() {
        if (this.aFile == null) {
            return -2L;
        }
        this.recordCount = 0L;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.elapsedTime = 0L;
        this.aFileBuffer = "ZZZ";
        try {
            if (!this.isBinary) {
                while (this.aFileBuffer != null) {
                    this.aFileBuffer = this.aFile.readLine();
                    if (this.aFileBuffer == null) continue;
                    ++this.recordCount;
                    if (this.listener == null) continue;
                    this.listener.onData(this.aFileBuffer, this.recordCount);
                }
            } else if (!this.aRecordDelimiter.equals("")) {
                System.out.println("delimited buffer read..");
                char byteRead = '\u0000';
                BufferedReader in = new BufferedReader(new FileReader(this.aFile.getFD()));
                ByteArrayOutputStream byteBuf = new ByteArrayOutputStream();
                while (byteRead != '\uffffffff') {
                    byteRead = in.read();
                    if (byteRead != this.aRecordDelimiter.charAt(0)) {
                        byteBuf.write(byteRead);
                        continue;
                    }
                    ++this.recordCount;
                    if (this.listener != null) {
                        this.listener.onData(byteBuf.toByteArray(), this.recordCount);
                    }
                    byteBuf.reset();
                }
            } else if (this.getBufferSize() != 0) {
                System.out.println("buffered read..");
                int bytesRead = 0;
                this.aBinaryBuffer = new byte[this.getBufferSize()];
                while (bytesRead != -1) {
                    bytesRead = this.aFile.read(this.aBinaryBuffer);
                    if (bytesRead == -1) continue;
                    ++this.recordCount;
                    if (this.listener == null) continue;
                    this.listener.onData(this.aBinaryBuffer, this.recordCount);
                }
            } else {
                Long fileSize = new Long(this.aFile.length());
                this.aBinaryBuffer = new byte[fileSize.intValue()];
                this.aFile.readFully(this.aBinaryBuffer);
                ++this.recordCount;
                if (this.listener != null) {
                    this.listener.onData(this.aBinaryBuffer, this.recordCount);
                }
            }
        }
        catch (IOException ioe) {
            System.out.println("I/O Exception: " + ioe.getMessage());
        }
        this.endTime = System.currentTimeMillis();
        this.elapsedTime = this.endTime - this.startTime;
        return this.recordCount;
    }

    public void closeFile() throws IOException {
        if (this.aFile == null) {
            return;
        }
        this.aFile.close();
        this.aFile = null;
    }
}

