/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.file;

import com.streamscape.service.file.FileDirectoryFilter;
import java.io.File;
import java.util.Arrays;
import java.util.ListIterator;

public class FileAccessUtils {
    public static boolean fileResourceAvailable(String fileURL) {
        File fileResource = null;
        boolean exists = false;
        fileResource = new File(fileURL);
        exists = fileResource.exists();
        fileResource = null;
        return exists;
    }

    public static boolean fileResourceReadable(String fileURL) {
        File fileResource = null;
        boolean readable = false;
        if (FileAccessUtils.fileResourceAvailable(fileURL)) {
            fileResource = new File(fileURL);
            readable = fileResource.canRead();
            return readable;
        }
        return readable;
    }

    public static boolean fileResourceWritable(String fileURL) {
        File fileResource = null;
        boolean readable = false;
        if (FileAccessUtils.fileResourceAvailable(fileURL)) {
            fileResource = new File(fileURL);
            readable = fileResource.canWrite();
            return readable;
        }
        return readable;
    }

    public static boolean fileResourceRename(String oldURL, String newURL) {
        File newFile = null;
        if (FileAccessUtils.fileResourceAvailable(oldURL)) {
            File oldFile = new File(oldURL);
            newFile = new File(newURL);
            oldFile.renameTo(newFile);
            oldFile = null;
            newFile = null;
            return true;
        }
        return false;
    }

    public static boolean fileResourceDelete(String fileURL) {
        File fileResource = null;
        boolean rc = false;
        if (FileAccessUtils.fileResourceAvailable(fileURL)) {
            fileResource = new File(fileURL);
            rc = fileResource.delete();
            return rc;
        }
        return false;
    }

    public static String[] fileDirectoryAbsoluteList(String directoryURL, String fileFilter) {
        File[] files = null;
        String[] absoluteFiles = null;
        int idx = 0;
        if (!fileFilter.equals("")) {
            FileDirectoryFilter filter = new FileDirectoryFilter();
            filter.setFileExtension(fileFilter);
            File dir = new File(directoryURL);
            files = dir.listFiles(filter);
            ListIterator<File> filesList = Arrays.asList(files).listIterator();
            absoluteFiles = new String[Arrays.asList(files).size()];
            while (filesList.hasNext()) {
                absoluteFiles[idx] = new String(filesList.next().getAbsolutePath());
                ++idx;
            }
        } else {
            File dir = new File(directoryURL);
            files = dir.listFiles();
            ListIterator<File> filesList = Arrays.asList(files).listIterator();
            absoluteFiles = new String[Arrays.asList(files).size()];
            while (filesList.hasNext()) {
                absoluteFiles[idx] = new String(filesList.next().getAbsolutePath());
                ++idx;
            }
        }
        return absoluteFiles;
    }

    public static String[] fileDirectoryList(String directoryURL, String fileFilter) {
        String[] files = null;
        if (!fileFilter.equals("")) {
            FileDirectoryFilter filter = new FileDirectoryFilter();
            filter.setFileExtension(fileFilter);
            File dir = new File(directoryURL);
            files = dir.list(filter);
        } else {
            File dir = new File(directoryURL);
            files = dir.list();
        }
        return files;
    }
}

