/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.dbms;

import com.streamscape.omf.xml.XSerializer;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryFactory;
import com.streamscape.service.dbms.QueryType;
import java.sql.Connection;
import java.sql.DriverManager;

public class QueryBuilder {
    String server = null;
    String port = null;
    String user = null;
    String password = null;
    String database = null;
    QueryType queryType = null;
    String table = null;
    String storedProc = null;

    public static void main(String[] args) {
        try {
            QueryBuilder builder = new QueryBuilder();
            builder.parseParameters(args);
            builder.exec();
        }
        catch (Exception error) {
            System.out.println("ERROR: " + error.getMessage());
        }
    }

    public void parseParameters(String[] args) {
        int index = 0;
        int counter = 0;
        for (String param : args) {
            System.out.println("Parameter [" + ++counter + "]=" + param);
        }
        if (args.length != 14) {
            this.printSyntax();
            System.exit(1);
        }
        while (index < args.length) {
            String param = args[index];
            if (param.equals("-server") && index < args.length - 1) {
                this.server = args[++index];
            } else if (param.equals("-port") && index < args.length - 1) {
                this.port = args[++index];
            } else if (param.equals("-db") && index < args.length - 1) {
                this.database = args[++index];
            } else if (param.equals("-user") && index < args.length - 1) {
                this.user = args[++index];
            } else if (param.equals("-pwd") && index < args.length - 1) {
                this.password = args[++index];
            } else if (param.equals("-queryType") && index < args.length - 1) {
                this.queryType = QueryType.valueOf(args[++index]);
            } else if (param.equals("-table") && index < args.length - 1) {
                this.table = args[++index];
            } else if (param.equals("-procName") && index < args.length - 1) {
                this.storedProc = args[++index];
            } else {
                this.printSyntax();
                System.exit(1);
            }
            ++index;
        }
    }

    private void printSyntax() {
        System.out.println("Syntax: \nQueryBuilder -server <server> -port <port> -db <database> -user <user> -pwd <password> -queryType (SELECT|INSERT|UPDATE|DELETE|CALL) (-table <tableName>|-procName <procName>)");
    }

    public void exec() throws Exception {
        XSerializer serializer;
        RuntimeContext.getInstance();
        Class.forName("com.microsoft.sqlserver.jdbc.SQLServerDriver").newInstance();
        Connection connection = DriverManager.getConnection("jdbc:sqlserver://" + this.server + ":" + this.port, this.user, this.password);
        connection.setCatalog(this.database);
        SQLQuery query = null;
        switch (this.queryType) {
            case SELECT: {
                if (this.table != null) {
                    query = SQLQueryFactory.createForSelect((Connection)connection, (String)this.table);
                    break;
                }
                throw new RuntimeException("-table parameter should be specified for 'SELECT' query type.");
            }
            case INSERT: {
                if (this.table != null) {
                    query = SQLQueryFactory.createForInsert((Connection)connection, (String)this.table);
                    break;
                }
                throw new RuntimeException("-table parameter should be specified for 'INSERT' query type.");
            }
            case UPDATE: {
                if (this.table != null) {
                    query = SQLQueryFactory.createForUpdate((Connection)connection, (String)this.table);
                    break;
                }
                throw new RuntimeException("-table parameter should be specified for 'UPDATE' query type.");
            }
            case DELETE: {
                if (this.table != null) {
                    query = SQLQueryFactory.createForDelete((Connection)connection, (String)this.table);
                    break;
                }
                throw new RuntimeException("-table parameter should be specified for 'DELETE' query type.");
            }
            case CALL: {
                if (this.storedProc != null) {
                    query = SQLQueryFactory.createForCall((Connection)connection, (String)this.storedProc);
                    break;
                }
                throw new RuntimeException("-procName parameter should be specified for 'CALL' query type.");
            }
        }
        if (query != null) {
            XSerializerFactory factory = XSerializerFactory.getInstance();
            serializer = factory.getDefaultSerializer();
            SemanticType type = new SemanticType("SQLQuery", SQLQuery.class.getName());
            if (!factory.isAliased(type.getTypeName())) {
                factory.alias(type);
            }
        } else {
            throw new RuntimeException("Unable to build the query. Please check the parameters.");
        }
        System.out.println(serializer.serialize((Object)query));
    }
}

