/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.correlator.evSink;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerTask;
import com.streamscape.lib.utils.SQLType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationFactory;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.IAbstractDataEvent;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.service.AbstractCancellableService;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.dsl.DSLProcessor;
import com.streamscape.sef.service.dsl.DSLSyntaxFactory;
import com.streamscape.sef.service.dsl.DSLSyntaxFactoryManager;
import com.streamscape.service.correlator.evSink.EventSetState;
import com.streamscape.service.correlator.evSink.MatchStrategy;
import com.streamscape.service.correlator.evSink.Version;
import com.streamscape.service.osf.config.ServiceConfigurationProperty;
import com.streamscape.service.osf.config.ServicePropertyType;
import com.streamscape.service.osf.eim.EventIdentity;
import com.streamscape.service.osf.enums.InvokeMode;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EventCorrelator
extends AbstractCancellableService
implements DSLProcessor {
    public static final String CORRELATOR_EVENT_ID = "event.Correlator";
    public static final String EVENT_SET_STATE = "EventSetState";
    public static final String EVENT_CORRELATOR_TIMER = "EventCorrelatorTimer";
    public static final String SHOW_EVENT_SET_OP = "ShowEventSet";
    protected Pattern EVENT_ID_AND_SELECTOR = Pattern.compile("(?i)([^\\s]+)\\s+when\\s+(.+)");
    protected Pattern MATCH_ON_PATTHERN = Pattern.compile("(?i)MATCH\\s+ON\\s*\\(([^\\)]+)\\)\\s*(not\\s+null)?");
    protected Pattern MATCH_ON_PROPERTY_PATTERN = Pattern.compile("(?i)MATCH\\s+ON\\s+PROPERTY\\s*\\(([^\\)]+)\\)\\s*(not\\s+null)?");
    protected Pattern MATCH_ON_IDENTITY_PATTERN = Pattern.compile("(?i)MATCH\\s+ON\\s+IDENTITY\\s*\\(([^\\)]+)\\)\\s*(not\\s+null)?");
    protected Pattern SIMPLE_EXPRESSION = Pattern.compile("(?i)([^\\s]+)");
    protected Pattern EVENT_PROPERTY_EXPRESSION = Pattern.compile("(?i)([^\\s]+)\\s+([<>=!]+)\\s+([^\\s]+)");
    protected Pattern STRING_VALUE_EXPRESSION = Pattern.compile("(?i)([^\\s]+)\\s+([<>=!]+)\\s+'([^']+)'");
    protected Pattern NON_STRING_VALUE_EXPRESSION = Pattern.compile("(?i)([^\\s]+)\\s+([<>=!]+)\\s+([\\d\\.\\+\\-]+)");
    protected FabricConnection connection = null;
    protected EventDatagramFactory datagramFactory = null;
    protected EventIdentity eim = new EventIdentity();
    protected MatchStrategy matchStrategy = null;
    protected long timeout = 0L;
    protected FabricTimer timer = null;
    protected List<String> matchingEventIds = new ArrayList<String>();
    protected List<MatchingRule> matchingRules = new ArrayList<MatchingRule>();
    protected List<EventConsumer> consumers = new ArrayList<EventConsumer>();
    protected Map<String, ImmutableEventDatagram> eventSet = new HashMap<String, ImmutableEventDatagram>();

    protected void updateEventSet(String eventIdAndSelector, ImmutableEventDatagram event) {
        if (this.eventSet.get(event.getEventId()) != null) {
            return;
        }
        boolean matched = true;
        for (MatchingRule rule : this.matchingRules) {
            if (rule.match(event)) continue;
            matched = false;
        }
        if (this.sco.existsActionableEvent(event.getEventId())) {
            try {
                this.ctx.raiseEvent(event, 0L);
            }
            catch (Exception error) {
                Trace.logError((Object)((Object)this), (String)("Unable to passthru incoming event. " + error.getMessage()));
            }
        }
        if (!matched) {
            this.raiseException((ExceptionEventDatagram)new ServiceFrameworkException(6000, "Incoming event does not match specified rules. Rejected."));
            return;
        }
        if (this.eventSet.size() == 0 && event instanceof IAbstractDataEvent) {
            this.eim.eventGroupId = ((IAbstractDataEvent)event).getEventGroupId();
            this.eim.correlationId = ((IAbstractDataEvent)event).getCorrelationIdAsBytes();
            this.eim.eventKey = ((IAbstractDataEvent)event).getEventKey();
        }
        if (this.eventSet.size() == 0 && this.timer != null && this.matchStrategy == MatchStrategy.TRIGGERED_TIMER) {
            try {
                this.timer.start();
            }
            catch (Exception error) {
                Trace.logError((Object)((Object)this), (String)("Unable to start timer. " + error.getMessage()));
            }
        }
        this.eventSet.put(event.getEventId(), event);
        if (this.eventSet.size() == this.matchingEventIds.size()) {
            if (this.timer != null) {
                try {
                    this.timer.cancel();
                }
                catch (Exception error) {
                    Trace.logError((Object)((Object)this), (String)("Unable to cancel the timer. " + error.getMessage()));
                }
            }
            this.raiseCorrelatorEvent(EventSetState.COMPLETE);
            this.eventSet.clear();
        } else {
            this.raiseCorrelatorEvent(EventSetState.MODIFIED);
        }
    }

    protected void resetEventSet() {
        if (this.eventSet.size() > 0) {
            this.raiseCorrelatorEvent(EventSetState.INCOMPLETE);
        } else {
            this.raiseCorrelatorEvent(EventSetState.NULL);
        }
        this.eventSet.clear();
    }

    protected void raiseCorrelatorEvent(EventSetState state) {
        try {
            MapEvent event = (MapEvent)this.datagramFactory.createEvent(CORRELATOR_EVENT_ID);
            event.setString(EVENT_SET_STATE, state.name());
            for (ImmutableEventDatagram eventSetEntity : this.eventSet.values()) {
                if (!(eventSetEntity instanceof IAbstractDataEvent)) continue;
                for (String prop : ((IAbstractDataEvent)eventSetEntity).getEventPropertyNames()) {
                    event.setObject(prop, ((IAbstractDataEvent)eventSetEntity).getEventObjectProperty(prop));
                }
            }
            event.setEventGroupId(this.eim.eventGroupId);
            event.setCorrelationIdAsBytes(this.eim.correlationId);
            event.setEventKey(this.eim.eventKey);
            this.ctx.raiseEvent((ImmutableEventDatagram)event, 0L);
        }
        catch (Exception error) {
            Trace.logError((Object)((Object)this), (String)("Unable to send correlator event. " + error.getMessage()));
        }
    }

    public void doInit() {
        try {
            this.datagramFactory = this.context.getEventDatagramFactory();
        }
        catch (RuntimeException error) {
            this.ctx.logError("Service instantiation error: " + error.getMessage());
        }
        try {
            List rules = this.ctx.lookupListProperty("matching.rules");
            for (ServiceConfigurationProperty rule : rules) {
                MatchingRule matchingRule = this.parseMatchingRule(rule.getValue().toString());
                this.matchingRules.add(matchingRule);
            }
            this.connection = new FabricConnectionFactory().createConnection();
            this.connection.setName("EventCorrelatorConnection");
            this.connection.open();
            int counter = 0;
            List eventIds = this.ctx.lookupListProperty("events");
            for (ServiceConfigurationProperty eventId : eventIds) {
                String eventIdValue = eventId.getValue().toString();
                MatchingEventListener listener = new MatchingEventListener(eventIdValue);
                String selector = null;
                Matcher matcher = this.EVENT_ID_AND_SELECTOR.matcher(eventIdValue.trim());
                if (matcher.find()) {
                    eventIdValue = matcher.group(1);
                    selector = matcher.group(2);
                }
                Object consumer = null;
                consumer = this.sco.getInvokeMode() == InvokeMode.ASYNC ? this.connection.createEventAsyncConsumer("Consumer" + ++counter, (FabricEventListener)listener, eventIdValue, selector, EventScope.INHERITED, false) : this.connection.createEventConsumer("Consumer" + ++counter, (FabricEventListener)listener, eventIdValue, selector, EventScope.INHERITED, false);
                if (consumer == null) {
                    throw new IllegalArgumentException("Unable to create consumer for '" + eventId.getValue().toString() + "'.");
                }
                this.consumers.add((EventConsumer)consumer);
                this.matchingEventIds.add(eventIdValue);
            }
            if (this.sco.hasProperty("exceptions")) {
                List exceptions = this.ctx.lookupListProperty("exceptions");
                for (ServiceConfigurationProperty exceptionEventId : exceptions) {
                    String eventId = exceptionEventId.getValue().toString();
                    MatchingExceptionListener listener = new MatchingExceptionListener();
                    Object consumer = null;
                    consumer = this.sco.getInvokeMode() == InvokeMode.ASYNC ? this.connection.createEventAsyncConsumer("ExceptionConsumer" + ++counter, (FabricEventListener)listener, eventId, null, EventScope.INHERITED, false) : this.connection.createEventConsumer("ExceptionConsumer" + ++counter, (FabricEventListener)listener, eventId, null, EventScope.INHERITED, false);
                    if (consumer == null) {
                        throw new IllegalArgumentException("Unable to create exception consumer for '" + eventId + "'.");
                    }
                    this.consumers.add((EventConsumer)consumer);
                }
            }
            try {
                this.matchStrategy = MatchStrategy.valueOf(this.ctx.lookupEnumProperty("matching.strategy"));
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Invalid maching strategy '" + this.ctx.lookupEnumProperty("matching.strategy") + "' specified.");
            }
            this.timeout = this.ctx.lookupNumericProperty("timeout");
            FabricTimerManager manager = FabricTimerManager.getInstance();
            if (this.timeout > 0L) {
                switch (this.matchStrategy) {
                    case REPEATING_TIMER: {
                        this.timer = manager.createTimer("CORRELATION", EVENT_CORRELATOR_TIMER, (FabricTimerTask)new MatchTimerTask(), this.timeout, 0);
                        break;
                    }
                    case TRIGGERED_TIMER: {
                        this.timer = manager.createTimer("CORRELATION", EVENT_CORRELATOR_TIMER, (FabricTimerTask)new MatchTimerTask(), this.timeout, 1);
                    }
                }
            }
        }
        catch (Exception error) {
            this.reportAndRethrowError(error);
        }
    }

    public void resume() throws ServiceFrameworkException {
        super.resume();
        for (EventConsumer consumer : this.consumers) {
            if (!(consumer instanceof EventAsyncConsumer)) continue;
            ((EventAsyncConsumer)consumer).resume();
        }
        if (this.timer != null) {
            try {
                this.timer.resume();
            }
            catch (Exception error) {
                throw new ServiceFrameworkException(6065, (Throwable)error);
            }
        }
    }

    public void suspend() throws ServiceFrameworkException {
        if (this.timer != null) {
            try {
                this.timer.suspend();
            }
            catch (Exception error) {
                throw new ServiceFrameworkException(6065, (Throwable)error);
            }
        }
        for (EventConsumer consumer : this.consumers) {
            if (!(consumer instanceof EventAsyncConsumer)) continue;
            ((EventAsyncConsumer)consumer).suspend();
        }
        super.suspend();
    }

    public void start() throws ServiceFrameworkException {
        super.start();
        for (EventConsumer consumer : this.consumers) {
            if (!(consumer instanceof EventAsyncConsumer)) continue;
            ((EventAsyncConsumer)consumer).start();
        }
        if (this.timer != null && this.matchStrategy == MatchStrategy.REPEATING_TIMER) {
            try {
                this.timer.start();
            }
            catch (Exception error) {
                throw new ServiceFrameworkException(6065, (Throwable)error);
            }
        }
    }

    public void stop() throws ServiceFrameworkException {
        if (this.timer != null) {
            try {
                this.timer.stop();
            }
            catch (Exception error) {
                throw new ServiceFrameworkException(6066, (Throwable)error);
            }
        }
        for (EventConsumer consumer : this.consumers) {
            if (!(consumer instanceof EventAsyncConsumer)) continue;
            ((EventAsyncConsumer)consumer).stop();
        }
        super.stop();
    }

    public void cancel() throws ServiceFrameworkException {
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception error) {
                throw new ServiceFrameworkException(6065, (Throwable)error);
            }
        }
        this.resetEventSet();
        super.cancel();
    }

    public SLResponse onStatement(DSLStatement statement) throws Exception {
        if (statement.getName().equals(SHOW_EVENT_SET_OP)) {
            RowMetaData meta = new RowMetaData();
            meta.addColumn("EventId", SQLType.STRING);
            meta.addColumn("Matched", SQLType.STRING);
            RowSet rowset = new RowSet(meta);
            for (String eventId : this.matchingEventIds) {
                rowset.addToRowSet(new Object[]{eventId, this.eventSet.get(eventId) == null ? "-" : "x"});
            }
            return new SLResponse(rowset);
        }
        return new SLResponse("Operation '" + statement.getName() + "' is not supported.", false);
    }

    private void raiseException(ExceptionEventDatagram error) {
        try {
            this.ctx.raiseException(error);
        }
        catch (Exception ex) {
            System.out.println("Event dispatch exception: " + ex.getMessage() + " for SQL Error: " + error.getErrorMessage());
        }
    }

    private void reportAndRethrowError(Throwable error) {
        this.ctx.logError(error.getMessage());
        throw new RuntimeException(error);
    }

    public int getMinorBuild() {
        return Version.getBuild();
    }

    public int getMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getMinorVersion() {
        return Version.getMinorVersion();
    }

    public String getVersion() {
        return Version.getVersionString();
    }

    public static ServiceConfigurationObject generateSco() throws Exception {
        RuntimeContext.getInstance();
        SDOUtils.addEventPrototype((String)"MapEvent", (String)CORRELATOR_EVENT_ID);
        ServiceConfigurationObject sco = ServiceConfigurationFactory.createServiceConfiguration((FabricComponent)RuntimeContext.getInstance(), (String)"prototype", (String)"EventCorrelator", (boolean)false);
        sco.setServiceClassName(EventCorrelator.class.getName());
        sco.setServiceDescription("Performs event correlation.");
        sco.setServiceDisplayName("Event Correlation Service");
        sco.setInvokeMode(InvokeMode.DIRECT);
        sco.setInterruptableService(true);
        ServiceConfigurationProperty prop = null;
        prop = sco.createProperty("timeout", ServicePropertyType.NUMERIC, null);
        prop.setLabel("Matching Interval");
        prop.setDescription("Specifies an interval in millis within all events should come in.");
        prop.setValue((Object)1000L);
        sco.addProperty(prop);
        prop = sco.createProperty("matching.strategy", ServicePropertyType.ENUMERATION, null);
        prop.setLabel("Matching Strategy");
        prop.setDescription("Specifies the strategy for event matching.");
        prop.setRange(String.valueOf((Object)MatchStrategy.INFINITE_WAIT) + "," + String.valueOf((Object)MatchStrategy.REPEATING_TIMER) + "," + String.valueOf((Object)MatchStrategy.TRIGGERED_TIMER));
        prop.setValue(MatchStrategy.TRIGGERED_TIMER.name());
        sco.addProperty(prop);
        ArrayList<ServiceConfigurationProperty> events = new ArrayList<ServiceConfigurationProperty>();
        prop = sco.createProperty("events", ServicePropertyType.LIST, null);
        prop.setLabel("Event List");
        prop.setDescription("Specifies list of event IDs which need to be matched (with optional selector).");
        prop.setValue(events);
        sco.addProperty(prop);
        prop = sco.createProperty("event", ServicePropertyType.STRING, null);
        prop.setValue("event.test1");
        events.add(prop);
        prop = sco.createProperty("event", ServicePropertyType.STRING, null);
        prop.setValue("event.test2");
        events.add(prop);
        prop = sco.createProperty("event", ServicePropertyType.STRING, null);
        prop.setValue("event.test3");
        events.add(prop);
        ArrayList<ServiceConfigurationProperty> rules = new ArrayList<ServiceConfigurationProperty>();
        prop = sco.createProperty("matching.rules", ServicePropertyType.LIST, null);
        prop.setLabel("Matching Rule List");
        prop.setDescription("Specifies list matching rules which need to be applied for correlating events.");
        prop.setValue(rules);
        sco.addProperty(prop);
        prop = sco.createProperty("matching.rule", ServicePropertyType.STRING, null);
        prop.setValue("match on property (StringProperty)");
        rules.add(prop);
        prop = sco.createProperty("matching.rule", ServicePropertyType.STRING, null);
        prop.setValue("match on property (StringProperty == 'TestValue')");
        rules.add(prop);
        prop = sco.createProperty("matching.rule", ServicePropertyType.STRING, null);
        prop.setValue("match on property (LongProperty == 123)");
        rules.add(prop);
        prop = sco.createProperty("matching.rule", ServicePropertyType.STRING, null);
        prop.setValue("match on (event.test1.LongProperty == 123)");
        rules.add(prop);
        prop = sco.createProperty("matching.rule", ServicePropertyType.STRING, null);
        prop.setValue("match on (event.test1.FloatProperty == event.test3.FloatProperty)");
        rules.add(prop);
        ArrayList<ServiceConfigurationProperty> exceptions = new ArrayList<ServiceConfigurationProperty>();
        prop = sco.createProperty("exceptions", ServicePropertyType.LIST, null);
        prop.setLabel("Exceptions List");
        prop.setDescription("Specifies list of exceptions which can cancel current correlation.");
        prop.setValue(exceptions);
        sco.addProperty(prop);
        prop = sco.createProperty("exception", ServicePropertyType.STRING, null);
        prop.setValue("exception.test1");
        exceptions.add(prop);
        sco.addActionableEvent(CORRELATOR_EVENT_ID);
        return sco;
    }

    private MatchingRule parseMatchingRule(String rule) {
        Matcher matcher = this.MATCH_ON_PATTHERN.matcher(rule);
        MatchingRule matchingRule = null;
        String expression = null;
        if (matcher.find()) {
            matchingRule = new MatchOnRule();
        } else {
            matcher = this.MATCH_ON_PROPERTY_PATTERN.matcher(rule);
            if (matcher.find()) {
                matchingRule = new MatchOnPropertyRule();
            } else {
                matcher = this.MATCH_ON_IDENTITY_PATTERN.matcher(rule);
                if (matcher.find()) {
                    matchingRule = new MatchOnIdentityRule();
                }
            }
        }
        if (matchingRule == null) {
            throw new IllegalArgumentException("Invalid matching rule '" + rule + "' specified.");
        }
        expression = matcher.group(1);
        if (matcher.group(2) != null) {
            matchingRule.notNull = true;
        }
        if ((matcher = this.STRING_VALUE_EXPRESSION.matcher(expression)).find()) {
            String eventIdValue = matcher.group(1);
            int index = eventIdValue.lastIndexOf(46);
            if (index != -1) {
                matchingRule.firstEventId = eventIdValue.substring(0, index);
                matchingRule.firstProperty = eventIdValue.substring(index + 1);
            } else {
                matchingRule.firstProperty = eventIdValue;
            }
            ExpressionOperator op = ExpressionOperator.getOperator(matcher.group(2).trim());
            if (op == null) {
                throw new IllegalArgumentException("Invalid expression operation '" + matcher.group(2) + "' specified for rule '" + rule + "'.");
            }
            matchingRule.op = op;
            matchingRule.value = matcher.group(3);
        } else {
            matcher = this.NON_STRING_VALUE_EXPRESSION.matcher(expression);
            if (matcher.find()) {
                String eventIdValue = matcher.group(1);
                int index = eventIdValue.lastIndexOf(46);
                if (index != -1) {
                    matchingRule.firstEventId = eventIdValue.substring(0, index);
                    matchingRule.firstProperty = eventIdValue.substring(index + 1);
                } else {
                    matchingRule.firstProperty = eventIdValue;
                }
                ExpressionOperator op = ExpressionOperator.getOperator(matcher.group(2).trim());
                if (op == null) {
                    throw new IllegalArgumentException("Invalid expression operation '" + matcher.group(2) + "' specified for rule '" + rule + "'.");
                }
                matchingRule.op = op;
                matchingRule.value = matcher.group(3);
            } else {
                matcher = this.EVENT_PROPERTY_EXPRESSION.matcher(expression);
                if (matcher.find()) {
                    String eventIdValue = matcher.group(1);
                    int index = eventIdValue.lastIndexOf(46);
                    if (index != -1) {
                        matchingRule.firstEventId = eventIdValue.substring(0, index);
                        matchingRule.firstProperty = eventIdValue.substring(index + 1);
                    } else {
                        matchingRule.firstProperty = eventIdValue;
                    }
                    ExpressionOperator op = ExpressionOperator.getOperator(matcher.group(2).trim());
                    if (op == null) {
                        throw new IllegalArgumentException("Invalid expression operation '" + matcher.group(2) + "' specified for rule '" + rule + "'.");
                    }
                    matchingRule.op = op;
                    eventIdValue = matcher.group(3);
                    index = eventIdValue.lastIndexOf(46);
                    if (index != -1) {
                        matchingRule.secondEventId = eventIdValue.substring(0, index);
                        matchingRule.secondProperty = eventIdValue.substring(index + 1);
                    } else {
                        matchingRule.firstProperty = eventIdValue;
                    }
                } else {
                    matcher = this.SIMPLE_EXPRESSION.matcher(expression);
                    if (matcher.find()) {
                        matchingRule.firstProperty = matcher.group(1);
                    } else {
                        throw new IllegalArgumentException("Invalid matching rule '" + rule + "' specified.");
                    }
                }
            }
        }
        return matchingRule;
    }

    static {
        try {
            SDOUtils.addEventPrototype((String)"MapEvent", (String)CORRELATOR_EVENT_ID);
            ServiceManager serviceManager = RuntimeContext.getInstance().getServiceManager();
            DSLSyntaxFactoryManager syntaxFactorymanager = serviceManager.getDSLSyntaxFactoryManager();
            DSLSyntaxFactory factory = syntaxFactorymanager.lookupDSLSyntaxFactory("EventCorrelator");
            if (factory == null) {
                factory = syntaxFactorymanager.createDSLSyntaxFactory("EventCorrelator");
            }
            DSLStatementSyntax syntax = new DSLStatementSyntax(SHOW_EVENT_SET_OP);
            syntax.setAction("show event set");
            factory.addDSLSyntax(syntax);
            factory.save();
        }
        catch (Exception error) {
            Trace.logException(EventCorrelator.class, (Throwable)error, (boolean)false);
        }
    }

    class MatchingRule {
        String firstEventId;
        String firstProperty;
        String secondEventId;
        String secondProperty;
        String value;
        ExpressionOperator op;
        boolean notNull = false;

        MatchingRule() {
        }

        boolean match(ImmutableEventDatagram event) {
            return true;
        }

        boolean checkCondition(ExpressionOperator op, Object first, Object second) {
            if (first == null && second == null && op == null) {
                return false;
            }
            if (first instanceof String) {
                String value1 = (String)first;
                String value2 = null;
                value2 = second instanceof String ? (String)second : second.toString();
                switch (op.ordinal()) {
                    case 0: {
                        return value1.equals(value2);
                    }
                }
            } else if (first instanceof Boolean) {
                Boolean value1 = (Boolean)first;
                Boolean value2 = null;
                if (second instanceof Boolean) {
                    value2 = (Boolean)second;
                } else if (second instanceof String) {
                    value2 = Boolean.valueOf(((String)second).trim());
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1 == value2;
                    }
                }
            } else if (first instanceof Byte) {
                Byte value1 = (Byte)first;
                Byte value2 = null;
                if (second instanceof String) {
                    value2 = Byte.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = ((Number)second).byteValue();
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1 == value2;
                    }
                    case 2: {
                        return value1 > value2;
                    }
                    case 4: {
                        return value1 >= value2;
                    }
                    case 3: {
                        return value1 < value2;
                    }
                    case 5: {
                        return value1 <= value2;
                    }
                }
            } else if (first instanceof Short) {
                Short value1 = (Short)first;
                Short value2 = null;
                if (second instanceof String) {
                    value2 = Short.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = ((Number)second).shortValue();
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1 == value2;
                    }
                    case 2: {
                        return value1 > value2;
                    }
                    case 4: {
                        return value1 >= value2;
                    }
                    case 3: {
                        return value1 < value2;
                    }
                    case 5: {
                        return value1 <= value2;
                    }
                }
            } else if (first instanceof Integer) {
                Integer value1 = (Integer)first;
                Integer value2 = null;
                if (second instanceof String) {
                    value2 = Integer.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = ((Number)second).intValue();
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1 == value2;
                    }
                    case 2: {
                        return value1 > value2;
                    }
                    case 4: {
                        return value1 >= value2;
                    }
                    case 3: {
                        return value1 < value2;
                    }
                    case 5: {
                        return value1 <= value2;
                    }
                }
            } else if (first instanceof Long) {
                Long value1 = (Long)first;
                Long value2 = null;
                if (second instanceof String) {
                    value2 = Long.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = ((Number)second).longValue();
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1 == value2;
                    }
                    case 2: {
                        return value1 > value2;
                    }
                    case 4: {
                        return value1 >= value2;
                    }
                    case 3: {
                        return value1 < value2;
                    }
                    case 5: {
                        return value1 <= value2;
                    }
                }
            } else if (first instanceof Float) {
                Float value1 = (Float)first;
                Float value2 = null;
                if (second instanceof String) {
                    value2 = Float.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = Float.valueOf(((Number)second).floatValue());
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1.floatValue() == value2.floatValue();
                    }
                    case 2: {
                        return value1.floatValue() > value2.floatValue();
                    }
                    case 4: {
                        return value1.floatValue() >= value2.floatValue();
                    }
                    case 3: {
                        return value1.floatValue() < value2.floatValue();
                    }
                    case 5: {
                        return value1.floatValue() <= value2.floatValue();
                    }
                }
            } else if (first instanceof Double) {
                Double value1 = (Double)first;
                Double value2 = null;
                if (second instanceof String) {
                    value2 = Double.valueOf(second.toString());
                } else if (second instanceof Number) {
                    value2 = ((Number)second).doubleValue();
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1.doubleValue() == value2.doubleValue();
                    }
                    case 2: {
                        return value1 > value2;
                    }
                    case 4: {
                        return value1 >= value2;
                    }
                    case 3: {
                        return value1 < value2;
                    }
                    case 5: {
                        return value1 <= value2;
                    }
                }
            } else if (first instanceof BigDecimal) {
                BigDecimal value1 = (BigDecimal)first;
                BigDecimal value2 = null;
                if (second instanceof String) {
                    value2 = new BigDecimal(second.toString());
                } else if (second instanceof Number) {
                    value2 = new BigDecimal(((Number)second).longValue());
                } else {
                    return false;
                }
                switch (op.ordinal()) {
                    case 0: {
                        return value1.compareTo(value2) == 0;
                    }
                    case 2: {
                        return value1.compareTo(value2) > 0;
                    }
                    case 4: {
                        return value1.compareTo(value2) >= 0;
                    }
                    case 3: {
                        return value1.compareTo(value2) < 0;
                    }
                    case 5: {
                        return value1.compareTo(value2) <= 0;
                    }
                }
            }
            return false;
        }

        Object getProperty(String property, String eventId) {
            ImmutableEventDatagram event = EventCorrelator.this.eventSet.get(eventId);
            return this.getProperty(property, event);
        }

        Object getProperty(String property, ImmutableEventDatagram event) {
            if (event == null) {
                return null;
            }
            try {
                if (event instanceof IAbstractDataEvent && ((IAbstractDataEvent)event).existsEventProperty(property)) {
                    return ((IAbstractDataEvent)event).getEventObjectProperty(property);
                }
                if (this.notNull) {
                    EventCorrelator.this.raiseException((ExceptionEventDatagram)new ServiceFrameworkException(6000, "Event [" + event.getEventId() + "] does not have property '" + property + "'."));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }

    class MatchingEventListener
    implements FabricEventListener {
        String eventIdAndSelector;

        MatchingEventListener(String eventIdAndSelector) {
            this.eventIdAndSelector = eventIdAndSelector;
        }

        public synchronized void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            EventCorrelator.this.updateEventSet(this.eventIdAndSelector, event);
        }
    }

    class MatchingExceptionListener
    implements FabricEventListener {
        MatchingExceptionListener() {
        }

        public synchronized void onEvent(ImmutableEventDatagram event) throws FabricEventException {
            try {
                EventCorrelator.this.ctx.logInfo("Exception '" + event.getEventId() + "' received. Cancelling...");
                EventCorrelator.this.ctx.raiseEvent(event, 0L);
                EventCorrelator.this.cancel();
            }
            catch (Exception error) {
                Trace.logException((Object)this, (Throwable)error, (boolean)false);
            }
        }
    }

    class MatchTimerTask
    extends AbstractFabricTimerTask {
        MatchTimerTask() {
        }

        public void execute(FabricTimer timer) {
            EventCorrelator.this.resetEventSet();
        }
    }

    class MatchOnRule
    extends MatchingRule {
        MatchOnRule() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        boolean match(ImmutableEventDatagram event) {
            Object first = null;
            if (this.firstEventId == null) return false;
            if (this.firstProperty == null) return false;
            if (EventCorrelator.this.eventSet.get(this.firstEventId) == null) {
                if (!event.getEventId().equals(this.firstEventId)) return true;
                first = this.getProperty(this.firstProperty, event);
                if (first == null) {
                    return false;
                }
            } else {
                first = this.getProperty(this.firstProperty, this.firstEventId);
            }
            if (this.secondEventId != null && this.secondProperty != null) {
                if (EventCorrelator.this.eventSet.get(this.secondEventId) != null) {
                    Object second = this.getProperty(this.secondProperty, this.secondEventId);
                    return this.checkCondition(this.op, first, second);
                }
                if (!event.getEventId().equals(this.secondEventId)) return true;
                Object second = this.getProperty(this.secondProperty, event);
                return this.checkCondition(this.op, first, second);
            }
            if (this.value == null) return false;
            return this.checkCondition(this.op, first, this.value);
        }
    }

    class MatchOnPropertyRule
    extends MatchingRule {
        MatchOnPropertyRule() {
        }

        @Override
        boolean match(ImmutableEventDatagram event) {
            if (this.firstProperty != null) {
                if (this.value != null) {
                    return this.checkCondition(this.op, this.getProperty(this.firstProperty, event), this.value);
                }
                for (String eventId : EventCorrelator.this.eventSet.keySet()) {
                    if (this.checkCondition(ExpressionOperator.EQUALS, this.getProperty(this.firstProperty, eventId), this.getProperty(this.firstProperty, event))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class MatchOnIdentityRule
    extends MatchingRule {
        MatchOnIdentityRule() {
        }

        @Override
        boolean match(ImmutableEventDatagram event) {
            if (this.firstProperty != null) {
                if (EventCorrelator.this.eventSet.size() > 0 && event instanceof IAbstractDataEvent) {
                    for (ImmutableEventDatagram existing : EventCorrelator.this.eventSet.values()) {
                        if (!(existing instanceof IAbstractDataEvent)) continue;
                        if (this.firstProperty.equals("correlationId")) {
                            if (((IAbstractDataEvent)existing).getCorrelationId().equals(((IAbstractDataEvent)event).getCorrelationId())) continue;
                            return false;
                        }
                        if (this.firstProperty.equals("eventGroupId")) {
                            if (((IAbstractDataEvent)existing).getEventGroupId().equals(((IAbstractDataEvent)event).getEventGroupId())) continue;
                            return false;
                        }
                        if (this.firstProperty.equals("eventKey")) {
                            if (((IAbstractDataEvent)existing).getEventKey().equals(((IAbstractDataEvent)event).getEventKey())) continue;
                            return false;
                        }
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }
    }

    static enum ExpressionOperator {
        EQUALS,
        NOT_EQUALS,
        MORE,
        LESS,
        MORE_OR_EQUALS,
        LESS_OR_EQUALS;


        static ExpressionOperator getOperator(String op) {
            if ((op = op.trim()).equals("==")) {
                return EQUALS;
            }
            if (op.equals("!=") || op.equals("<>")) {
                return NOT_EQUALS;
            }
            if (op.equals(">")) {
                return MORE;
            }
            if (op.equals("<")) {
                return LESS;
            }
            if (op.equals(">=")) {
                return MORE_OR_EQUALS;
            }
            if (op.equals("<=")) {
                return LESS_OR_EQUALS;
            }
            return null;
        }
    }
}

