/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.Trace;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.XMLEvent;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.service.converter.ConverterPluginException;
import com.streamscape.service.converter.IAbstractConverterPlugin;
import com.streamscape.service.osf.config.EventHandlersConfiguration;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import com.streamscape.service.osf.evh.EventHandler;
import java.util.List;
import javax.swing.JDialog;

public class RowSetRecordToXml
extends IAbstractConverterPlugin<RowSet, XMLEvent> {
    private String eventId = null;
    public static final String ROW_INDEX = "row.index";
    public static final String COLUMN_INDEX = "column.index";
    private int rowIndex = 0;
    private int columnIndex = 0;

    @Override
    public XMLEvent invoke(RowSet rowSet) throws ConverterPluginException {
        try {
            EventDatagramFactory factory = EventDatagramFactory.getInstance();
            XMLEvent event = (XMLEvent)factory.createEvent(this.eventId);
            if (event == null) {
                throw new ConverterPluginException("Unable to create outgoing event [" + this.eventId + "]. Please check that corresponding prototype exists.");
            }
            if (rowSet == null) {
                throw new ConverterPluginException("Unable to handle request. Incoming RowSet is NULL.");
            }
            if (rowSet.absolute(this.rowIndex)) {
                Object record = rowSet.getObject(this.columnIndex);
                if (record != null && record instanceof String) {
                    event.setXML((String)record);
                    return event;
                }
                throw new ConverterPluginException("Can't extract value from column " + this.columnIndex + ".");
            }
            throw new ConverterPluginException("Incoming RowSet does not have row with '" + this.rowIndex + "' index.");
        }
        catch (Exception error) {
            Trace.logException((Object)this, (Throwable)error, (boolean)true);
            throw new ConverterPluginException(error);
        }
    }

    @Override
    public void init() throws ConverterPluginException {
        ServiceConfigurationObject sco = super.getService().getServiceConfiguration();
        ServiceConfigurationProperties props = sco.getServiceConfigurationProperties();
        try {
            if (!props.hasProperty(ROW_INDEX)) {
                throw new ConverterPluginException("Row number should be specified for the plugin.");
            }
            String temp = this.getService().lookupStringProperty(ROW_INDEX);
            this.rowIndex = Integer.parseInt(temp);
            if (!props.hasProperty(COLUMN_INDEX)) {
                throw new ConverterPluginException("Row number should be specified for the plugin.");
            }
            temp = this.getService().lookupStringProperty(COLUMN_INDEX);
            this.columnIndex = Integer.parseInt(temp);
            this.getService().logInfo("Record to be extracted from RowSet: rowIndex = " + this.rowIndex + "; columnIndex = " + this.columnIndex);
            EventHandlersConfiguration handlersRegistry = (EventHandlersConfiguration)sco;
            List handlers = handlersRegistry.getEventHandlers();
            if (handlers.size() == 0) {
                throw new ConverterPluginException("At least one event handler should be registred on the converter.");
            }
            EventHandler handler = (EventHandler)handlers.get(0);
            if (handler != null && handler.getMethodName().equals("convert")) {
                this.eventId = handler.getResponseEventId();
                if (this.eventId == null) {
                    throw new ConverterPluginException("Outgoing message EventId should be specified.");
                }
            } else {
                throw new ConverterPluginException("Can't get the eventId for outgoing XmlEvent.");
            }
            this.getService().logInfo("Outgoing message eventId = '" + this.eventId + "'.");
        }
        catch (ConverterPluginException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConverterPluginException(error);
        }
    }

    @Override
    public void launchWizard(JDialog parentDialog) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

