/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter.plugins;

import com.streamscape.Trace;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.file.FileMetaInfo;
import com.streamscape.sdo.sql.SQLQuery;
import com.streamscape.sdo.sql.SQLQueryParameter;
import com.streamscape.sef.FabricComponent;
import com.streamscape.service.converter.ConverterPluginException;
import com.streamscape.service.converter.IAbstractConverterPlugin;
import com.streamscape.service.osf.config.ObjectPropertyValue;
import com.streamscape.service.osf.config.ServiceConfigurationException;
import com.streamscape.service.osf.config.ServiceConfigurationProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JDialog;

public class FileObjectToSQLQuery
extends IAbstractConverterPlugin<FileMetaInfo, SQLQuery> {
    public static final String SQL_QUERY = "sql.query";
    public static final String FILE_NAME_PATTERN = "file.name.pattern";
    public static final String TOKEN_NAME_LIST = "token.name.list";
    public static final String TOKEN_NAME_DELIMITER = ",";
    List<String> tokenNames = new ArrayList<String>();
    SQLQuery query = null;
    Pattern pattern = null;

    @Override
    public SQLQuery invoke(FileMetaInfo file) throws ConverterPluginException {
        try {
            Trace.logDebug((Object)this, (String)"Invocation...");
            if (file == null || file.getName() == null) {
                throw new ConverterPluginException("Incoming FileState is NULL.");
            }
            Matcher matcher = this.pattern.matcher(file.getName());
            if (matcher.find()) {
                int i;
                int groupCount = matcher.groupCount();
                SQLQuery result = (SQLQuery)this.query.clone();
                ArrayList<String> values = new ArrayList<String>();
                for (i = 1; i <= groupCount; ++i) {
                    values.add(matcher.group(i));
                }
                for (i = 0; i < groupCount; ++i) {
                    SQLQueryParameter param;
                    if (i >= this.tokenNames.size() || (param = result.getParameters().get(this.tokenNames.get(i))) == null) continue;
                    result.getParameters().set(this.tokenNames.get(i), (String)values.get(i));
                }
                Trace.logDebug((Object)this, (String)"Invoked.");
                return result;
            }
            throw new ConverterPluginException("Incoming file name does not matches specified pattern. Ignored.");
        }
        catch (ConverterPluginException error) {
            throw error;
        }
        catch (Exception error) {
            throw new ConverterPluginException(error);
        }
    }

    @Override
    public void init() throws ConverterPluginException {
        ServiceConfigurationProperties props;
        block16: {
            RuntimeContext runtimeCtx = RuntimeContext.getInstance();
            ServiceConfigurationObject sco = super.getService().getServiceConfiguration();
            props = sco.getServiceConfigurationProperties();
            if (props.hasProperty(SQL_QUERY)) {
                try {
                    ObjectPropertyValue queryObject = (ObjectPropertyValue)props.getProperty(SQL_QUERY).getValue();
                    SemanticObjectReferenceStore.beginXact((FabricComponent)runtimeCtx);
                    this.query = (SQLQuery)SemanticObjectReferenceStore.loadObject((ObjectPropertyValue)queryObject);
                    SemanticObjectReferenceStore.commitXact();
                    if (this.query == null) {
                        throw new ConverterPluginException("Unable to load specified SQL query.");
                    }
                    break block16;
                }
                catch (ServiceConfigurationException error) {
                    throw new ConverterPluginException(error);
                }
                catch (ObjectConfigurationException error) {
                    throw new ConverterPluginException(error);
                }
            }
            throw new ConverterPluginException("SQL query parameter should be set for the converter plugin.");
        }
        if (props.hasProperty(FILE_NAME_PATTERN)) {
            try {
                this.pattern = Pattern.compile(props.getProperty(FILE_NAME_PATTERN).toString());
            }
            catch (PatternSyntaxException error) {
                throw new ConverterPluginException("Specified file name pattern is incorrect.");
            }
            catch (ServiceConfigurationException error) {
                throw new ConverterPluginException(error);
            }
        } else {
            throw new ConverterPluginException("File name pattern parameter should be set for the converter plugin.");
        }
        if (props.hasProperty(TOKEN_NAME_LIST)) {
            try {
                String temp = props.getProperty(TOKEN_NAME_LIST).toString();
                StringTokenizer tokenizer = new StringTokenizer(temp, TOKEN_NAME_DELIMITER);
                while (tokenizer.hasMoreTokens()) {
                    String tokenName = tokenizer.nextToken();
                    this.tokenNames.add(tokenName);
                }
            }
            catch (PatternSyntaxException error) {
                throw new ConverterPluginException("Specified file name pattern is incorrect.");
            }
            catch (ServiceConfigurationException error) {
                throw new ConverterPluginException(error);
            }
        } else {
            throw new ConverterPluginException("File name pattern parameter should be set for the converter plugin.");
        }
    }

    @Override
    public void launchWizard(JDialog parentDialog) {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

