/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.service.converter;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.SystemDataObject;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.service.converter.ConverterPluginException;
import com.streamscape.service.converter.IAbstractConverterPlugin;
import java.util.Date;

public class ConverterPlugin
extends CloneableDataObject
implements SystemDataObject {
    public static final String SEMANTIC_TYPE = "ConverterPlugin";
    private String pluginClass = "";
    private String inputObjectClass = "";
    private String outputObjectClass = "";
    private Date timestamp = null;
    IAbstractConverterPlugin plugin = null;

    public ConverterPlugin() {
    }

    public ConverterPlugin(String className) {
        this.pluginClass = className;
        this.touch();
    }

    public ConverterPlugin(String className, String inputObjectClass) {
        this(className);
        this.inputObjectClass = inputObjectClass;
    }

    public long getSerialVersionUID() {
        return 8436257379275944131L;
    }

    public void init(ServiceContext ctx) throws ConverterPluginException {
        try {
            this.plugin = (IAbstractConverterPlugin)ClassUtils.createFromClassName((Object)((Object)this), (String)this.pluginClass, (ClassLoader)ctx.getPackageManifestManager().getManifestClassLoader());
            this.plugin.setService(ctx);
            this.plugin.init();
        }
        catch (UtilitiesException error) {
            throw new ConverterPluginException(error);
        }
    }

    public void start() {
        this.plugin.start();
    }

    public void stop() {
        this.plugin.stop();
    }

    public Object invoke(Object source) throws ConverterPluginException {
        return this.plugin.invoke(source);
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void touch() {
        this.timestamp = new Date(System.currentTimeMillis());
    }
}

