/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.jms;

import com.streamscape.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;

public class StreamScapeOracleConnectionFactory
implements ConnectionFactory {
    private InetAddress addr = null;
    private int port = 0;
    private String tunnel = null;
    private String keystore = null;
    private String keystorePassword = null;
    private String truststore = null;
    private String truststorePassword = null;
    private String provider = null;
    private String user = null;
    private String pass = null;
    private String clientID = null;
    private boolean isXA = false;
    private Class factoryClass = null;

    public StreamScapeOracleConnectionFactory() {
        try {
            Trace.logDebug((Object)this, (String)"Loading of transport factory class...");
            this.factoryClass = Thread.currentThread().getContextClassLoader().loadClass("com.evermind.server.jms.EvermindConnectionFactory");
            Trace.logDebug((Object)this, (String)"Transport factory class has been successfully loaded.");
        }
        catch (ClassNotFoundException error) {
            Trace.logError((Object)this, (String)"Unable to load transport factory class 'com.evermind.server.jms.EvermindConnectionFactory'.");
        }
    }

    public void setHostname(String hostname) {
        this.setAddr(hostname);
    }

    public void setPort(Integer portnumber) {
        this.port = portnumber;
    }

    public void setTunnel(String tunnel) {
        this.tunnel = tunnel;
    }

    public void setKeystore(String keystore) {
        this.keystore = keystore;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setTruststore(String truststore) {
        this.truststore = truststore;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setUsername(String username) {
        this.user = username;
    }

    public void setPassword(String password) {
        this.pass = password;
    }

    public void setClientId(String clienId) {
        this.clientID = clienId;
    }

    public void setTransacted(Boolean transacted) {
        this.isXA = transacted;
    }

    private void setAddr(String hostname) {
        try {
            this.addr = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Connection createConnection() throws JMSException {
        ConnectionFactory factory = this.instantiateFactory();
        if (factory != null) {
            return factory.createConnection();
        }
        throw new JMSException("Some of ConnectionFactory parameters are invalid. Check the connection session properties.");
    }

    public Connection createConnection(String username, String passwd) throws JMSException {
        ConnectionFactory factory = this.instantiateFactory();
        if (factory != null) {
            return factory.createConnection(username, passwd);
        }
        throw new JMSException("Some of ConnectionFactory parameters are invalid. Check the connection session properties.");
    }

    private ConnectionFactory instantiateFactory() throws JMSException {
        ConnectionFactory factory = null;
        try {
            if (this.factoryClass == null) {
                throw new JMSException("Transport factory class is not loaded.");
            }
            Constructor constructor = this.factoryClass.getDeclaredConstructor(InetAddress.class, Integer.TYPE, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            factory = (ConnectionFactory)constructor.newInstance(this.addr, this.port, this.tunnel, this.keystore, this.keystorePassword, this.truststore, this.truststorePassword, this.provider, this.user, this.pass, this.clientID, this.isXA);
        }
        catch (NoSuchMethodException error) {
            throw new JMSException(error.getMessage());
        }
        catch (InstantiationException error) {
            throw new JMSException(error.getMessage());
        }
        catch (IllegalAccessException error) {
            throw new JMSException(error.getMessage());
        }
        catch (InvocationTargetException error) {
            throw new JMSException(error.getMessage());
        }
        return factory;
    }
}

