/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.ftp.client;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.streamscape.Trace;
import com.streamscape.lib.ftp.client.AbstractFTPConnection;
import com.streamscape.lib.ftp.client.FTPException;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.lib.ftp.client.IllegalStateException;
import com.streamscape.lib.utils.Base64;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.service.osf.clients.ClientFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

class SFTPConnectionImpl
extends AbstractFTPConnection {
    private JSch jsch;
    private Session session;
    private ChannelSftp channel;

    @Override
    public void init(ClientFactory factory) throws ClientException {
        super.init(factory);
        this.jsch = new JSch();
        String privateKeyFile = factory.getProperties().getProperty("private.key.file");
        String passphrase = factory.getProperties().getProperty("passphrase");
        String publicKeyFile = factory.getProperties().getProperty("public.key.file");
        Trace.logDebug((Object)this, (String)("private.key.file: " + privateKeyFile));
        Trace.logDebug((Object)this, (String)"passphrase: ****");
        Trace.logDebug((Object)this, (String)("public.key.file: " + publicKeyFile));
        try {
            if (privateKeyFile != null && privateKeyFile.length() > 0) {
                if (passphrase != null) {
                    passphrase = new String(Base64.decode((String)passphrase));
                    if (publicKeyFile != null && publicKeyFile.length() > 0) {
                        this.jsch.addIdentity(privateKeyFile, publicKeyFile, passphrase.getBytes());
                    } else {
                        this.jsch.addIdentity(privateKeyFile, passphrase);
                    }
                } else {
                    this.jsch.addIdentity(privateKeyFile);
                }
            }
        }
        catch (JSchException exception) {
            throw new ClientException(1022, "Failed to set SFTP identity. Cause: " + exception.getMessage());
        }
    }

    @Override
    public void openConnection(String host, int port) throws IOException, FTPException, IllegalStateException {
        if (this.channel != null) {
            throw new IllegalStateException("Illegal FTP Connection State: Opened");
        }
        this.closeConnection();
        try {
            this.session = this.jsch.getSession(this.factory.getDefaultUser(), host, port);
            this.session.setPassword(this.factory.getDefaultPassword());
            if (this.factory.getConnectionTimeout() > 0) {
                this.session.setTimeout(this.factory.getConnectionTimeout() * 1000);
            }
            Trace.logDebug((Object)this, (String)"Connection timeout: {} seconds.", (Object[])new Object[]{this.factory.getConnectionTimeout()});
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this.session.setConfig(config);
            String property = this.factory.getProperty("server.alive.interval.ms");
            if (property != null && property.trim().length() > 0) {
                this.session.setServerAliveInterval(Integer.valueOf(property.trim()));
            }
            Trace.logDebug((Object)this, (String)("server.alive.interval.ms: " + (String)(property != null && property.trim().length() > 0 ? property + "ms" : "none")));
            property = this.factory.getProperty("server.alive.count.max");
            if (property != null && property.trim().length() > 0) {
                this.session.setServerAliveCountMax(Integer.valueOf(property.trim()));
            }
            Trace.logDebug((Object)this, (String)("server.alive.count.max: " + (property != null && property.trim().length() > 0 ? property : "none")));
            this.session.connect();
            this.channel = (ChannelSftp)this.session.openChannel("sftp");
            this.channel.connect();
        }
        catch (JSchException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void closeConnection() {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (this.session != null) {
            this.session.disconnect();
            this.session = null;
        }
    }

    @Override
    public void ftpGetFileAsFile(String remoteFile, String localFile) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.get(remoteFile, localFile);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public byte[] ftpGetFileAsBytes(String remoteFile) throws IOException, FTPException, IllegalStateException {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.channel.get(remoteFile, outputStream);
            return outputStream.toByteArray();
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpPutFileAsFile(String localFile, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.put(localFile, remoteFile, append ? 2 : 0);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpPutFileAsBytes(byte[] data, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.put((InputStream)new ByteArrayInputStream(data), remoteFile, append ? 2 : 0);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpChangeDir(String dir) throws IllegalStateException, FTPException, IOException {
        try {
            this.channel.cd(dir);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public List<FileEntry> ftpList(String path, final boolean full) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        try {
            final ArrayList<FileEntry> result = new ArrayList<FileEntry>();
            this.channel.ls(path, new ChannelSftp.LsEntrySelector(){

                @Override
                public int select(ChannelSftp.LsEntry entry) {
                    if (entry.getFilename().equals(".") || entry.getFilename().equals("..")) {
                        return 0;
                    }
                    if (full || !entry.getAttrs().isDir()) {
                        result.add(new FileEntry(entry.getFilename(), new Date((long)entry.getAttrs().getMTime() * 1000L), entry.getAttrs().isDir(), entry.getAttrs().getPermissionsString(), "?", Integer.toString(entry.getAttrs().getUId()), Integer.toString(entry.getAttrs().getGId()), Long.toString(entry.getAttrs().getSize())));
                    }
                    return 0;
                }
            });
            return result;
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpDel(String fileName) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.rm(fileName);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpMkD(String dirName) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.mkdir(dirName);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpRen(String oldFileName, String newFileName) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.rename(oldFileName, newFileName);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void ftpRmD(String dirName) throws IOException, FTPException, IllegalStateException {
        try {
            this.channel.rmdir(dirName);
        }
        catch (SftpException exception) {
            throw new FTPException(exception);
        }
    }

    @Override
    public void cancelConnection() throws IOException, FTPException, IllegalStateException {
    }

    @Override
    public List<String> ftpQuote(String cmd, String[] validRCList, boolean socketData) throws IOException, FTPException, IllegalStateException {
        throw new FTPException("ftpQuote is not supported for SFTP");
    }

    @Override
    public boolean ftpSite(String cmd) throws IOException, FTPException, IllegalStateException {
        throw new FTPException("ftpSite is not supported for SFTP");
    }

    @Override
    public String ftpSyST() throws IOException, FTPException, IllegalStateException {
        throw new FTPException("ftpSyST is not supported for SFTP");
    }

    @Override
    public void pingConnection() throws IOException, FTPException, IllegalStateException {
    }

    protected void assertState() throws IllegalStateException {
        if (this.channel == null) {
            throw new IllegalStateException("Illegal FTP Connection State: Closed");
        }
    }

    static {
        JSch.setLogger(new Logger(){

            @Override
            public boolean isEnabled(int level) {
                return Trace.isEnabled(JSch.class, (Trace.Level)this.jhchLevelToStreamscape(level));
            }

            @Override
            public void log(int level, String message) {
                Trace.log(JSch.class, (Trace.Level)this.jhchLevelToStreamscape(level), (String)"{}: {}", (Object[])new Object[]{this.jhchLevelName(level), message});
            }

            private Trace.Level jhchLevelToStreamscape(int level) {
                switch (level) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return Trace.Level.DEBUG;
                    }
                    case 3: 
                    case 4: {
                        return Trace.Level.ERROR;
                    }
                }
                return Trace.Level.ERROR;
            }

            private String jhchLevelName(int level) {
                switch (level) {
                    case 0: {
                        return "DEBUG";
                    }
                    case 1: {
                        return "INFO";
                    }
                    case 2: {
                        return "WARN";
                    }
                    case 3: {
                        return "ERROR";
                    }
                    case 4: {
                        return "FATAL";
                    }
                }
                return "UNKNOWN";
            }
        });
    }
}

