/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.lib.ftp.client;

import com.streamscape.Trace;
import com.streamscape.lib.ftp.client.AbstractFTPConnection;
import com.streamscape.lib.ftp.client.FTPConnectionImpl;
import com.streamscape.lib.ftp.client.FTPConnectionInterface;
import com.streamscape.lib.ftp.client.FTPException;
import com.streamscape.lib.ftp.client.FileEntry;
import com.streamscape.lib.ftp.client.IllegalStateException;
import com.streamscape.lib.ftp.client.SFTPConnectionImpl;
import com.streamscape.sdo.enums.ConnectionState;
import com.streamscape.sdo.excp.ClientException;
import com.streamscape.service.osf.clients.AbstractClientConnection;
import com.streamscape.service.osf.clients.ClientFactory;
import java.io.IOException;
import java.util.List;

public class FTPConnection
extends AbstractClientConnection
implements FTPConnectionInterface {
    protected String host;
    protected int port = 21;
    protected FTPProtocol protocol = FTPProtocol.FTP;
    protected boolean useMdtm = false;
    protected AbstractFTPConnection connection;

    public String getHost() {
        return this.host;
    }

    public void setHost(String hostName) {
        this.host = hostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public FTPProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(FTPProtocol protocol) {
        this.protocol = protocol;
    }

    @Override
    public void useMdtm(boolean value) {
        this.useMdtm = value;
    }

    public void connect() throws ClientException {
        try {
            this.openConnection();
        }
        catch (Exception error) {
            throw new ClientException(1022, (Throwable)error);
        }
    }

    public void disconnect() throws ClientException {
        try {
            this.closeConnection();
        }
        catch (Exception error) {
            throw new ClientException(1022, (Throwable)error);
        }
    }

    public void setUrl(String url) throws ClientException {
        String proto = this.getUrlProtocol(url);
        if (proto.equalsIgnoreCase("ftp")) {
            this.protocol = FTPProtocol.FTP;
        } else if (proto.equalsIgnoreCase("sftp")) {
            this.protocol = FTPProtocol.SFTP;
        } else {
            throw new ClientException(1006, "Invalid FTP proto '" + proto + "' in url '" + url + "'.");
        }
        this.host = this.getUrlHost(url);
        this.port = this.getUrlPort(url);
    }

    public String getUrl() {
        return this.protocol.toString().toLowerCase() + "://" + this.host + ":" + this.port;
    }

    public String toString() {
        return "url: " + this.getUrl();
    }

    public void raiseException(Exception exception) {
        if (this.getExceptionEventListener() != null) {
            this.getExceptionEventListener().onEvent(new ClientException(1022, (Throwable)exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public int ping() throws ClientException {
        AbstractFTPConnection c = null;
        try {
            c = this.createFTPConnectionAndConnect();
            c.pingConnection();
        }
        catch (FTPException exception) {
            int n = -1;
            return n;
        }
        catch (IOException exception) {
            int n = -2;
            return n;
        }
        catch (IllegalStateException exception2) {
            int n = -2;
            return n;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (c != null) {
                try {
                    c.closeConnection();
                }
                catch (Exception exception) {}
            }
        }
        return 0;
    }

    public void init(ClientFactory factory) throws ClientException {
        this.factory = factory;
        if (factory.getProperty("Name") == null) {
            this.setName(factory.getFactoryType() + "." + factory.getFactoryName());
        } else {
            this.setName(factory.getProperty("Name"));
        }
        this.setUrl(factory.getUrl());
        this.connection = this.createFTPConnection();
        Trace.logInfo((Object)this, (String)("Initialized FTP connection to '" + this.getUrl() + "'."));
    }

    protected void openConnection() throws IOException, FTPException, IllegalStateException {
        if (this.getState() == ConnectionState.OPEN) {
            return;
        }
        this.setState(ConnectionState.OPENING);
        Trace.logDebug((Object)this, (String)("Opening FTP connection to " + this.getUrl()));
        try {
            this.connection.openConnection(this.host, this.port);
            this.setState(ConnectionState.OPEN);
            this.connection.useMdtm(this.useMdtm);
        }
        catch (FTPException | IllegalStateException | IOException exception) {
            this.setState(ConnectionState.CLOSED);
            this.connection.closeConnection();
            throw exception;
        }
    }

    protected void closeConnection() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.setState(ConnectionState.CLOSING);
        Trace.logDebug((Object)this, (String)("Closing FTP connection to " + this.getUrl()));
        try {
            this.connection.closeConnection();
        }
        finally {
            this.setState(ConnectionState.CLOSED);
        }
    }

    private AbstractFTPConnection createFTPConnection() throws ClientException {
        AbstractFTPConnection result = null;
        result = this.protocol == FTPProtocol.FTP ? new FTPConnectionImpl() : new SFTPConnectionImpl();
        result.init(this.factory);
        return result;
    }

    private AbstractFTPConnection createFTPConnectionAndConnect() throws IOException, FTPException, IllegalStateException, ClientException {
        AbstractFTPConnection result = this.createFTPConnection();
        result.openConnection(this.host, this.port);
        return result;
    }

    protected void assertState() throws IllegalStateException {
        if (this.connection == null) {
            throw new IllegalStateException("Illegal FTP Connection State: Disconnected");
        }
    }

    @Override
    public void ftpGetFileAsFile(String remoteFile, String localFile) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpGetFileAsFile(remoteFile, localFile);
    }

    @Override
    public byte[] ftpGetFileAsBytes(String remoteFile) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        return this.connection.ftpGetFileAsBytes(remoteFile);
    }

    @Override
    public void ftpPutFileAsFile(String localFile, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpPutFileAsFile(localFile, remoteFile, append);
    }

    @Override
    public void ftpPutFileAsBytes(byte[] data, String remoteFile, boolean append) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpPutFileAsBytes(data, remoteFile, append);
    }

    @Override
    public void cancelConnection() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.cancelConnection();
    }

    @Override
    public void ftpChangeDir(String dir) throws IllegalStateException, FTPException, IOException {
        this.assertState();
        this.connection.ftpChangeDir(dir);
    }

    @Override
    public List<FileEntry> ftpList(String path, boolean full) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        return this.connection.ftpList(path, full);
    }

    @Override
    public void ftpDel(String fileName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpDel(fileName);
    }

    @Override
    public void ftpMkD(String dirName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpMkD(dirName);
    }

    @Override
    public void ftpRen(String oldFileName, String newFileName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpRen(oldFileName, newFileName);
    }

    @Override
    public void ftpRmD(String dirName) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        this.connection.ftpRmD(dirName);
    }

    @Override
    public List<String> ftpQuote(String cmd, String[] validRCList, boolean socketData) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        return this.connection.ftpQuote(cmd, validRCList, socketData);
    }

    @Override
    public boolean ftpSite(String cmd) throws IOException, FTPException, IllegalStateException {
        this.assertState();
        return this.connection.ftpSite(cmd);
    }

    @Override
    public String ftpSyST() throws IOException, FTPException, IllegalStateException {
        this.assertState();
        return this.connection.ftpSyST();
    }

    static enum FTPProtocol {
        FTP,
        SFTP;

    }
}

