
# Overview

This sample demonstrates how to use the STText REST API to capture audio from a microphone and transcript it to text.
There are 3 samples
 - `index_wait_for_buffer.html` - waits for buffer to be filled for specified amount of time, and then sends it to backend in async mode
   START -> WAIT FOR BUFFER FULL -> SEND -> WAIT FOR BUFFER FULL -> SEND -> WAIT FOR BUFFER FULL -> SEND -> STOP -> RETURN STOP RESULT
 - `index_flush_button.html` - flushes buffer when user presses FLUSH button and returns transcription for last buffer flushed.
 - `index_real_time_transcription.html` - real time transcription

# Installation

 - Create node with installed and configured STText service
 - Disable CORS in HTTP Acceptor
   + `alter acceptor HTTP.Default add cross origin(enabled = true)`
 - Create web application and API Key token
   + `create web application name 'sttext service' resources(method 'post' url '/service/invoke')`
   + `create web token name 'sttext token' application ... expires in -1`
 - link or copy stjsapi: 
   + `ln -s path/to/stjsapi/src/main/webapp/js js`
   + or
   + `cp -rf path/to/stjsapi/src/main/webapp/js js`
 - Update `acceptorURL`, `apikeyToken` and `sttextServiceName` in index file to corresponding values
 - start web server in the directory where index files are located and then open index file in browser
   + `python3 -m http.server 8000`
   + open `http://localhost:8000/index_flush_button.html` in browser

# Usage

When open the page set Node URL, API Key Token and Service Name and press Start Transcription button.

## index_wait_for_buffer.html
### Page elements and controls

- Conversation ID – id of current transcription
- Submission Count - number of executed submissions
- Punctuated Text – here punctuated text will be appended
- Audio Buffer Size - how often submission is executed
- Start Transcription – starts transcription
- End Transcription - ends transcription

## index_flush_button.html
### Page elements and controls

- Conversation ID – id of current transcription
- Submission Count - number of executed submissions
- Punctuated Text – here punctuated text will be appended
- Audio Buffer Size - how often submission is executed
- Flush - flush bytes to backend in synchronous mode and get transcription
- Start Transcription – starts transcription
- End Transcription - ends transcription

## index_real_time_transcription.html
### Page elements and controls

- Conversation ID – id of current transcription
- Punctuated Text – here punctuated text will be appended
- Last Response – response of last submitWavBytes call
- Submit Interval – interval to invoke submitWavBytes ( with sync = false),
  + if sync = false, then backend will return transcription when it is ready (can be once in 10 or 20 seconds, we cannot control it)
  + if sync = true, then backend forces Vosk library to finish transcription, and returns transcription in submitWavBytes response.
- Sync Interval – how often to set sync = true in submitWavBytes,
- Sync On Next Submit – set sync = true in next submitWavBytes invocation
- Start Transcription – starts transcription
- End Transcription - ends transcription

# API Calls

## startTranscription

### request : StartTranscriptionRequest
```json
{
    "conversationId" : "",
    "type" : "",
    "transcriptFilePath" : "",
    "appendTranscriptFile" : false,
    "wavFilePath" : "",
    "explain" : false,
    "notifyInterval" : 0,
    "notifyWordCount" : 0,
    "punctuationParams" : {
      "punctuationAlgorithm" : "BERT",
      "commaDelayMs" : 0,
      "eosDelayMs" : 0,
      "newLineDelayMs" : 0,
      "collectionTimeMs" : 0
      "syncPunctuation" : false
    }
}
```

- type - type of conversation, will be auto attached to Audio Dispatch with the same type
- transcriptFilePath – where to save transcription file on Node side (can be dropbox path)
- appendTranscriptFile - append to existing transcript file or not
- wavFilePath - where to save wav file on Node side (can be dropbox path)
- explain - return transcript as json without punctuation 
- notifyInterval - interval in seconds between Raise Event [event.audio.Transcript] actions of an active Transcript. Events contain some or all of the Transcript content. Default 0 - disabled.
- notifyWordCount - specifies how many words to include in the Transcripts notification events. -1 should send the entire Transcript. Default 0 - disabled.
- punctuationParams  - punctuation params, you can set them to null now, default alg and params will be used
- punctuationAlgorithm – BERT | TIME | NONE
  + eosDelayMs          - delay for dots, default 500ms
  + commaDelayMs        - delay for commas, default 300ms
  + newLineDelayMs      - delay for new lines, default 1500ms
  + collectionTimeMs    - how long to collect words, default 5000ms
  + syncPunctuation     - punctuate all collected words on each invocation regardless collectionTimeMs, default false

### response: StartTranscriptionResponse
```json
{
    "conversationId" : "",
    "audioFormatSuggested" : {
      "encoding" : "",
      "sampleRate" : 0.0,
      "sampleSizeInBits" : 0,
      "channels" : 0,
      "frameSize" : 0,
      "frameRate" : 0.0,
      "bigEndian" : false
    },
    "punctuationParams" : {
      "punctuationAlgorithm" : "NONE",
      "commaDelayMs" : 0,
      "eosDelayMs" : 0,
      "newLineDelayMs" : 0,
      "collectionTimeMs" : 0
    }
}
```
- conversationId – unique transcription ID
- audioFormatSuggested – suggested audio format, see in sample how to use
- punctuationParams – punctuation params which are used for punctuation

## submitWavBytes

### request : SubmitWavBytesRequest
```json
{
    "conversationId" : "",
    "audioFormat" : {
      "encoding" : "",
      "sampleRate" : 0.0,
      "sampleSizeInBits" : 0,
      "channels" : 0,
      "frameSize" : 0,
      "frameRate" : 0.0,
      "bigEndian" : false
    },
    "bytes" : "AA==",
    "sync" : false,
    "noTextReply": false,
    "userSubmit": false
}
```

- conversationId
- audioFormat – audio format of your stream, see sample how to use it
- bytes – wav bytes
- sync – true | false
- noTextReply - don't return available punctuated text in response for async request, for sync request always returned
- userSubmit - true | false, if true, then this submitWavBytes was invoked by user(not by times) and dot will be appended to punctuated text 

### response: SubmitWavBytesResponse
```json
{
    "conversationId" : "",
    "punctuatedText" : {
      "text" : "",
      "startMs" : 0,
      "endMs" : 0,
      "wordsCount" : 0
    },
    "audioInfo" : {
      "endPhrase" : "",
      "endPhraseWords" : [ "" ],
      "maxDurationSeconds" : 0,
      "startedAt" : 0,
      "stoppedAt" : 0,
      "wordsCount" : 0,
      "wordsLength" : 0,
      "totalBytesRead" : 0,
      "totalBytesSentToTranscript" : 0,
      "audioFormat" : {
        "encoding" : "",
        "sampleRate" : 0.0,
        "sampleSizeInBits" : 0,
        "channels" : 0,
        "frameSize" : 0,
        "frameRate" : 0.0,
        "bigEndian" : false,
      },
      "outputWavFile" : "",
      "transcriptFile" : "",
      "notifyIntervalSeconds" : 0,
      "notifyWordCount" : 0
    },
    "isConversationComplete" : false
}
```

- conversationId
- punctuatedText – punctuated transcription of last chunk
  + text
  + startMs
  + endMs
  + wordsCount
- isConversationComplete – will be set to true if transcription was ended on node size(can be done in slang, or after node restart), in this case need to close audio stream in browser

## endTranscription

### request: EndTranscriptionRequest
```json
{
    "conversationId" : "",
    "textFullReply": false
}
```
- conversationId
- textFullReply - return or not full punctuated text in response

### response: EndTranscriptionResponse
```json
{
    "conversationId" : "",
    "punctuatedText" : {
      "text" : "",
      "startMs" : 0,
      "endMs" : 0,
      "wordsCount" : 0
    },
    "punctuatedTextFull" : {
      "text" : "",
      "startMs" : 0,
      "endMs" : 0,
      "wordsCount" : 0
    },
    "audioInfo" : {
      "endPhrase" : "",
      "endPhraseWords" : [ "" ],
      "maxDurationSeconds" : 0,
      "startedAt" : 0,
      "stoppedAt" : 0,
      "wordsCount" : 0,
      "wordsLength" : 0,
      "totalBytesRead" : 0,
      "totalBytesSentToTranscript" : 0,
      "audioFormat" : {
        "encoding" : "",
        "sampleRate" : 0.0,
        "sampleSizeInBits" : 0,
        "channels" : 0,
        "frameSize" : 0,
        "frameRate" : 0.0,
        "bigEndian" : false,
        "properties" : {
          "key" : null
        }
      },
      "outputWavFile" : "",
      "transcriptFile" : "",
      "notifyIntervalSeconds" : 0,
      "notifyWordCount" : 0
    }
}
```

- conversationId
- punctuatedText – punctuated transcription of last chunk
- punctuatedTextFull - punctuated transcription of full conversation
 