function HttpRequest(url, timeout)
{
    this.url = url;
    this.timeout = timeout;
    this.timeoutId = null;
    
    this.headers  = [];
    
    this.xmlhttp = getXmlHttp();

    if (HttpRequest.id == null)
        HttpRequest.id = 0;

    function getXmlHttp() 
    {
        if (window.XMLHttpRequest) 
        {
            return new XMLHttpRequest();
        } 
        else if (window.ActiveXObject) 
        {
            var XMLHTTP = ["Msxml2.XMLHTTP.6.0", "Msxml2.XMLHTTP.5.0", "Msxml2.XMLHTTP.4.0", "MSXML2.XMLHTTP.3.0", "MSXML2.XMLHTTP", "Microsoft.XMLHTTP"];
            for (var i = 0; i < XMLHTTP.length; i++) 
            {
                try 
                {
                    var obj = new ActiveXObject(XMLHTTP[i]);
                    return obj;
                }
                catch (ex) {}
            }
        }
        alert("This browser does not support XMLHttpRequest.");
    }
}

HttpRequest.prototype = 
{
    get : function(callback, uri)
    {
        return this.send(callback, uri, null, false);
    },

    post : function(callback, uri, request)
    {
        return this.send(callback, uri, request, true);
    },

    send : function(callback, uri, request, post)
    {
        var fullUrl = this.url + uri;
        if (request != null || post == true)
            this.xmlhttp.open('POST', fullUrl, true);
        else
            this.xmlhttp.open('GET', fullUrl, true);

        for (var i = 0; i < this.headers.length; ++i)
            this.xmlhttp.setRequestHeader(this.headers[i].name, this.headers[i].value);

        var id = ++HttpRequest.id;
        var handler = this;
        var processTimeout = function()
        {
            handler.abort();
            callback(null, id, 408);
        }

        this.timeoutId = setTimeout(processTimeout, this.timeout);

        this.xmlhttp.onreadystatechange = function() 
        { 
            var response = handler.getAjaxResponse();
            if (response != null)
            {
                clearTimeout(handler.timeoutId);
                callback(response.responseText, id, response.statusCode);
            }
        };

        this.xmlhttp.send(request);
    },

    setHeader : function(name, value)
    {
        var header = 
        {
          name  : name,
          value : value
        };
        
        var found = false;
        for (var i = 0; i < this.headers.length; ++i)
            if (this.headers[i].name == name)
            {
                found = true;
                this.headers[i] = header;
            }
        if (!found)
          this.headers.push(header);
    },
    
    abort : function()
    {
        clearTimeout(this.timeoutId);
        this.xmlhttp.abort();
    },

    getAjaxResponse : function()
    {
        if (this.xmlhttp.readyState == 4)
        {
            var responseText = this.xmlhttp.responseText;
            if (responseText != null)
            {
                //var regexp = /^(\s*)(\S+[\s\S]*\S+)(\s*)$/;
                //var matches = regexp.exec(responseText);
                //if (matches != null)
                //    responseText = matches[2];
                //if (responseText.match(/[\[{][\s\S]*[\]}]/))
                //    responseText = Utilities.decode(responseText);
            }
            
            var response = 
            {
                responseText : responseText,
                statusCode   :  this.xmlhttp.status
            }
            
            return response;
        }
        return null;
    }
}

