function CrossDomainHttpRequest(url, timeout)
{
    this.url = url;
    this.timeout = timeout;
    this.head = document.getElementsByTagName("head")[0];
    this.scriptInfo = null;

    this.headers  = [];
    
    if (CrossDomainHttpRequest.id == null)
    {
        CrossDomainHttpRequest.id = 0;
    }
}

CrossDomainHttpRequest.prototype = 
{
    get : function(callback, uri)
    {
        return this.send(callback, uri, null, false);
    },

    post : function(callback, uri, request)
    {
        return this.send(callback, uri, request, true);
    },

    send : function(callback, uri, request, post) 
    {
        var id = ++CrossDomainHttpRequest.id;
        var callbackName = '_script_' + id;
        var scriptName = 'script' + id;
        
        var fullUrl = this.url + uri;
        if (fullUrl.indexOf('?') == -1)
            fullUrl = fullUrl + '?';
        else
            fullUrl = fullUrl + '&';
        fullUrl = fullUrl + 'callback=' + callbackName;

        var scriptInfo = 
        {
            scriptName   : scriptName,
            callbackName : callbackName,
            callback     : callback,
            sequenceId   : id
        };

        var handler = this;
        window[callbackName] = function(response)
        {
            handler.removeScript(scriptInfo, true);
            scriptInfo.callback(response, scriptInfo.sequenceId, 200);
        };
        window[callbackName + '_timeout'] = function()
        {
            handler.removeScript(scriptInfo, false);
            scriptInfo.callback(null, scriptInfo.sequenceId, 408);
        };
        scriptInfo.timeoutId = setTimeout(window[callbackName + '_timeout'], 
            this.timeout);

        // Remove a script tag from the head for a previous request if necessary
        if (this.scriptInfo != null)
            this.removeScript(this.scriptInfo, false);

        var script = document.createElement("script");
        script.setAttribute("src", fullUrl);
        script.setAttribute("type", "text/javascript");
        script.setAttribute("id", scriptName);
        this.head.appendChild(script);

        this.scriptInfo = scriptInfo;
    },

    removeScript : function(scriptInfo, isFinished)
    {
        this.scriptInfo = null;
        this.head.removeChild(document.getElementById(scriptInfo.scriptName));
        clearTimeout(scriptInfo.timeoutId);

        var name = scriptInfo.callbackName;
        window[name] = function()
        {
            window[name] = null;
            window[name + '_timeout'] = null;
            try
            {
                delete window[name];
                delete window[name + '_timeout'];
            }
            catch (exception) {}
        };

        if (isFinished)
            window[name].call();
    },

    addHeader : function(name, value)
    {
        var header = 
        {
          name  : name,
          value : value
        };
        
        this.headers.push(header);
    },

    abort : function()
    {
        if (this.scriptInfo != null)
            this.removeScript(this.scriptInfo, false);
    }
}

