function AuthenticationHelper(userName, password)
{
    this.userName = userName;
    this.password = password;
    
    this.wwwAuthenticationType  = null;
    this.wwwAuthenticationNonce = null;
    this.wwwAuthenticationRealm = null;
    this.sessionValue = null;
}

AuthenticationHelper.isWwwAuthenticationAnswer = function(answer)
{
    return ((typeof answer == 'string') && answer.match(/WWW-Authenticate:/));
}

AuthenticationHelper.prototype =
{
    addAuthInfo : function(url)
    {
        url += "?" + "Authorization=";
        
        if (this.wwwAuthenticationType == "basic")
        {
            var auth = Base64.encode(this.userName + ':' + this.password);
            url = url + "basic:" + auth;
        }
        else if (this.wwwAuthenticationType == "digest")
        {
            var uri = url.substring(0, url.indexOf('?'));
            var HA1 = MD5(this.userName + ':' + this.wwwAuthenticationRealm + ':' + this.password);
            var HA2 = MD5("POST" + ':' + uri);
            var response = MD5(HA1 + ":" + this.wwwAuthenticationNonce + ":" + HA2);
            
            url += "digest:";
            url += "realm=" + this.wwwAuthenticationRealm;
            url += ",username=" + this.userName;
            url += ",nonce=" + this.wwwAuthenticationNonce;
            url += ",response=" + response;
            url += ",uri=" + uri;
        }
        
        return url;
    },

    setWwwAuthentication : function(wwwAuthentication)
    {
      var res = null;
        
      if ((res = wwwAuthentication.match(/basic:realm=\".*\"/)) != null)
      {
        this.wwwAuthenticationType = "basic";
        this.wwwAuthenticationRealm = res[1];
      }
      else if ((res = wwwAuthentication.match(/digest:realm=\"(.*)\",nonce=\"(.*)\",sessionValue=\"(.*)\"/i)) != null)
      {
        this.wwwAuthenticationType = "digest";
        this.wwwAuthenticationRealm = res[1];
        this.wwwAuthenticationNonce = res[2];
        this.sessionValue = res[3];
      }
      else
        return false;
      
      return true;
    },
    
    reset : function()
    {
        this.wwwAuthenticationType  = null;
        this.wwwAuthenticationNonce = null;
        this.wwwAuthenticationRealm = null;
        this.sessionValue = null;
    }
}

var newHttpRequest = function(url, timeout)
{
    return new HttpRequest(url, timeout);
}

