<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceName>Prototype</serviceName>
  <serviceType>HTTPEventSource</serviceType>
  <serviceDisplayName>HTTP Event Source</serviceDisplayName>
  <serviceDesc>A service that performs HTTP requests to specific URL and raises events with HTTP response.</serviceDesc>
  <serviceClass>com.streamscape.service.http.evSource.HTTPEventSource</serviceClass>
  <eimPlugin>EventIdentityIntegerKeyStart</eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>DIRECT</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      
      <entry>
        <string>connection.http</string>
        <Property>
          <propertyName>connection.http</propertyName>
          <labelName>HTTP Connection</labelName>
          <propertyDescription>The HTTP connection configuration.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>CLIENT_FACTORY</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="Value.CLIENT_FACTORY">
            <factoryName>.</factoryName>
            <factoryType>.</factoryType>
          </defaultValue>
          <propertyValue SemanticType="Value.CLIENT_FACTORY">
            <factoryName>httpClient</factoryName>
            <factoryType>HTTPClient</factoryType>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>      
      </entry>

      <entry>
        <string>event.id</string>
        <Property>
          <propertyName>event.id</propertyName>
          <labelName>Event Id</labelName>
          <propertyDescription>Defines actionable event id.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="string"></defaultValue>
          <propertyValue SemanticType="string">event.http.response</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      
      <entry>
        <string>polling.interval</string>
        <Property>
          <propertyName>polling.interval</propertyName>
          <labelName>Polling Interval</labelName>
          <propertyDescription>Defines service polling interval in milliseconds.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="long">0</defaultValue>
          <propertyValue SemanticType="long">3000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>

      <entry>
        <string>request.uri</string>
        <Property>
          <propertyName>request.uri</propertyName>
          <labelName>HTTP request URI</labelName>
          <propertyDescription>Defines HTTP request URI.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="string"></defaultValue>
          <propertyValue SemanticType="string"><![CDATA[/service/getsource?a=1&b=2&c='sad!s"]]></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>

      <entry>
        <string>http.method</string>
        <Property>
          <propertyName>http.method</propertyName>
          <labelName>HTTP Request method.</labelName>
          <propertyDescription>Defines HTTP request method.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="string"></defaultValue>
          <propertyValue SemanticType="string">GET</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>

      <entry>
        <string>enable.buffering</string>
        <Property>
          <propertyName>enable.buffering</propertyName>
          <labelName>Enable Buffering</labelName>
          <propertyDescription>If enabled service stores previous polled response.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="boolean"></defaultValue>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>

      <entry>
        <string>include.http.headers</string>
        <Property>
          <propertyName>include.http.headers</propertyName>
          <labelName>Include HTTP headers</labelName>
          <propertyDescription>If enabled response HTTP headers are included to event properties.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="boolean"></defaultValue>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>

      <entry>
        <string>response.format</string>
        <Property>
          <propertyName>response.format</propertyName>
          <labelName>HTTP response format.</labelName>
          <propertyDescription>Defines HTTP response format and actionable event type. Valid values: text,xml,json,binary. </propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="string"></defaultValue>
          <propertyValue SemanticType="string">xml</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>service.group</string>
        <Property.ADVANCED>
          <name>service.group</name>
          <value SemanticType="string">HTTPTestNode</value>
          <label>Service Group Name</label>
          <description>Specifies a service group.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>event.group.identity</string>
        <Property.ADVANCED>
          <name>event.group.identity</name>
          <value SemanticType="string">TestProcess</value>
          <label>Event Group Idenity</label>
          <description>Defines EventGroupId for all outgoing events.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>deliveryThreadPoolSize</string>
        <Property.ADVANCED>
          <name>deliveryThreadPoolSize</name>
          <value SemanticType="long">0</value>
          <label>Delivery Thread Pool Size</label>
          <description>Specifies a number of threads in pool of dispatcher.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">GLOBAL</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
        <string>advisory.connection.StateChange</string>
  </advisoriesTable>
  </advisoriesRegistry>
  <eventTriggersRegistry/>
  <actionableEventsRegistry>
    <actionableEventsTable>
        <string>event.http.response</string>
    </actionableEventsTable>
    <groupList/>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable/>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
        <string>exception.cli.Interface</string>
  </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1279839412625</configTimeStamp>
</ServiceConfiguration>