<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceName>Prototype</serviceName>
  <serviceType>HTTPEventSink</serviceType>
  <serviceDisplayName>HTTP Event Sink</serviceDisplayName>
  <serviceClass>com.streamscape.service.http.evSink.HTTPEventSink</serviceClass>
  <eimPlugin>EventIdentityProcessTracker</eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>

      <entry>
        <string>connection.http</string>
        <Property>
          <propertyName>connection.http</propertyName>
          <labelName>HTTP Connection</labelName>
          <propertyDescription>The HTTP connection configuration.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>CLIENT_FACTORY</dataType>
          <isRequired>true</isRequired>
          <rangeList></rangeList>
          <defaultValue SemanticType="Value.CLIENT_FACTORY">
            <factoryName>.</factoryName>
            <factoryType>.</factoryType>
          </defaultValue>
          <propertyValue SemanticType="Value.CLIENT_FACTORY">
            <factoryName>httpClient</factoryName>
            <factoryType>HTTPClient</factoryType>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>      
      </entry>

    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>service.group</string>
        <Property.ADVANCED>
          <name>service.group</name>
          <value SemanticType="string">HTTPTestNode</value>
          <label>Service Group Name</label>
          <description>Specifies a service group.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>use.native.messaging</string>
        <Property.ADVANCED>
          <name>use.native.messaging</name>
          <value SemanticType="string">true</value>
          <label>Use native messaging</label>
          <description>Specifies whether to use Sonic or native messaging</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">OBSERVABLE</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>deliveryThreadPoolSize</string>
        <Property.ADVANCED>
          <name>deliveryThreadPoolSize</name>
          <value SemanticType="long">0</value>
          <label>Delivery Thread Pool Size</label>
          <description>Specifies a number of threads in pool of dispatcher.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
        <string>advisory.connection.StateChange</string>
  </advisoriesTable>
  </advisoriesRegistry>
  <eventTriggersRegistry/>
  <actionableEventsRegistry>
    <actionableEventsTable>
        <string>event.http.sink.response</string>
  </actionableEventsTable>
    <groupList/>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable>
      <entry>
        <string>newRequestProccessing</string>
        <Handler.EVENT>
          <methodName>processHttpRequest</methodName>
          <handlerName>newRequestProccessing</handlerName>
          <requestEventId>event.http.tosink.request</requestEventId>
          <requestSemanticType>event</requestSemanticType>
          <responseEventId>event.http.sink.response</responseEventId>
          <responseSemanticType>event</responseSemanticType>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
  </handlersTable>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
        <string>exception.cli.Interface</string>
  </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1270765797816</configTimeStamp>
</ServiceConfiguration>
