#####################################################################
#
# This sample shows operations with complex objects and semantic types.
#
# Before sample execution make sure that SDOs Employee and
# EmployeeAddress already created.
#
# They can be created with the following slang commands:
#
#   create sdo EmployeeAddress as {string city; string zipcode;}
#       namespace stpy.sample
#       replace archive stpysample
#       replace package stpysample
#
#  create sdo Employee as {string name; EmployeeAddress address;}
#       namespace stpy.sample
#       replace archive stpysample
#       replace package stpysample
#
#####################################################################

# import ds module
from stpy import ds

# connect to the dataspace
# NOTE: update url to the your node dataspace and created corresponding dataspace name
# you can create dataspace with the following dataspace command:
#   create dataspace pythonds type tspace
db=ds.connect(url="http://localhost:8888", dataspace="tspace.pythonds",
              username="Admin", password="Admin", timeout=30, autocommit=True)

# create a cursor
c=db.cursor()

# create table
c.execute("create persistent table employees(id int, employee Employee, primary key(id))")

# complex object can be inserted into collection by the following ways

# 1. create and fill object in accessor session and then insert into table in the same session

c.execute("Employee employee = new Employee()")
c.execute("employee.name = 'Steve'")
c.execute("employee.address = new EmployeeAddress()")
c.execute("employee.address.city = 'NY'")
c.execute("employee.address.zipcode = '10001'")

c.execute("insert into employees values (1, employee)")

# 2. create and fill object in dictionary and then insert into table

employeeMap = {
    '@type' : 'Employee',
    'name' : 'Mike',
    'address' : {
        '@type' : 'EmployeeAddress',
        'city' : 'NY',
        'zipcode' : '10005'
        }
    }
c.execute("insert into employees values (2, ?)", [employeeMap])

# 3. import semantic type, create and fill object on the client and then insert into table

db.import_semantic_type('Employee')
employee = db.get_type_factory().instantiateType('Employee');
employee.name = 'Bill'
employee.address = db.get_type_factory().instantiateType('EmployeeAddress');
employee.address.city = 'LA'
employee.address.state = '90001'

c.execute("insert into employees values (3, ?)", (employee,))

# select query returns complex object as
#  - dictionary - if corresponding semantic type not imported
#  - deserialized object - if corresponding semantic type is imported

# we have already imported Employee semantic type on previous step, so it will be returned as deserialized object
c.execute("select * from employees")

# fetch rows
row = c.fetchone()
row
row[0]
row[1].name
row[1].address.city

row = c.fetchone()
row
row[0]
row[1].name
row[1].address.city


# close cursor and connection
c.close()
db.close()