function alertExceptionHandler(exception)
{
    if ((exception != null) && (exception.detailMessage != null))
        alert(exception.detailMessage);
    else
        alert("Exception: " + exception);
}

fabricConnection = null;

function login()
{
    var user = document.getElementById('user').value;
    var password = document.getElementById('password').value;
    fabricConnection = new HTTPFabricConnection(user, password, alertExceptionHandler);
    fabricConnection.open();
}

function subscribe()
{
    var eventId = document.getElementById('eventId').value;
    var name = 'ChatConsumer_' + eventId;
    if (fabricConnection.getEventAsyncConsumer(name) == null)
    {
        var listener = new EventListener(onEvent);
        var consumer = fabricConnection.createEventAsyncConsumer(
            name, listener, eventId, null, 'INHERITED', false);
        consumer.start();
    }
    else
    {
        alert('Already subscribed to ' + eventId);
    }
}

eventObject = 
{
    '@type' : 'DataEvent',
    eventId : 'event.test',
    durable : false,
    timeStamp : 0,
    eventExpiration : 0,
    dataProtected : 'Rw==',
    acl : {ACL : 'GyUs'},
    coalesced : false,
    data : 'test'
};

function raise() 
{
    var user = document.getElementById('login').value;
    var data = document.getElementById('raiseText').value;
    var id   = document.getElementById('eventId').value;
    eventObject.data = user + ": " + data;
    eventObject.eventId = id;
    fabricConnection.bindProducerFor(id);
    fabricConnection.raiseEvent(eventObject, 'INHERITED', 0);
}

function onEvent(event)
{
    var message = "";
    if ((event['@type'] == 'DataEvent') && (event.data != null))
    {
        message = event.data;
        if (typeof message != "string")
            message = Utilities.encode(message);
    }
    else
    {
        message = Utilities.encode(event);
    }

    var chat = document.getElementById('chatWindow');
    chat.value = chat.value + message + '\n';
}

