package simple;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.event.DataEvent;
import com.streamscape.sef.enums.EventScope;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: This <i>ClientProducer</i> sample connects to the node and raises the event.
 * Another <i>ClientConsumer</i> sample receives raised event.  
 * See READ.ME to know how run and use this sample. 
 *  
 * <p>Copyright: Copyright (c) 2015</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.4
 */
 public class ClientProducer
 {
    static ClientContext    context;
    static FabricConnection connection;
    
    static final String     dataEventId       = "event.data.employee.sample";

    static String nodeAddress = "tlp://localhost:5000";
    static String username    = "user1";
    static String password    = "123";
    
    public static void main(String[] args)
    {
       try
       {
          parseArguments(args);

          // Enables some traces.
          Trace.enable("com.streamscape.cli.*", Trace.Level.INFO);
          Trace.enable("events.*",              Trace.Level.ERROR);
          
          // Initializes the Client Context.
          context = ClientContext.getInstance();
          
          // connecting to the node
          System.out.print("Connecting to the node at " + nodeAddress + " using credentials " + username + "/" + password + "...");
          connection = new FabricConnectionFactory(nodeAddress).createConnection(username, password);
          connection.setName("ClientConnectionForProduce");
          connection.open();
          System.out.println(" Connected.");

          // import event prototype, semantic type will be imported as well
          connection.importEventPrototype(dataEventId);
          
          // bind producer for event
          connection.bindProducerFor(dataEventId);
          
          // create and initialize data from SDO
          SemanticType semanticType = context.getSemanticTypeCache().lookupSemanticType("EmployeeSampleData");
          if (semanticType == null)
             throw new Exception("Semantic type EmployeeSampleData doesn't exist.");
          Class<?> sampleDataClass = context.getSystemClassLoaderChain().loadClass(semanticType.getClassName());
          // set SDO object values
          Object sampleData = sampleDataClass.newInstance();
          sampleDataClass.getMethod("setId", Integer.class).invoke(sampleData, 1);
          sampleDataClass.getMethod("setName", String.class).invoke(sampleData, "Steve");
          
          // create event
          DataEvent dataEvent = (DataEvent)context.getEventDatagramFactory().createEvent(dataEventId);
          dataEvent.setData(sampleData);
          
          // raise event
          connection.raiseEvent(dataEvent, EventScope.GLOBAL, 0);
          System.out.println(" data event [" + dataEventId + "] raised");

          // exit
          System.out.println("exiting...");
          context.shutdown();
          System.exit(0);
       }
       catch (Exception exception)
       {
          exception.printStackTrace();
          System.exit(1);
       }
    }
    
    private static void parseArguments(String []args) throws Exception
    {
       for (int i = 0; i < args.length; i++)
       {
          String name = args[i++];
          if (i >= args.length)
             throw new Exception("Missing value for argument " + name + ".");
          String value = args[i];
          if (name.equals("-a"))
             nodeAddress = value;
          else if (name.equals("-u"))
             username = value;
          else if (name.equals("-p"))
             password = value;
          else
             throw new Exception("Unknown argument " + name + " specified.");
       }
    }

 }
