package service.triggers;

import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.StateAdvisory;
import com.streamscape.sdo.event.TextEvent;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sef.service.AbstractService;


/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Simple service for samples.
 * 
 * <p>Copyright: Copyright (c) 2012</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.3
 */
 public class SampleServiceObject extends AbstractService 
 {
    protected void doInit() throws ServiceFrameworkException
    {
    }

    public ImmutableEventDatagram handleEventMethod(ImmutableEventDatagram event) throws Exception
    {
       TextEvent textEvent = (TextEvent)event;
       if (event == null)
          System.out.println("SampleServiceObject.handleEventMethod: Unexpected event type received: " + event);
       
       System.out.println("SampleServiceObject.handleEventMethod: Event received: " + textEvent.getEventId() + ", text: " + textEvent.getText());
       
       if (textEvent.getText().equals("metric"))
       {
          ctx.getMetricsFactory().nextMetricValue(ServiceSample.SAMPLE_SERVICE_METRIC_NAME);
          System.out.println("Current metric value: " + ctx.getMetricsFactory().getMetricValue(ServiceSample.SAMPLE_SERVICE_METRIC_NAME));
       }
       else if (textEvent.getText().equals("notification"))
       {
          StateAdvisory notif = ctx.getAdvisoriesFactory().createAdvisory(ServiceSample.SAMPLE_SERVICE_NOTIFICATION_NAME);
          notif.setMessage("State advisory notification message");
          ctx.raiseAdvisory(notif);
       }
       
       return event;
    }

    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws Exception
    {
       throw new Exception("sample exception");
    }
    
    public int getMajorVersion()
    {
       return 3;
    }

    public int getMinorVersion()
    {
       return 2;
    }

    public int getMinorBuild()
    {
       return 1;
    }

    public String getVersion()
    {
       return "3.2";
    }
 }
