package service.dsl;

import com.streamscape.lib.utils.SQLType;
import com.streamscape.sdo.excp.ServiceFrameworkException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.service.AbstractService;
import com.streamscape.sef.service.dsl.DSLProcessor;
import com.streamscape.slex.lang.DSLStatement;

import java.util.Date;

/**
 * <p>Title: Java Samples</p>
 *
 * <p>Description: Sample service that implements DSLProcessor interface.
 * 
 * <p>Copyright: Copyright (c) 2013</p>
 *
 * <p>Company: StreamScape Technologies</p>
 *
 * @author Nikita Kutuzov
 * @version 3.3
 */
 public class DSLProcessorSampleService extends AbstractService implements DSLProcessor  
 {
    protected void doInit() throws ServiceFrameworkException
    {
    }

    public SLResponse onStatement(DSLStatement statement) throws Exception
    {
       if(statement.getName().equals("helloworld"))
       {
          return new SLResponse("Hello world!");
       }
       else if (statement.getName().equals("getcurrenttime"))
       {
          return new SLResponse(new Date(System.currentTimeMillis()).toString());
       }
       else if (statement.getName().equals("print"))
       {
          return new SLResponse(statement.getParameter("text").getValue());
       }
       else if (statement.getName().equals("getauthors"))
       {
          RowMetaData meta = new RowMetaData(10);
          meta.addColumn("Author", SQLType.STRING);
          meta.addColumn("Book", SQLType.STRING);

          RowSet rowSet = new RowSet(meta);
          rowSet.addToRowSet(new Object[] {"Mark Twain", "Tom Sawyer"});
          
          return new SLResponse(rowSet);
       }
       else
          throw new Exception("Operation '" + statement.getName() + "' with definition '" + statement.getDefinition() + "' not implemented.");
    }

    public int getMajorVersion()
    {
       return 1;
    }

    public int getMinorVersion()
    {
       return 0;
    }

    public int getMajorBuild()
    {
       return 1;
    }

    public int getMinorBuild()
    {
       return 1;
    }

    public String getVersion()
    {
       return "1.0";
    }
 }
