<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>XMLEventSource</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>XML Event Source</serviceDisplayName>
  <serviceDesc>Parses XML file and creates event stream out of it.</serviceDesc>
  <serviceClass>com.streamscape.service.xml.evSource.XMLEventSource</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>raise.abort.stream.event</string>
        <Property>
          <propertyName>raise.abort.stream.event</propertyName>
          <labelName>Raise Abort Stream Event</labelName>
          <propertyDescription>Specifies whether XMLStreamState should be sent in case of stream abort.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>xml.escaping</string>
        <Property>
          <propertyName>xml.escaping</propertyName>
          <labelName>XML Escaping</labelName>
          <propertyDescription>Specifies XML fragments escaping strategy.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList>ESCAPE_SYSTEM,ESCAPE_SPECIAL,ESCAPE_ALL,ESCAPE_NONE</rangeList>
          <propertyValue SemanticType="string">ESCAPE_NONE</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>polling.file.name</string>
        <Property>
          <propertyName>polling.file.name</propertyName>
          <labelName>Polling File Name</labelName>
          <propertyDescription>Specifies name (mask) of the XML file for polling.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>stream.state.eventid</string>
        <Property>
          <propertyName>stream.state.eventid</propertyName>
          <labelName>Stream State Event Id</labelName>
          <propertyDescription>Specifies EventId of the DataEvent with XMLStreamState which is sent on stream state change.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">event.xml.stream.state.changed</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>xml.encoding</string>
        <Property>
          <propertyName>xml.encoding</propertyName>
          <labelName>XML Encoding</labelName>
          <propertyDescription>Specifies encoding of XML file to be parsed.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">ISO-8859-1</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>raise.close.stream.event</string>
        <Property>
          <propertyName>raise.close.stream.event</propertyName>
          <labelName>Raise Close Stream Event</labelName>
          <propertyDescription>Specifies whether XMLStreamState should be sent in case of stream closed.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>file.action.eventid</string>
        <Property>
          <propertyName>file.action.eventid</propertyName>
          <labelName>File Action Event Id</labelName>
          <propertyDescription>Specifies Event Id of FileEvent which will be emited once XML file is parsed.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">event.xml.parsed</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>polling.interval</string>
        <Property>
          <propertyName>polling.interval</propertyName>
          <labelName>Polling Interval</labelName>
          <propertyDescription>Specifies polling interval.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="long">1000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>xpath.eventid.map</string>
        <Property>
          <propertyName>xpath.eventid.map</propertyName>
          <labelName>XPATH to EventId Map</labelName>
          <propertyDescription>Specifies mapping from XPATH (XML fragment) to EventId which should be used to emit this fragment.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>TABLE</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="hashtable">
            <entry>
              <string>//ROOT_ELEMENT</string>
              <Property>
                <propertyName>event.xml.fragment</propertyName>
                <labelName></labelName>
                <propertyDescription></propertyDescription>
                <propertyGroup>main.group</propertyGroup>
                <dataType>STRING</dataType>
                <isRequired>false</isRequired>
                <rangeList></rangeList>
                <propertyValue SemanticType="string"></propertyValue>
                <isExportable>true</isExportable>
              </Property>
            </entry>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>source.dispatch.model</string>
        <Property>
          <propertyName>source.dispatch.model</propertyName>
          <labelName>Source Dispatch Model</labelName>
          <propertyDescription>Specifies source dispatch model, whether poll specified folder for XML file or wait an event request.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList>FILE_POLL,RAISED_EVENT</rangeList>
          <propertyValue SemanticType="string">RAISED_EVENT</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>raise.open.stream.event</string>
        <Property>
          <propertyName>raise.open.stream.event</propertyName>
          <labelName>Raise Open Stream Event</labelName>
          <propertyDescription>Specifies whether XMLStreamState should be sent in case of stream opened.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.xml.file.parsed</string>
      <string>event.xml.parsed</string>
      <string>event.xml.fragment</string>
      <string>event.xml.stream.state.changed</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable>
      <entry>
        <string>XMLParseRequestHandler</string>
        <Handler.EVENT>
          <methodName>processFile</methodName>
          <handlerName>XMLParseRequestHandler</handlerName>
          <requestEventId>event.xml.file</requestEventId>
          <requestSemanticType>FileEvent</requestSemanticType>
          <responseEventId>event.xml.file.parsed</responseEventId>
          <responseSemanticType>Void</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
    </handlersTable>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.xml.Parsing</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533331</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>