<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>SemanticMapper</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>Semantic Mapper</serviceDisplayName>
  <serviceDesc>Performs mapping from one object format to another.</serviceDesc>
  <serviceClass>com.streamscape.service.mapper.evSink.SemanticMapperService</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>target.object</string>
        <Property>
          <propertyName>target.object</propertyName>
          <labelName>Target Object</labelName>
          <propertyDescription>Desribes target object configuration.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>TABLE</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="hashtable">
            <entry>
              <string>date.pattern</string>
              <Property>
                <propertyName>date.pattern</propertyName>
                <labelName>Date Pattern</labelName>
                <propertyDescription>Specifies pattern which should be used for date decoding from the source document.</propertyDescription>
                <propertyGroup>main.group</propertyGroup>
                <dataType>STRING</dataType>
                <isRequired>false</isRequired>
                <rangeList></rangeList>
                <propertyValue SemanticType="string">yyyy/MM/dd hh:mm:ss aaa</propertyValue>
                <isExportable>true</isExportable>
              </Property>
            </entry>
            <entry>
              <string>data.format</string>
              <Property>
                <propertyName>data.format</propertyName>
                <labelName>Data Format</labelName>
                <propertyDescription>Specifies object format.</propertyDescription>
                <propertyGroup>main.group</propertyGroup>
                <dataType>ENUMERATION</dataType>
                <isRequired>false</isRequired>
                <rangeList>DATA_OBJECT,XML_DOCUMENT,JSON_DOCUMENT,XML_ARRAY,JSON_ARRAY</rangeList>
                <propertyValue SemanticType="string">DATA_OBJECT</propertyValue>
                <isExportable>true</isExportable>
              </Property>
            </entry>
            <entry>
              <string>alias</string>
              <Property>
                <propertyName>alias</propertyName>
                <labelName>Object Alias</labelName>
                <propertyDescription>Specifies alias for this object which is used for mapping.</propertyDescription>
                <propertyGroup>main.group</propertyGroup>
                <dataType>STRING</dataType>
                <isRequired>false</isRequired>
                <rangeList></rangeList>
                <propertyValue SemanticType="string">TargetObject</propertyValue>
                <isExportable>true</isExportable>
              </Property>
            </entry>
            <entry>
              <string>encoding</string>
              <Property>
                <propertyName>encoding</propertyName>
                <labelName>Encoding</labelName>
                <propertyDescription>Specifies encoding for XML or JSON array data format.</propertyDescription>
                <propertyGroup>main.group</propertyGroup>
                <dataType>STRING</dataType>
                <isRequired>false</isRequired>
                <rangeList></rangeList>
                <propertyValue SemanticType="string">utf-8</propertyValue>
                <isExportable>true</isExportable>
              </Property>
            </entry>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>source.objects</string>
        <Property>
          <propertyName>source.objects</propertyName>
          <labelName>Source Object</labelName>
          <propertyDescription>Desribes source object configuration.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>LIST</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="list">
            <Property>
              <propertyName>source.object</propertyName>
              <labelName></labelName>
              <propertyDescription></propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>TABLE</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="hashtable">
                <entry>
                  <string>date.pattern</string>
                  <Property>
                    <propertyName>date.pattern</propertyName>
                    <labelName>Date Pattern</labelName>
                    <propertyDescription>Specifies pattern which should be used for date decoding from the source document.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">yyyy/MM/dd hh:mm:ss aaa</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>data.format</string>
                  <Property>
                    <propertyName>data.format</propertyName>
                    <labelName>Data Format</labelName>
                    <propertyDescription>Specifies object format.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>ENUMERATION</dataType>
                    <isRequired>false</isRequired>
                    <rangeList>DATA_OBJECT,XML_DOCUMENT,JSON_DOCUMENT,XML_ARRAY,JSON_ARRAY</rangeList>
                    <propertyValue SemanticType="string">DATA_OBJECT</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>alias</string>
                  <Property>
                    <propertyName>alias</propertyName>
                    <labelName>Object Alias</labelName>
                    <propertyDescription>Specifies alias for this object which is used for mapping.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">SourceObject</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>encoding</string>
                  <Property>
                    <propertyName>encoding</propertyName>
                    <labelName>Encoding</labelName>
                    <propertyDescription>Specifies encoding for XML or JSON array data format.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">utf-8</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>expression</string>
                  <Property>
                    <propertyName>expression</propertyName>
                    <labelName>Object Evaluation Expression</labelName>
                    <propertyDescription>Specifies expression for object evaluation.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">%SourceObject = %CurrentObject</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
              </propertyValue>
              <isExportable>true</isExportable>
            </Property>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>target.validation</string>
        <Property>
          <propertyName>target.validation</propertyName>
          <labelName>Target Validation</labelName>
          <propertyDescription>Specifies whether target object should be validated.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>source.validation</string>
        <Property>
          <propertyName>source.validation</propertyName>
          <labelName>Source Validation</labelName>
          <propertyDescription>Specifies whether source object should be validated.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>semantic.map</string>
        <Property>
          <propertyName>semantic.map</propertyName>
          <labelName>Semantic Table</labelName>
          <propertyDescription>Specifies semantic table object which contains mapping rules.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>OBJECT</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.OBJECT">
            <objectName>mappingTable</objectName>
            <objectType>SemanticMap</objectType>
            <ctxNamespace>/mapper</ctxNamespace>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>default.dataspace</string>
        <Property>
          <propertyName>default.dataspace</propertyName>
          <labelName>Default Dataspace</labelName>
          <propertyDescription>Specifies default dataspace.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">TSPACE.SDS</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>enable.customization</string>
        <Property>
          <propertyName>enable.customization</propertyName>
          <labelName>Enable Customization</labelName>
          <propertyDescription>Specifies whether some semantic map fields should be overwritten (e.g. validation or default dataspace).</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.target</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable>
      <entry>
        <string>MappingHandler</string>
        <Handler.EVENT>
          <methodName>map</methodName>
          <handlerName>MappingHandler</handlerName>
          <requestEventId>event.source</requestEventId>
          <requestSemanticType>object</requestSemanticType>
          <responseEventId>event.target</responseEventId>
          <responseSemanticType>object</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
    </handlersTable>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.omf.SemanticMapper</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533315</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>