<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>EVFTPDaemon</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>Event FTP System Daemon</serviceDisplayName>
  <serviceDesc>Polls the specified FTP folder and checks for new files.</serviceDesc>
  <serviceClass>com.streamscape.service.ftp.daemon.EVFTPDaemon</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>ftp.connection</string>
        <Property>
          <propertyName>ftp.connection</propertyName>
          <labelName>FTP Connection</labelName>
          <propertyDescription>Specifies FTP connection configuration.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>CLIENT_FACTORY</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.CLIENT_FACTORY">
            <factoryType>FTPConnection</factoryType>
            <factoryName>TestConnection</factoryName>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>monitors</string>
        <Property>
          <propertyName>monitors</propertyName>
          <labelName>Monitors</labelName>
          <propertyDescription>Contains list of all monitors.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>LIST</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="list">
            <Property>
              <propertyName>monitor</propertyName>
              <labelName>Monitor</labelName>
              <propertyDescription>Contains configuration of a monitor.</propertyDescription>
              <propertyGroup>main.group</propertyGroup>
              <dataType>TABLE</dataType>
              <isRequired>false</isRequired>
              <rangeList></rangeList>
              <propertyValue SemanticType="hashtable">
                <entry>
                  <string>monitor.action.parameter</string>
                  <Property>
                    <propertyName>monitor.action.parameter</propertyName>
                    <labelName>Monitor Action Parameter</labelName>
                    <propertyDescription>Specifies additional parameter for file action (if necessary).</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">InboundFolder</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>monitor.action</string>
                  <Property>
                    <propertyName>monitor.action</propertyName>
                    <labelName>Monitor Action</labelName>
                    <propertyDescription>Specifies action which should be applied on matched file.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>ENUMERATION</dataType>
                    <isRequired>false</isRequired>
                    <rangeList>COPY,MOVE,DELETE,RENAME,</rangeList>
                    <propertyValue SemanticType="string">COPY</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>monitor.pattern</string>
                  <Property>
                    <propertyName>monitor.pattern</propertyName>
                    <labelName>Monitor Pattern</labelName>
                    <propertyDescription>Specifies pattern for the files which this monitor is supposed to process.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">.*.zip</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
                <entry>
                  <string>monitor.name</string>
                  <Property>
                    <propertyName>monitor.name</propertyName>
                    <labelName>Monitor Name</labelName>
                    <propertyDescription>Specifies name of the monitor.</propertyDescription>
                    <propertyGroup>main.group</propertyGroup>
                    <dataType>STRING</dataType>
                    <isRequired>false</isRequired>
                    <rangeList></rangeList>
                    <propertyValue SemanticType="string">TestMonitor</propertyValue>
                    <isExportable>true</isExportable>
                  </Property>
                </entry>
              </propertyValue>
              <isExportable>true</isExportable>
            </Property>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>collection.name</string>
        <Property>
          <propertyName>collection.name</propertyName>
          <labelName>Collection Name</labelName>
          <propertyDescription>Specifies name of the collection to store snapshot.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>sort.strategy</string>
        <Property>
          <propertyName>sort.strategy</propertyName>
          <labelName>File Sort Strategy</labelName>
          <propertyDescription>Specifies sort strategy for the files to be processed by monitors.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>ENUMERATION</dataType>
          <isRequired>false</isRequired>
          <rangeList>MODIFICATION_TIME,SERVER_DEFAULT</rangeList>
          <propertyValue SemanticType="string">MODIFICATION_TIME</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>use.mdtm</string>
        <Property>
          <propertyName>use.mdtm</propertyName>
          <labelName>Use MDTM Window</labelName>
          <propertyDescription>Specifies whether MDTM ftp command should be used for file modification time retrieval.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>dataspace.name</string>
        <Property>
          <propertyName>dataspace.name</propertyName>
          <labelName>Dataspace Name</labelName>
          <propertyDescription>Specifies name of the dataspace to store snapshot.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>recovery.window</string>
        <Property>
          <propertyName>recovery.window</propertyName>
          <labelName>Recovery Window</labelName>
          <propertyDescription>Specifies which existing files should be processed during the service start.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="long">60000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>polling.interval</string>
        <Property>
          <propertyName>polling.interval</propertyName>
          <labelName>Polling Interval</labelName>
          <propertyDescription>Specifies FTP site polling interval.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>NUMERIC</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="long">60000</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>persistent.snapshot</string>
        <Property>
          <propertyName>persistent.snapshot</propertyName>
          <labelName>Persistent Snapshot</labelName>
          <propertyDescription>Specifies whether snapshot should be persistent.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>root.folder</string>
        <Property>
          <propertyName>root.folder</propertyName>
          <labelName>Root Folder</labelName>
          <propertyDescription>Specifies root FTP folder.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string"></propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
      <string>advisory.connection.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.ftpFile.StateChange</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable/>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.cli.Interface</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533423</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>