<?xml version="1.0"?>
<ServiceConfiguration>
  <serviceType>DBEventSink</serviceType>
  <serviceName>prototype</serviceName>
  <serviceDisplayName>Database Event Sink</serviceDisplayName>
  <serviceDesc>Executes dynamic and/or static SQL against the configured DBMS server.</serviceDesc>
  <serviceClass>com.streamscape.service.dbms.evSink.DatabaseEventSink</serviceClass>
  <eimPlugin></eimPlugin>
  <validatorClass>com.streamscape.service.ui.validators.DefaultValidator</validatorClass>
  <invokeMode>ASYNC</invokeMode>
  <daemonService>false</daemonService>
  <interruptable>false</interruptable>
  <propertiesRegistry>
    <propertiesTable>
      <entry>
        <string>shutdown.sql</string>
        <Property>
          <propertyName>shutdown.sql</propertyName>
          <labelName>Shutdown SQL</labelName>
          <propertyDescription>Specifies SQL query batch which should be executed before DB connection close.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>OBJECT</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.OBJECT">
            <objectName>shutdownSql</objectName>
            <objectType>SQLQueryBatch</objectType>
            <ctxNamespace>/sql</ctxNamespace>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>sql.info.event.id</string>
        <Property>
          <propertyName>sql.info.event.id</propertyName>
          <labelName>SQL Info EventId</labelName>
          <propertyDescription>Specifies event id for publishing SQL info information (SQL executed by service).</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>STRING</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="string">event.sql.info</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>static.sql.query</string>
        <Property>
          <propertyName>static.sql.query</propertyName>
          <labelName>Static SQL Query</labelName>
          <propertyDescription>Specifies SQL query object for static mode.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>OBJECT</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.OBJECT">
            <objectName>staticSql</objectName>
            <objectType>SQLQuery</objectType>
            <ctxNamespace>/sql</ctxNamespace>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>init.session.sql</string>
        <Property>
          <propertyName>init.session.sql</propertyName>
          <labelName>Init Session SQL</labelName>
          <propertyDescription>Specifies SQL query batch which should be executed upon DB connection establishment to set up session.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>OBJECT</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.OBJECT">
            <objectName>initSql</objectName>
            <objectType>SQLQueryBatch</objectType>
            <ctxNamespace>/sql</ctxNamespace>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>dynamic.sql.mode</string>
        <Property>
          <propertyName>dynamic.sql.mode</propertyName>
          <labelName>Dynamic SQL Mode</labelName>
          <propertyDescription>Specifies whether service is in dynamic mode or uses static query.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>transacted.mode</string>
        <Property>
          <propertyName>transacted.mode</propertyName>
          <labelName>Transacted SQL Mode</labelName>
          <propertyDescription>Specifies whether service handles transactions or it is JDBC connection responsibility.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">true</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>multi.row.set.strategy</string>
        <Property>
          <propertyName>multi.row.set.strategy</propertyName>
          <labelName>Multi RowSet Result Strategy</labelName>
          <propertyDescription>Specifies strategy for multi rowset result.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>ENUMERATION</dataType>
          <isRequired>false</isRequired>
          <rangeList>USE_FIRST,USE_LAST,USE_ALL</rangeList>
          <propertyValue SemanticType="string">USE_FIRST</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>blocking.mode</string>
        <Property>
          <propertyName>blocking.mode</propertyName>
          <labelName>Blocking Mode</labelName>
          <propertyDescription>Specifies whether incoming query should be enqueued till connection to DB server is established or immediately fail.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>BOOLEAN</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="boolean">false</propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
      <entry>
        <string>jdbc.factory</string>
        <Property>
          <propertyName>jdbc.factory</propertyName>
          <labelName>JDBC Connection Factory</labelName>
          <propertyDescription>Specifies JDBC connection factory for DB connection establishment.</propertyDescription>
          <propertyGroup>main.group</propertyGroup>
          <dataType>JDBC_FACTORY</dataType>
          <isRequired>false</isRequired>
          <rangeList></rangeList>
          <propertyValue SemanticType="Value.JDBC_FACTORY">
            <factoryType>FactoryType</factoryType>
            <factoryName>FactoryName</factoryName>
          </propertyValue>
          <isExportable>true</isExportable>
        </Property>
      </entry>
    </propertiesTable>
    <propertyGroups>
      <string>main.group</string>
    </propertyGroups>
  </propertiesRegistry>
  <advancedPropertiesRegistry>
    <advancedPropertiesTable>
      <entry>
        <string>tlpSessionFlushDelay</string>
        <Property.ADVANCED>
          <name>tlpSessionFlushDelay</name>
          <value SemanticType="long">2</value>
          <label>Session Flush Delay</label>
          <description>Specifies in milliseconds the session&apos;s event flush delay. Defaults to 2 milliseconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkSolicitAllow</string>
        <Property.ADVANCED>
          <name>tlpLinkSolicitAllow</name>
          <value SemanticType="boolean">false</value>
          <label>Allow Dynamic Link Soliciting</label>
          <description>When enabled, allows components to dynamically register links when solicited.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>enableServiceStats</string>
        <Property.ADVANCED>
          <name>enableServiceStats</name>
          <value SemanticType="boolean">false</value>
          <label>Enable Service Stats</label>
          <description>Enables statistics collecting for service, such as method execution time.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpSessionExchangeMode</string>
        <Property.ADVANCED>
          <name>tlpSessionExchangeMode</name>
          <value SemanticType="string">optimistic</value>
          <label>Session Exchange Mode</label>
          <description>The datagram exchange mode of a session (&apos;optimistic&apos;, &apos;adaptive&apos;, &apos;sync&apos;, &apos;sequenced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>producerMfLeaseInterval</string>
        <Property.ADVANCED>
          <name>producerMfLeaseInterval</name>
          <value SemanticType="long">360000</value>
          <label>Producer Lease Interval</label>
          <description>For event producers, the interval at which the moderator statistics lease is renewed (defaults to 1 hour).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueMaxDepth</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueMaxDepth</name>
          <value SemanticType="long">10000</value>
          <label>Async Event Queue Depth</label>
          <description>For async listeners, the depth of the event delivery queue (defaults to 10000).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>daemonServiceMaxWorkTime</string>
        <Property.ADVANCED>
          <name>daemonServiceMaxWorkTime</name>
          <value SemanticType="long">3600</value>
          <label>Daemon Service Max Work Time</label>
          <description>This timeout in seconds is used by Service Watcher thread to check if the service is alive and doesn&apos;t hang.
Default max work time is 3600 seconds(60 minutes). Max time for one service iterations is a sum of passive iteration
interval and max work time.Check is performed every 30 seconds. [advisory.service.blocked] advisory is sent every 5 minutes.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncSpinWait</string>
        <Property.ADVANCED>
          <name>consumerAsyncSpinWait</name>
          <value SemanticType="long">3</value>
          <label>Async Event Delivery Interval</label>
          <description>For async listeners, the milliseconds a delivery thread waits between scheduled spins.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>serviceStopTimeout</string>
        <Property.ADVANCED>
          <name>serviceStopTimeout</name>
          <value SemanticType="long">15</value>
          <label>Service Stop Timeout</label>
          <description>Specifies the wait time (in seconds) for completion of pending operations during service stopping. Non-positive value means that service will not wait for completion of pending operations. Default is 15 seconds.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpForceConnection</string>
        <Property.ADVANCED>
          <name>tlpForceConnection</name>
          <value SemanticType="boolean">false</value>
          <label>Force New Connection</label>
          <description>When true, this component will form a new socket connection to it&apos;s peer.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>exceptionSuppressStacktrace</string>
        <Property.ADVANCED>
          <name>exceptionSuppressStacktrace</name>
          <value SemanticType="boolean">true</value>
          <label>Suppress Exception Stack Trace</label>
          <description>Removes stack trace from exceptions thrown by Service methods invoked via Accessor (defaults to false).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>servicePoolSize</string>
        <Property.ADVANCED>
          <name>servicePoolSize</name>
          <value SemanticType="long">1</value>
          <label>Service Pool Size</label>
          <description>Specifies service pool size in the service component.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncDeliveryMode</string>
        <Property.ADVANCED>
          <name>consumerAsyncDeliveryMode</name>
          <value SemanticType="string">async</value>
          <label>Async Event Delivery Mode</label>
          <description>For async listeners, the mode of event delivery (&apos;async&apos; or &apos;async_paced&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>consumerAsyncQueueFlowcontrol</string>
        <Property.ADVANCED>
          <name>consumerAsyncQueueFlowcontrol</name>
          <value SemanticType="string">exception</value>
          <label>Async Flow Control Mode</label>
          <description>For async listeners, the flow control mode (&apos;notify&apos; or &apos;exception&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpEventScope</string>
        <Property.ADVANCED>
          <name>tlpEventScope</name>
          <value SemanticType="string">observable</value>
          <label>Component Event Scope</label>
          <description>The visibility scope of events for this component (&apos;local&apos;, &apos;observable&apos;, &apos;global&apos;, &apos;clustered&apos;).</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>tlpLinkMaxSessions</string>
        <Property.ADVANCED>
          <name>tlpLinkMaxSessions</name>
          <value SemanticType="long">20</value>
          <label>Maximum Link Sessions</label>
          <description>Sets the number of concurrent link sessions this component may have.</description>
        </Property.ADVANCED>
      </entry>
      <entry>
        <string>componentRefNamespace</string>
        <Property.ADVANCED>
          <name>componentRefNamespace</name>
          <value SemanticType="string">/service</value>
          <label>Reference Context Namespace</label>
          <description>Specifies a Namespace (ie. /service/db) in the repository where the component may store supporting objects.</description>
        </Property.ADVANCED>
      </entry>
    </advancedPropertiesTable>
  </advancedPropertiesRegistry>
  <metricsRegistry>
    <metricsTable/>
  </metricsRegistry>
  <advisoriesRegistry>
    <stateAdvisoriesTable/>
    <advisoriesTable>
      <string>advisory.component.StateChange</string>
      <string>advisory.connection.StateChange</string>
    </advisoriesTable>
  </advisoriesRegistry>
  <actionableEventsRegistry>
    <actionableEventsTable>
      <string>event.static.query.result</string>
      <string>event.sql.query.result</string>
      <string>event.sql.query.batch.result</string>
      <string>event.sql.info</string>
    </actionableEventsTable>
  </actionableEventsRegistry>
  <eventHandlersRegistry>
    <handlersTable>
      <entry>
        <string>QueryExecutor</string>
        <Handler.EVENT>
          <methodName>processQueryStatement</methodName>
          <handlerName>QueryExecutor</handlerName>
          <requestEventId>event.sql.query</requestEventId>
          <requestSemanticType>SQLQuery</requestSemanticType>
          <responseEventId>event.sql.query.result</responseEventId>
          <responseSemanticType>RowSet</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
      <entry>
        <string>QueryBatchExecutor</string>
        <Handler.EVENT>
          <methodName>processQueryBatch</methodName>
          <handlerName>QueryBatchExecutor</handlerName>
          <requestEventId>event.sql.query.batch</requestEventId>
          <requestSemanticType>SQLQueryBatch</requestSemanticType>
          <responseEventId>event.sql.query.batch.result</responseEventId>
          <responseSemanticType>RowSet</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
      <entry>
        <string>StaticQueryExecutor</string>
        <Handler.EVENT>
          <methodName>executeStaticQuery</methodName>
          <handlerName>StaticQueryExecutor</handlerName>
          <requestEventId>event.rowset</requestEventId>
          <requestSemanticType>RowSet</requestSemanticType>
          <responseEventId>event.static.query.result</responseEventId>
          <responseSemanticType>RowSet</responseSemanticType>
          <invokeMode>ASYNC</invokeMode>
          <timeout>0</timeout>
        </Handler.EVENT>
      </entry>
    </handlersTable>
  </eventHandlersRegistry>
  <exceptionsRegistry>
    <exceptionsTable>
      <string>exception.service.Framework</string>
      <string>exception.dbms.SQLStatement</string>
    </exceptionsTable>
  </exceptionsRegistry>
  <configTimeStamp>1535704533233</configTimeStamp>
  <eventTriggersRegistry>
    <triggers/>
  </eventTriggersRegistry>
</ServiceConfiguration>