from __future__ import absolute_import

import unittest
import decimal
import collections

from datetime import datetime, date, time

from stpy.fabric.utils import Utils
from stpy.fabric.sl_response import SLResponse

import stpy
from stpy import HTTPFabricConnection
from stpy import DataspaceType

class TestHTTPSLSession(unittest.TestCase):
    def setUp(self):
        Utils.initLogs()
        pass

    def tearDown(self):
        pass

    def testSlangRequest(self):
        connection = self.openConnection()
        session = connection.createSLSession()
        # fetchSize = session.getFetchSize()
        name = session.getName()
        self.assertIsNotNone(connection._slSessions.get(name, None))

        response = session.slangRequest("list nodes")
        self.assertEqual(type(response), SLResponse)
        self.assertTrue(response.isOK)
        self.assertIsNotNone(response.rowSet)

        session.close()
        self.assertIsNone(connection._slSessions.get(name, None))

        connection.close()
        pass

    def openConnection(self):
        connection = HTTPFabricConnection("localhost:8888", "Admin", "Admin")
        connection.open()
        self.assertEqual(connection.isOpened(), True)
        self.assertEqual(connection.ping(), "AVAILABLE")
        return connection

