from __future__ import absolute_import

from stpy import HTTPFabricException
from .row_set import RowSetConverter
from .type_converter import TypeConverter

class SLResponse(object):
    """
    Slang response.
    """

    def __init__(self, text = None, isOK = True, exception = None):
        self.text = text
        self.rowSet = None
        self.exception = exception
        self.isOK = isOK
        self.object = None
        if self.exception:
            self.isOK = False

        self.messages = None

    @staticmethod
    def readFromMap(map, slResponse = None, typeFactory=None):
        if map == None:
            return None

        if slResponse == None:
            slResponse = SLResponse()
        slResponse.text = map.get('text', None)
        slResponse.rowSet = RowSetConverter.readFromMap(map.get('rowSet', None), typeFactory=typeFactory)
        slResponse.exception = map.get('exception', None)
        slResponse.isOK = map.get('isOK', True)
        slResponse.object = map.get('object', None)
        slResponse.messages = map.get('messages', None)

        return slResponse

    def __repr__(self):
        return "{" + "'@type' : 'SLResponse', 'isOK' : {}, 'text' : {}, 'rowSet' : {}, 'exception' : {}, 'object' : {}".\
            format(self.isOK, self.text, self.rowSet, self.exception, self.object) + "}"

class PromptSLResponse(SLResponse):

    def __init__(self):
        super(PromptSLResponse, self).__init__()
        self.nodeName = None
        self.componentType = None
        self.componentName = None

    @staticmethod
    def readFromMap(map, typeFactory=None):
        if map == None:
            return None

        slResponse = SLResponse.readFromMap(map, PromptSLResponse(), typeFactory=typeFactory)
        slResponse.nodeName = map.get('nodeName', None)
        slResponse.componentType = map.get('componentType', None)
        slResponse.componentName = map.get('componentName', None)

        return slResponse

    def __repr__(self):
        return "{" + "'@type' : 'PromptSLResponse', 'isOK' : {}, 'text' : {}, 'rowSet' : {}, 'exception' : {}, 'object' : {}, " \
               "'nodeName' : {}, 'componentType' : {}, 'componentName' : {}". \
            format(self.isOK, self.text, self.rowSet, self.exception, self.object, self.nodeName, self.componentType, self.componentName) + "}"


class SLResponseConverter(TypeConverter):

    @staticmethod
    def readFromMap(map, typeFactory=None):
        if map == None:
            return None

        t = map['@type']
        if t == 'SLResponse':
            return SLResponse.readFromMap(map,typeFactory=typeFactory);
        elif t == 'PromptSLResponse':
            return PromptSLResponse.readFromMap(map,typeFactory=typeFactory)
        else:
            raise HTTPFabricException("Unknown SLResponse type {}".format(t))

