from __future__ import absolute_import


class EventScope(object):
    INHERITED = "INHERITED"
    LOCAL = "LOCAL"
    OBSERVABLE = "OBSERVABLE"
    GLOBAL = "GLOBAL"
    CLUSTER = "CLUSTER"


class DataspaceType(object):
    TSPACE = "TSPACE"
    QSPACE = "QSPACE"
    HSPACE = "HSPACE"
    USPACE = "USPACE"
    FSPACE = "FSPACE"


class SQLType(object):
    CHAR = "CHAR"
    VARCHAR = "VARCHAR"
    LONGVARCHAR = "LONGVARCHAR"
    NCHAR = "NCHAR"
    NVARCHAR = "NVARCHAR"
    LONGNVARCHAR = "LONGNVARCHAR"
    STRING = "STRING"
    DATE = "DATE"
    TIME = "TIME"
    TIMESTAMP = "TIMESTAMP"

    TINYINT = "TINYINT"
    SMALLINT = "SMALLINT"
    INTEGER = "INTEGER"
    LONG = "LONG"
    BIGINT = "BIGINT"

    REAL = "REAL"
    DOUBLE = "DOUBLE"
    FLOAT = "FLOAT"
    NUMERIC = "NUMERIC"
    DECIMAL = "DECIMAL"
    BOOLEAN = "BOOLEAN"
    BINARY = "BINARY"
    VARBINARY = "VARBINARY"
    LONGVARBINARY = "LONGVARBINARY"
    CLOB = "CLOB"
    BLOB = "BLOB"
    BIT = "BIT"
    EVENT = "EVENT"
    ARRAY = "ARRAY"
    URL = "URL"
    OTHER = "OTHER"

    FLOB = "FLOB"

    UTINYINT = "UTINYINT"
    USMALLINT = "USMALLINT"
    UINTEGER = "UINTEGER"
    UBIGINT = "UBIGINT"


class HTTPFabricConnectionState(object):
    OPENED = "OPENED"
    CLOSED = "CLOSED"
    SERVER_CONNECTION_LOST = "SERVER_CONNECTION_LOST"
    SERVER_CONNECTION_REPAIRED = "SERVER_CONNECTION_REPAIRED"
    RECONNECT_FAILED = "RECONNECT_FAILED"
    REOPEN_START = "REOPEN_START"
    REOPEN_FAILED = "REOPEN_FAILED"
    REOPEN_ERROR = "REOPEN_ERROR"
    REOPEN_END = "REOPEN_END"
    FABRIC_CONNECTION_LOST = "FABRIC_CONNECTION_LOST"


class SLFileSessionContext(object):
    CLIENT = "CLIENT"
    SERVER = "SERVER"
