/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.compress;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.compress.LZ4;

/*
 * Exception performing whole class analysis ignored.
 */
public final class LZ4 {
    static final int MEMORY_USAGE = 14;
    static final int MIN_MATCH = 4;
    static final int MAX_DISTANCE = 65536;
    static final int LAST_LITERALS = 5;
    static final int HASH_LOG_HC = 15;
    static final int HASH_TABLE_SIZE_HC = 32768;
    static final int OPTIMAL_ML = 18;

    private LZ4() {
    }

    private static int hash(int i, int hashBits) {
        return i * -1640531535 >>> 32 - hashBits;
    }

    private static int hashHC(int i) {
        return LZ4.hash((int)i, (int)15);
    }

    private static int readInt(byte[] buf, int i) {
        return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
    }

    private static int commonBytes(byte[] b, int o1, int o2, int limit) {
        assert (o1 < o2);
        return Arrays.mismatch(b, o1, limit, b, o2, limit);
    }

    public static int decompress(DataInput compressed, int decompressedLen, byte[] dest) throws IOException {
        int dOff = 0;
        int destEnd = dest.length;
        do {
            int token;
            int literalLen;
            if ((literalLen = (token = compressed.readByte() & 0xFF) >>> 4) != 0) {
                if (literalLen == 15) {
                    byte len;
                    while ((len = compressed.readByte()) == -1) {
                        literalLen += 255;
                    }
                    literalLen += len & 0xFF;
                }
                compressed.readBytes(dest, dOff, literalLen);
                dOff += literalLen;
            }
            if (dOff >= decompressedLen) break;
            int matchDec = compressed.readByte() & 0xFF | (compressed.readByte() & 0xFF) << 8;
            assert (matchDec > 0);
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = compressed.readByte()) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            int fastLen = (matchLen += 4) + 7 & 0xFFFFFFF8;
            if (matchDec < matchLen || dOff + fastLen > destEnd) {
                int ref = dOff - matchDec;
                int end = dOff + matchLen;
                while (dOff < end) {
                    dest[dOff] = dest[ref];
                    ++ref;
                    ++dOff;
                }
            } else {
                System.arraycopy(dest, dOff - matchDec, dest, dOff, fastLen);
                dOff += matchLen;
            }
        } while (dOff < decompressedLen);
        return dOff;
    }

    private static void encodeLen(int l, DataOutput out) throws IOException {
        while (l >= 255) {
            out.writeByte((byte)-1);
            l -= 255;
        }
        out.writeByte((byte)l);
    }

    private static void encodeLiterals(byte[] bytes, int token, int anchor, int literalLen, DataOutput out) throws IOException {
        out.writeByte((byte)token);
        if (literalLen >= 15) {
            LZ4.encodeLen((int)(literalLen - 15), (DataOutput)out);
        }
        out.writeBytes(bytes, anchor, literalLen);
    }

    private static void encodeLastLiterals(byte[] bytes, int anchor, int literalLen, DataOutput out) throws IOException {
        int token = Math.min(literalLen, 15) << 4;
        LZ4.encodeLiterals((byte[])bytes, (int)token, (int)anchor, (int)literalLen, (DataOutput)out);
    }

    private static void encodeSequence(byte[] bytes, int anchor, int matchRef, int matchOff, int matchLen, DataOutput out) throws IOException {
        int literalLen = matchOff - anchor;
        assert (matchLen >= 4);
        int token = Math.min(literalLen, 15) << 4 | Math.min(matchLen - 4, 15);
        LZ4.encodeLiterals((byte[])bytes, (int)token, (int)anchor, (int)literalLen, (DataOutput)out);
        int matchDec = matchOff - matchRef;
        assert (matchDec > 0 && matchDec < 65536);
        out.writeByte((byte)matchDec);
        out.writeByte((byte)(matchDec >>> 8));
        if (matchLen >= 19) {
            LZ4.encodeLen((int)(matchLen - 15 - 4), (DataOutput)out);
        }
    }

    public static void compress(byte[] bytes, int off, int len, DataOutput out, HashTable ht) throws IOException {
        Objects.checkFromIndexSize(off, len, bytes.length);
        int base = off;
        int end = off + len;
        int anchor = off++;
        if (len > 9) {
            int limit = end - 5;
            int matchLimit = limit - 4;
            ht.reset(bytes, base, len);
            block0: while (off <= limit) {
                while (off < matchLimit) {
                    int ref = ht.get(off);
                    if (ref != -1) {
                        assert (ref >= base && ref < off);
                        assert (LZ4.readInt((byte[])bytes, (int)ref) == LZ4.readInt((byte[])bytes, (int)off));
                    } else {
                        ++off;
                        continue;
                    }
                    int matchLen = 4 + LZ4.commonBytes((byte[])bytes, (int)(ref + 4), (int)(off + 4), (int)limit);
                    int r = ht.previous(ref);
                    int min = Math.max(off - 65536 + 1, base);
                    while (r >= min) {
                        assert (LZ4.readInt((byte[])bytes, (int)r) == LZ4.readInt((byte[])bytes, (int)off));
                        int rMatchLen = 4 + LZ4.commonBytes((byte[])bytes, (int)(r + 4), (int)(off + 4), (int)limit);
                        if (rMatchLen > matchLen) {
                            ref = r;
                            matchLen = rMatchLen;
                        }
                        r = ht.previous(r);
                    }
                    LZ4.encodeSequence((byte[])bytes, (int)anchor, (int)ref, (int)off, (int)matchLen, (DataOutput)out);
                    anchor = off += matchLen;
                    continue block0;
                }
                break block0;
            }
        }
        int literalLen = end - anchor;
        assert (literalLen >= 5 || literalLen == len);
        LZ4.encodeLastLiterals((byte[])bytes, (int)anchor, (int)(end - anchor), (DataOutput)out);
    }

    static /* synthetic */ int access$000(byte[] x0, int x1) {
        return LZ4.readInt((byte[])x0, (int)x1);
    }

    static /* synthetic */ int access$100(int x0, int x1) {
        return LZ4.hash((int)x0, (int)x1);
    }

    static /* synthetic */ int access$200(int x0) {
        return LZ4.hashHC((int)x0);
    }
}

