/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.MathUtil;
import org.apache.lucene.util.bkd.BKDReader;
import org.apache.lucene.util.bkd.DocIdsWriter;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BKDReader
extends PointValues {
    final int leafNodeOffset;
    final int numDataDims;
    final int numIndexDims;
    final int bytesPerDim;
    final int numLeaves;
    final IndexInput in;
    final int maxPointsInLeafNode;
    final byte[] minPackedValue;
    final byte[] maxPackedValue;
    final long pointCount;
    final int docCount;
    final int version;
    protected final int packedBytesLength;
    protected final int packedIndexBytesLength;
    final long minLeafBlockFP;
    final IndexInput packedIndex;

    public BKDReader(IndexInput metaIn, IndexInput indexIn, IndexInput dataIn) throws IOException {
        long indexStartPointer;
        this.version = CodecUtil.checkHeader((DataInput)metaIn, (String)"BKD", (int)4, (int)9);
        this.numDataDims = metaIn.readVInt();
        this.numIndexDims = this.version >= 6 ? metaIn.readVInt() : this.numDataDims;
        this.maxPointsInLeafNode = metaIn.readVInt();
        this.bytesPerDim = metaIn.readVInt();
        this.packedBytesLength = this.numDataDims * this.bytesPerDim;
        this.packedIndexBytesLength = this.numIndexDims * this.bytesPerDim;
        this.numLeaves = metaIn.readVInt();
        assert (this.numLeaves > 0);
        this.leafNodeOffset = this.numLeaves;
        this.minPackedValue = new byte[this.packedIndexBytesLength];
        this.maxPackedValue = new byte[this.packedIndexBytesLength];
        metaIn.readBytes(this.minPackedValue, 0, this.packedIndexBytesLength);
        metaIn.readBytes(this.maxPackedValue, 0, this.packedIndexBytesLength);
        for (int dim = 0; dim < this.numIndexDims; ++dim) {
            if (Arrays.compareUnsigned(this.minPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim, this.maxPackedValue, dim * this.bytesPerDim, dim * this.bytesPerDim + this.bytesPerDim) <= 0) continue;
            throw new CorruptIndexException("minPackedValue " + new BytesRef(this.minPackedValue) + " is > maxPackedValue " + new BytesRef(this.maxPackedValue) + " for dim=" + dim, (DataInput)metaIn);
        }
        this.pointCount = metaIn.readVLong();
        this.docCount = metaIn.readVInt();
        int numIndexBytes = metaIn.readVInt();
        if (this.version >= 9) {
            this.minLeafBlockFP = metaIn.readLong();
            indexStartPointer = metaIn.readLong();
        } else {
            indexStartPointer = indexIn.getFilePointer();
            this.minLeafBlockFP = indexIn.readVLong();
            indexIn.seek(indexStartPointer);
        }
        this.packedIndex = indexIn.slice("packedIndex", indexStartPointer, (long)numIndexBytes);
        this.in = dataIn;
    }

    long getMinLeafBlockFP() {
        return this.minLeafBlockFP;
    }

    private int getTreeDepth() {
        return MathUtil.log((long)this.numLeaves, (int)2) + 2;
    }

    public void intersect(PointValues.IntersectVisitor visitor) throws IOException {
        this.intersect(this.getIntersectState(visitor), this.minPackedValue, this.maxPackedValue);
    }

    public long estimatePointCount(PointValues.IntersectVisitor visitor) {
        return this.estimatePointCount(this.getIntersectState(visitor), this.minPackedValue, this.maxPackedValue);
    }

    private void addAll(IntersectState state, boolean grown) throws IOException {
        long maxPointCount;
        if (!grown && (maxPointCount = (long)this.maxPointsInLeafNode * (long)state.index.getNumLeaves()) <= Integer.MAX_VALUE) {
            state.visitor.grow((int)maxPointCount);
            grown = true;
        }
        if (state.index.isLeafNode()) {
            assert (grown);
            if (state.index.nodeExists()) {
                this.visitDocIDs(state.in, state.index.getLeafBlockFP(), state.visitor);
            }
        } else {
            state.index.pushLeft();
            this.addAll(state, grown);
            state.index.pop();
            state.index.pushRight();
            this.addAll(state, grown);
            state.index.pop();
        }
    }

    public IntersectState getIntersectState(PointValues.IntersectVisitor visitor) {
        IndexTree index = new IndexTree(this);
        return new IntersectState(this.in.clone(), this.numDataDims, this.packedBytesLength, this.packedIndexBytesLength, this.maxPointsInLeafNode, visitor, index);
    }

    public void visitLeafBlockValues(IndexTree index, IntersectState state) throws IOException {
        int count = this.readDocIDs(state.in, index.getLeafBlockFP(), state.scratchIterator);
        this.visitDocValues(state.commonPrefixLengths, state.scratchDataPackedValue, state.scratchMinIndexPackedValue, state.scratchMaxIndexPackedValue, state.in, state.scratchIterator, count, state.visitor);
    }

    private void visitDocIDs(IndexInput in, long blockFP, PointValues.IntersectVisitor visitor) throws IOException {
        in.seek(blockFP);
        int count = in.readVInt();
        DocIdsWriter.readInts((IndexInput)in, (int)count, (PointValues.IntersectVisitor)visitor);
    }

    int readDocIDs(IndexInput in, long blockFP, BKDReaderDocIDSetIterator iterator) throws IOException {
        in.seek(blockFP);
        int count = in.readVInt();
        DocIdsWriter.readInts((IndexInput)in, (int)count, (int[])iterator.docIDs);
        return count;
    }

    void visitDocValues(int[] commonPrefixLengths, byte[] scratchDataPackedValue, byte[] scratchMinIndexPackedValue, byte[] scratchMaxIndexPackedValue, IndexInput in, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor) throws IOException {
        if (this.version >= 7) {
            this.visitDocValuesWithCardinality(commonPrefixLengths, scratchDataPackedValue, scratchMinIndexPackedValue, scratchMaxIndexPackedValue, in, scratchIterator, count, visitor);
        } else {
            this.visitDocValuesNoCardinality(commonPrefixLengths, scratchDataPackedValue, scratchMinIndexPackedValue, scratchMaxIndexPackedValue, in, scratchIterator, count, visitor);
        }
    }

    void visitDocValuesNoCardinality(int[] commonPrefixLengths, byte[] scratchDataPackedValue, byte[] scratchMinIndexPackedValue, byte[] scratchMaxIndexPackedValue, IndexInput in, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor) throws IOException {
        this.readCommonPrefixes(commonPrefixLengths, scratchDataPackedValue, in);
        if (this.numIndexDims != 1 && this.version >= 5) {
            byte[] minPackedValue = scratchMinIndexPackedValue;
            System.arraycopy(scratchDataPackedValue, 0, minPackedValue, 0, this.packedIndexBytesLength);
            byte[] maxPackedValue = scratchMaxIndexPackedValue;
            System.arraycopy(minPackedValue, 0, maxPackedValue, 0, this.packedIndexBytesLength);
            this.readMinMax(commonPrefixLengths, minPackedValue, maxPackedValue, in);
            PointValues.Relation r = visitor.compare(minPackedValue, maxPackedValue);
            if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                return;
            }
            visitor.grow(count);
            if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                for (int i = 0; i < count; ++i) {
                    visitor.visit(scratchIterator.docIDs[i]);
                }
                return;
            }
        } else {
            visitor.grow(count);
        }
        int compressedDim = this.readCompressedDim(in);
        if (compressedDim == -1) {
            this.visitUniqueRawDocValues(scratchDataPackedValue, scratchIterator, count, visitor);
        } else {
            this.visitCompressedDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor, compressedDim);
        }
    }

    void visitDocValuesWithCardinality(int[] commonPrefixLengths, byte[] scratchDataPackedValue, byte[] scratchMinIndexPackedValue, byte[] scratchMaxIndexPackedValue, IndexInput in, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor) throws IOException {
        this.readCommonPrefixes(commonPrefixLengths, scratchDataPackedValue, in);
        int compressedDim = this.readCompressedDim(in);
        if (compressedDim == -1) {
            visitor.grow(count);
            this.visitUniqueRawDocValues(scratchDataPackedValue, scratchIterator, count, visitor);
        } else {
            if (this.numIndexDims != 1) {
                byte[] minPackedValue = scratchMinIndexPackedValue;
                System.arraycopy(scratchDataPackedValue, 0, minPackedValue, 0, this.packedIndexBytesLength);
                byte[] maxPackedValue = scratchMaxIndexPackedValue;
                System.arraycopy(minPackedValue, 0, maxPackedValue, 0, this.packedIndexBytesLength);
                this.readMinMax(commonPrefixLengths, minPackedValue, maxPackedValue, in);
                PointValues.Relation r = visitor.compare(minPackedValue, maxPackedValue);
                if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
                    return;
                }
                visitor.grow(count);
                if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                    for (int i = 0; i < count; ++i) {
                        visitor.visit(scratchIterator.docIDs[i]);
                    }
                    return;
                }
            } else {
                visitor.grow(count);
            }
            if (compressedDim == -2) {
                this.visitSparseRawDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor);
            } else {
                this.visitCompressedDocValues(commonPrefixLengths, scratchDataPackedValue, in, scratchIterator, count, visitor, compressedDim);
            }
        }
    }

    private void readMinMax(int[] commonPrefixLengths, byte[] minPackedValue, byte[] maxPackedValue, IndexInput in) throws IOException {
        for (int dim = 0; dim < this.numIndexDims; ++dim) {
            int prefix = commonPrefixLengths[dim];
            in.readBytes(minPackedValue, dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
            in.readBytes(maxPackedValue, dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
        }
    }

    private void visitSparseRawDocValues(int[] commonPrefixLengths, byte[] scratchPackedValue, IndexInput in, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor) throws IOException {
        int i;
        int length;
        for (i = 0; i < count; i += length) {
            length = in.readVInt();
            for (int dim = 0; dim < this.numDataDims; ++dim) {
                int prefix = commonPrefixLengths[dim];
                in.readBytes(scratchPackedValue, dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
            }
            BKDReaderDocIDSetIterator.access$100((BKDReaderDocIDSetIterator)scratchIterator, (int)i, (int)length);
            visitor.visit((DocIdSetIterator)scratchIterator, scratchPackedValue);
        }
        if (i != count) {
            throw new CorruptIndexException("Sub blocks do not add up to the expected count: " + count + " != " + i, (DataInput)in);
        }
    }

    private void visitUniqueRawDocValues(byte[] scratchPackedValue, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor) throws IOException {
        BKDReaderDocIDSetIterator.access$100((BKDReaderDocIDSetIterator)scratchIterator, (int)0, (int)count);
        visitor.visit((DocIdSetIterator)scratchIterator, scratchPackedValue);
    }

    private void visitCompressedDocValues(int[] commonPrefixLengths, byte[] scratchPackedValue, IndexInput in, BKDReaderDocIDSetIterator scratchIterator, int count, PointValues.IntersectVisitor visitor, int compressedDim) throws IOException {
        int i;
        int runLen;
        int compressedByteOffset = compressedDim * this.bytesPerDim + commonPrefixLengths[compressedDim];
        int n = compressedDim;
        commonPrefixLengths[n] = commonPrefixLengths[n] + 1;
        for (i = 0; i < count; i += runLen) {
            scratchPackedValue[compressedByteOffset] = in.readByte();
            runLen = Byte.toUnsignedInt(in.readByte());
            for (int j = 0; j < runLen; ++j) {
                for (int dim = 0; dim < this.numDataDims; ++dim) {
                    int prefix = commonPrefixLengths[dim];
                    in.readBytes(scratchPackedValue, dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
                }
                visitor.visit(scratchIterator.docIDs[i + j], scratchPackedValue);
            }
        }
        if (i != count) {
            throw new CorruptIndexException("Sub blocks do not add up to the expected count: " + count + " != " + i, (DataInput)in);
        }
    }

    private int readCompressedDim(IndexInput in) throws IOException {
        byte compressedDim = in.readByte();
        if (compressedDim < -2 || compressedDim >= this.numDataDims || this.version < 7 && compressedDim == -2) {
            throw new CorruptIndexException("Got compressedDim=" + compressedDim, (DataInput)in);
        }
        return compressedDim;
    }

    private void readCommonPrefixes(int[] commonPrefixLengths, byte[] scratchPackedValue, IndexInput in) throws IOException {
        for (int dim = 0; dim < this.numDataDims; ++dim) {
            int prefix;
            commonPrefixLengths[dim] = prefix = in.readVInt();
            if (prefix <= 0) continue;
            in.readBytes(scratchPackedValue, dim * this.bytesPerDim, prefix);
        }
    }

    private void intersect(IntersectState state, byte[] cellMinPacked, byte[] cellMaxPacked) throws IOException {
        PointValues.Relation r = state.visitor.compare(cellMinPacked, cellMaxPacked);
        if (r != PointValues.Relation.CELL_OUTSIDE_QUERY) {
            if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
                this.addAll(state, false);
            } else if (state.index.isLeafNode()) {
                if (state.index.nodeExists()) {
                    int count = this.readDocIDs(state.in, state.index.getLeafBlockFP(), state.scratchIterator);
                    this.visitDocValues(state.commonPrefixLengths, state.scratchDataPackedValue, state.scratchMinIndexPackedValue, state.scratchMaxIndexPackedValue, state.in, state.scratchIterator, count, state.visitor);
                }
            } else {
                int splitDim = state.index.getSplitDim();
                assert (splitDim >= 0) : "splitDim=" + splitDim + ", numIndexDims=" + this.numIndexDims;
                assert (splitDim < this.numIndexDims) : "splitDim=" + splitDim + ", numIndexDims=" + this.numIndexDims;
                byte[] splitPackedValue = state.index.getSplitPackedValue();
                BytesRef splitDimValue = state.index.getSplitDimValue();
                assert (splitDimValue.length == this.bytesPerDim);
                assert (Arrays.compareUnsigned(cellMinPacked, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, splitDimValue.offset + this.bytesPerDim) <= 0) : "bytesPerDim=" + this.bytesPerDim + " splitDim=" + splitDim + " numIndexDims=" + this.numIndexDims + " numDataDims=" + this.numDataDims;
                assert (Arrays.compareUnsigned(cellMaxPacked, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, splitDimValue.offset + this.bytesPerDim) >= 0) : "bytesPerDim=" + this.bytesPerDim + " splitDim=" + splitDim + " numIndexDims=" + this.numIndexDims + " numDataDims=" + this.numDataDims;
                System.arraycopy(cellMaxPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
                System.arraycopy(splitDimValue.bytes, splitDimValue.offset, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
                state.index.pushLeft();
                this.intersect(state, cellMinPacked, splitPackedValue);
                state.index.pop();
                System.arraycopy(splitPackedValue, splitDim * this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, this.bytesPerDim);
                System.arraycopy(cellMinPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
                System.arraycopy(splitDimValue.bytes, splitDimValue.offset, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
                state.index.pushRight();
                this.intersect(state, splitPackedValue, cellMaxPacked);
                state.index.pop();
            }
        }
    }

    private long estimatePointCount(IntersectState state, byte[] cellMinPacked, byte[] cellMaxPacked) {
        PointValues.Relation r = state.visitor.compare(cellMinPacked, cellMaxPacked);
        if (r == PointValues.Relation.CELL_OUTSIDE_QUERY) {
            return 0L;
        }
        if (r == PointValues.Relation.CELL_INSIDE_QUERY) {
            return (long)this.maxPointsInLeafNode * (long)state.index.getNumLeaves();
        }
        if (state.index.isLeafNode()) {
            return (this.maxPointsInLeafNode + 1) / 2;
        }
        int splitDim = state.index.getSplitDim();
        assert (splitDim >= 0) : "splitDim=" + splitDim + ", numIndexDims=" + this.numIndexDims;
        assert (splitDim < this.numIndexDims) : "splitDim=" + splitDim + ", numIndexDims=" + this.numIndexDims;
        byte[] splitPackedValue = state.index.getSplitPackedValue();
        BytesRef splitDimValue = state.index.getSplitDimValue();
        assert (splitDimValue.length == this.bytesPerDim);
        assert (Arrays.compareUnsigned(cellMinPacked, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, splitDimValue.offset + this.bytesPerDim) <= 0) : "bytesPerDim=" + this.bytesPerDim + " splitDim=" + splitDim + " numIndexDims=" + this.numIndexDims + " numDataDims=" + this.numDataDims;
        assert (Arrays.compareUnsigned(cellMaxPacked, splitDim * this.bytesPerDim, splitDim * this.bytesPerDim + this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, splitDimValue.offset + this.bytesPerDim) >= 0) : "bytesPerDim=" + this.bytesPerDim + " splitDim=" + splitDim + " numIndexDims=" + this.numIndexDims + " numDataDims=" + this.numDataDims;
        System.arraycopy(cellMaxPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
        System.arraycopy(splitDimValue.bytes, splitDimValue.offset, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
        state.index.pushLeft();
        long leftCost = this.estimatePointCount(state, cellMinPacked, splitPackedValue);
        state.index.pop();
        System.arraycopy(splitPackedValue, splitDim * this.bytesPerDim, splitDimValue.bytes, splitDimValue.offset, this.bytesPerDim);
        System.arraycopy(cellMinPacked, 0, splitPackedValue, 0, this.packedIndexBytesLength);
        System.arraycopy(splitDimValue.bytes, splitDimValue.offset, splitPackedValue, splitDim * this.bytesPerDim, this.bytesPerDim);
        state.index.pushRight();
        long rightCost = this.estimatePointCount(state, splitPackedValue, cellMaxPacked);
        state.index.pop();
        return leftCost + rightCost;
    }

    public byte[] getMinPackedValue() {
        return (byte[])this.minPackedValue.clone();
    }

    public byte[] getMaxPackedValue() {
        return (byte[])this.maxPackedValue.clone();
    }

    public int getNumDimensions() {
        return this.numDataDims;
    }

    public int getNumIndexDimensions() {
        return this.numIndexDims;
    }

    public int getBytesPerDimension() {
        return this.bytesPerDim;
    }

    public long size() {
        return this.pointCount;
    }

    public int getDocCount() {
        return this.docCount;
    }

    public boolean isLeafNode(int nodeID) {
        return nodeID >= this.leafNodeOffset;
    }

    static /* synthetic */ int access$000(BKDReader x0) {
        return x0.getTreeDepth();
    }
}

