/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Sorter;
import org.apache.lucene.util.automaton.Transition;

/*
 * Exception performing whole class analysis ignored.
 */
public class Automaton
implements Accountable {
    private int nextState;
    private int nextTransition;
    private int curState = -1;
    private int[] states;
    private final BitSet isAccept;
    private int[] transitions;
    private boolean deterministic = true;
    private final Sorter destMinMaxSorter = new /* Unavailable Anonymous Inner Class!! */;
    private final Sorter minMaxDestSorter = new /* Unavailable Anonymous Inner Class!! */;

    public Automaton() {
        this(2, 2);
    }

    public Automaton(int numStates, int numTransitions) {
        this.states = new int[numStates * 2];
        this.isAccept = new BitSet(numStates);
        this.transitions = new int[numTransitions * 3];
    }

    public int createState() {
        this.growStates();
        int state = this.nextState / 2;
        this.states[this.nextState] = -1;
        this.nextState += 2;
        return state;
    }

    public void setAccept(int state, boolean accept) {
        Objects.checkIndex(state, this.getNumStates());
        this.isAccept.set(state, accept);
    }

    public Transition[][] getSortedTransitions() {
        int numStates = this.getNumStates();
        Transition[][] transitions = new Transition[numStates][];
        for (int s = 0; s < numStates; ++s) {
            int numTransitions = this.getNumTransitions(s);
            transitions[s] = new Transition[numTransitions];
            for (int t = 0; t < numTransitions; ++t) {
                Transition transition = new Transition();
                this.getTransition(s, t, transition);
                transitions[s][t] = transition;
            }
        }
        return transitions;
    }

    BitSet getAcceptStates() {
        return this.isAccept;
    }

    public boolean isAccept(int state) {
        return this.isAccept.get(state);
    }

    public void addTransition(int source, int dest, int label) {
        this.addTransition(source, dest, label, label);
    }

    public void addTransition(int source, int dest, int min, int max) {
        assert (this.nextTransition % 3 == 0);
        int bounds = this.nextState / 2;
        Objects.checkIndex(source, bounds);
        Objects.checkIndex(dest, bounds);
        this.growTransitions();
        if (this.curState != source) {
            if (this.curState != -1) {
                this.finishCurrentState();
            }
            this.curState = source;
            if (this.states[2 * this.curState] != -1) {
                throw new IllegalStateException("from state (" + source + ") already had transitions added");
            }
            assert (this.states[2 * this.curState + 1] == 0);
            this.states[2 * this.curState] = this.nextTransition;
        }
        this.transitions[this.nextTransition++] = dest;
        this.transitions[this.nextTransition++] = min;
        this.transitions[this.nextTransition++] = max;
        int n = 2 * this.curState + 1;
        this.states[n] = this.states[n] + 1;
    }

    public void addEpsilon(int source, int dest) {
        Transition t = new Transition();
        int count = this.initTransition(dest, t);
        for (int i = 0; i < count; ++i) {
            this.getNextTransition(t);
            this.addTransition(source, t.dest, t.min, t.max);
        }
        if (this.isAccept(dest)) {
            this.setAccept(source, true);
        }
    }

    public void copy(Automaton other) {
        int stateOffset = this.getNumStates();
        this.states = ArrayUtil.grow((int[])this.states, (int)(this.nextState + other.nextState));
        System.arraycopy(other.states, 0, this.states, this.nextState, other.nextState);
        for (int i = 0; i < other.nextState; i += 2) {
            if (this.states[this.nextState + i] == -1) continue;
            int n = this.nextState + i;
            this.states[n] = this.states[n] + this.nextTransition;
        }
        this.nextState += other.nextState;
        int otherNumStates = other.getNumStates();
        BitSet otherAcceptStates = other.getAcceptStates();
        for (int state = 0; state < otherNumStates && (state = otherAcceptStates.nextSetBit(state)) != -1; ++state) {
            this.setAccept(stateOffset + state, true);
        }
        this.transitions = ArrayUtil.grow((int[])this.transitions, (int)(this.nextTransition + other.nextTransition));
        System.arraycopy(other.transitions, 0, this.transitions, this.nextTransition, other.nextTransition);
        for (int i = 0; i < other.nextTransition; i += 3) {
            int n = this.nextTransition + i;
            this.transitions[n] = this.transitions[n] + stateOffset;
        }
        this.nextTransition += other.nextTransition;
        if (!other.deterministic) {
            this.deterministic = false;
        }
    }

    private void finishCurrentState() {
        int numTransitions = this.states[2 * this.curState + 1];
        assert (numTransitions > 0);
        int offset = this.states[2 * this.curState];
        int start = offset / 3;
        this.destMinMaxSorter.sort(start, start + numTransitions);
        int upto = 0;
        int min = -1;
        int max = -1;
        int dest = -1;
        for (int i = 0; i < numTransitions; ++i) {
            int tDest = this.transitions[offset + 3 * i];
            int tMin = this.transitions[offset + 3 * i + 1];
            int tMax = this.transitions[offset + 3 * i + 2];
            if (dest == tDest) {
                if (tMin <= max + 1) {
                    if (tMax <= max) continue;
                    max = tMax;
                    continue;
                }
                if (dest != -1) {
                    this.transitions[offset + 3 * upto] = dest;
                    this.transitions[offset + 3 * upto + 1] = min;
                    this.transitions[offset + 3 * upto + 2] = max;
                    ++upto;
                }
                min = tMin;
                max = tMax;
                continue;
            }
            if (dest != -1) {
                this.transitions[offset + 3 * upto] = dest;
                this.transitions[offset + 3 * upto + 1] = min;
                this.transitions[offset + 3 * upto + 2] = max;
                ++upto;
            }
            dest = tDest;
            min = tMin;
            max = tMax;
        }
        if (dest != -1) {
            this.transitions[offset + 3 * upto] = dest;
            this.transitions[offset + 3 * upto + 1] = min;
            this.transitions[offset + 3 * upto + 2] = max;
            ++upto;
        }
        this.nextTransition -= (numTransitions - upto) * 3;
        this.states[2 * this.curState + 1] = upto;
        this.minMaxDestSorter.sort(start, start + upto);
        if (this.deterministic && upto > 1) {
            int lastMax = this.transitions[offset + 2];
            for (int i = 1; i < upto; ++i) {
                min = this.transitions[offset + 3 * i + 1];
                if (min <= lastMax) {
                    this.deterministic = false;
                    break;
                }
                lastMax = this.transitions[offset + 3 * i + 2];
            }
        }
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public void finishState() {
        if (this.curState != -1) {
            this.finishCurrentState();
            this.curState = -1;
        }
    }

    public int getNumStates() {
        return this.nextState / 2;
    }

    public int getNumTransitions() {
        return this.nextTransition / 3;
    }

    public int getNumTransitions(int state) {
        assert (state >= 0);
        int count = this.states[2 * state + 1];
        if (count == -1) {
            return 0;
        }
        return count;
    }

    private void growStates() {
        if (this.nextState + 2 > this.states.length) {
            this.states = ArrayUtil.grow((int[])this.states, (int)(this.nextState + 2));
        }
    }

    private void growTransitions() {
        if (this.nextTransition + 3 > this.transitions.length) {
            this.transitions = ArrayUtil.grow((int[])this.transitions, (int)(this.nextTransition + 3));
        }
    }

    public int initTransition(int state, Transition t) {
        assert (state < this.nextState / 2) : "state=" + state + " nextState=" + this.nextState;
        t.source = state;
        t.transitionUpto = this.states[2 * state];
        return this.getNumTransitions(state);
    }

    public void getNextTransition(Transition t) {
        assert (t.transitionUpto + 3 - this.states[2 * t.source] <= 3 * this.states[2 * t.source + 1]);
        assert (this.transitionSorted(t));
        t.dest = this.transitions[t.transitionUpto++];
        t.min = this.transitions[t.transitionUpto++];
        t.max = this.transitions[t.transitionUpto++];
    }

    private boolean transitionSorted(Transition t) {
        int upto = t.transitionUpto;
        if (upto == this.states[2 * t.source]) {
            return true;
        }
        int nextDest = this.transitions[upto];
        int nextMin = this.transitions[upto + 1];
        int nextMax = this.transitions[upto + 2];
        if (nextMin > t.min) {
            return true;
        }
        if (nextMin < t.min) {
            return false;
        }
        if (nextMax > t.max) {
            return true;
        }
        if (nextMax < t.max) {
            return false;
        }
        if (nextDest > t.dest) {
            return true;
        }
        if (nextDest < t.dest) {
            return false;
        }
        return false;
    }

    public void getTransition(int state, int index, Transition t) {
        int i = this.states[2 * state] + 3 * index;
        t.source = state;
        t.dest = this.transitions[i++];
        t.min = this.transitions[i++];
        t.max = this.transitions[i++];
    }

    static void appendCharString(int c, StringBuilder b) {
        if (c >= 33 && c <= 126 && c != 92 && c != 34) {
            b.appendCodePoint(c);
        } else {
            b.append("\\\\U");
            String s = Integer.toHexString(c);
            if (c < 16) {
                b.append("0000000").append(s);
            } else if (c < 256) {
                b.append("000000").append(s);
            } else if (c < 4096) {
                b.append("00000").append(s);
            } else if (c < 65536) {
                b.append("0000").append(s);
            } else if (c < 0x100000) {
                b.append("000").append(s);
            } else if (c < 0x1000000) {
                b.append("00").append(s);
            } else if (c < 0x10000000) {
                b.append("0").append(s);
            } else {
                b.append(s);
            }
        }
    }

    public String toDot() {
        StringBuilder b = new StringBuilder();
        b.append("digraph Automaton {\n");
        b.append("  rankdir = LR\n");
        b.append("  node [width=0.2, height=0.2, fontsize=8]\n");
        int numStates = this.getNumStates();
        if (numStates > 0) {
            b.append("  initial [shape=plaintext,label=\"\"]\n");
            b.append("  initial -> 0\n");
        }
        Transition t = new Transition();
        for (int state = 0; state < numStates; ++state) {
            b.append("  ");
            b.append(state);
            if (this.isAccept(state)) {
                b.append(" [shape=doublecircle,label=\"").append(state).append("\"]\n");
            } else {
                b.append(" [shape=circle,label=\"").append(state).append("\"]\n");
            }
            int numTransitions = this.initTransition(state, t);
            for (int i = 0; i < numTransitions; ++i) {
                this.getNextTransition(t);
                assert (t.max >= t.min);
                b.append("  ");
                b.append(state);
                b.append(" -> ");
                b.append(t.dest);
                b.append(" [label=\"");
                Automaton.appendCharString((int)t.min, (StringBuilder)b);
                if (t.max != t.min) {
                    b.append('-');
                    Automaton.appendCharString((int)t.max, (StringBuilder)b);
                }
                b.append("\"]\n");
            }
        }
        b.append('}');
        return b.toString();
    }

    int[] getStartPoints() {
        HashSet<Integer> pointset = new HashSet<Integer>();
        pointset.add(0);
        for (int s = 0; s < this.nextState; s += 2) {
            int trans;
            int limit = trans + 3 * this.states[s + 1];
            for (trans = this.states[s]; trans < limit; trans += 3) {
                int min = this.transitions[trans + 1];
                int max = this.transitions[trans + 2];
                pointset.add(min);
                if (max >= 0x10FFFF) continue;
                pointset.add(max + 1);
            }
        }
        int[] points = new int[pointset.size()];
        int n = 0;
        for (Integer m : pointset) {
            points[n++] = m;
        }
        Arrays.sort(points);
        return points;
    }

    public int step(int state, int label) {
        return this.next(state, 0, label, null);
    }

    public int next(Transition transition, int label) {
        return this.next(transition.source, transition.transitionUpto, label, transition);
    }

    private int next(int state, int fromTransitionIndex, int label, Transition transition) {
        assert (state >= 0);
        assert (label >= 0);
        int stateIndex = 2 * state;
        int firstTransitionIndex = this.states[stateIndex];
        int numTransitions = this.states[stateIndex + 1];
        int low = Math.max(fromTransitionIndex, 0);
        int high = numTransitions - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int transitionIndex = firstTransitionIndex + 3 * mid;
            int minLabel = this.transitions[transitionIndex + 1];
            if (minLabel > label) {
                high = mid - 1;
                continue;
            }
            int maxLabel = this.transitions[transitionIndex + 2];
            if (maxLabel < label) {
                low = mid + 1;
                continue;
            }
            int destState = this.transitions[transitionIndex];
            if (transition != null) {
                transition.dest = destState;
                transition.min = minLabel;
                transition.max = maxLabel;
                transition.transitionUpto = mid;
            }
            return destState;
        }
        int destState = -1;
        if (transition != null) {
            transition.dest = destState;
            transition.transitionUpto = low;
        }
        return destState;
    }

    public long ramBytesUsed() {
        return (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.sizeOf((int[])this.states) + RamUsageEstimator.sizeOf((int[])this.transitions) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + (long)(this.isAccept.size() / 8) + (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 12L + 1L;
    }

    static /* synthetic */ int[] access$000(Automaton x0) {
        return x0.transitions;
    }
}

