/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.IntBinaryOperator;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefIterator;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.SortableBytesRefArray;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BytesRefArray
implements SortableBytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool((ByteBlockPool.Allocator)new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet((long)(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 4));
        this.bytesUsed = bytesUsed;
    }

    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow((int[])this.offsets, (int)(this.offsets.length + 1));
            this.bytesUsed.addAndGet((long)((this.offsets.length - oldLen) * 4));
        }
        this.pool.append(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement - 1;
    }

    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRefBuilder spare, int index) {
        Objects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        spare.grow(length);
        spare.setLength(length);
        this.pool.readBytes((long)offset, spare.bytes(), 0, spare.length());
        return spare.get();
    }

    private void setBytesRef(BytesRefBuilder spare, BytesRef result, int index) {
        Objects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        this.pool.setBytesRef(spare, result, (long)offset, length);
    }

    public SortState sort(Comparator<BytesRef> comp, IntBinaryOperator tieComparator) {
        int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new /* Unavailable Anonymous Inner Class!! */.sort(0, this.size());
        return new SortState(orderedEntries, null);
    }

    public BytesRefIterator iterator() {
        return this.iterator((SortState)null);
    }

    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        return this.iterator(this.sort(comp, (i, j) -> 0));
    }

    public IndexedBytesRefIterator iterator(SortState sortState) {
        int[] indices;
        int size = this.size();
        int[] nArray = indices = sortState == null ? null : SortState.access$200((SortState)sortState);
        assert (indices == null || indices.length == size) : indices.length + " != " + size;
        BytesRefBuilder spare = new BytesRefBuilder();
        BytesRef result = new BytesRef();
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ void access$000(BytesRefArray x0, BytesRefBuilder x1, BytesRef x2, int x3) {
        x0.setBytesRef(x1, x2, x3);
    }
}

