/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class LongRange
extends Field {
    public static final int BYTES = 8;

    public LongRange(String name, long[] min, long[] max) {
        super(name, (IndexableFieldType)LongRange.getType((int)min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 8);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(long[] min, long[] max) {
        byte[] bytes;
        LongRange.checkArgs((long[])min, (long[])max);
        if (min.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[16 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        LongRange.verifyAndEncode((long[])min, (long[])max, (byte[])bytes);
    }

    private static void checkArgs(long[] min, long[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("LongRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(long[] min, long[] max) {
        LongRange.checkArgs((long[])min, (long[])max);
        byte[] b = new byte[16 * min.length];
        LongRange.verifyAndEncode((long[])min, (long[])max, (byte[])b);
        return b;
    }

    static void verifyAndEncode(long[] min, long[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 8;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in LongRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in LongRange");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            LongRange.encode((long)min[d], (byte[])bytes, (int)i);
            LongRange.encode((long)max[d], (byte[])bytes, (int)j);
            ++d;
            i += 8;
            j += 8;
        }
    }

    private static void encode(long val, byte[] bytes, int offset) {
        NumericUtils.longToSortableBytes((long)val, (byte[])bytes, (int)offset);
    }

    public long getMin(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return LongRange.decodeMin((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    public long getMax(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return LongRange.decodeMax((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    static long decodeMin(byte[] b, int dimension) {
        int offset = dimension * 8;
        return NumericUtils.sortableBytesToLong((byte[])b, (int)offset);
    }

    static long decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 8;
        return NumericUtils.sortableBytesToLong((byte[])b, (int)offset);
    }

    public static Query newIntersectsQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery((String)field, (long[])min, (long[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery((String)field, (long[])min, (long[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery((String)field, (long[])min, (long[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, long[] min, long[] max) {
        return LongRange.newRelationQuery((String)field, (long[])min, (long[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, long[] min, long[] max, RangeFieldQuery.QueryType relation) {
        LongRange.checkArgs((long[])min, (long[])max);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        LongRange.toString((byte[])b, (int)0);
        for (int d = 0; d < this.type.pointDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(LongRange.toString((byte[])b, (int)d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Long.toString(LongRange.decodeMin((byte[])ranges, (int)dimension)) + " : " + Long.toString(LongRange.decodeMax((byte[])ranges, (int)dimension)) + "]";
    }

    static /* synthetic */ String access$000(byte[] x0, int x1) {
        return LongRange.toString((byte[])x0, (int)x1);
    }
}

