/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class IntRange
extends Field {
    public static final int BYTES = 4;

    public IntRange(String name, int[] min, int[] max) {
        super(name, (IndexableFieldType)IntRange.getType((int)min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("IntRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 4);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(int[] min, int[] max) {
        byte[] bytes;
        IntRange.checkArgs((int[])min, (int[])max);
        if (min.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[8 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        IntRange.verifyAndEncode((int[])min, (int[])max, (byte[])bytes);
    }

    private static void checkArgs(int[] min, int[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("IntRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(int[] min, int[] max) {
        IntRange.checkArgs((int[])min, (int[])max);
        byte[] b = new byte[8 * min.length];
        IntRange.verifyAndEncode((int[])min, (int[])max, (byte[])b);
        return b;
    }

    static void verifyAndEncode(int[] min, int[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 4;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in IntRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in IntRange");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            IntRange.encode((int)min[d], (byte[])bytes, (int)i);
            IntRange.encode((int)max[d], (byte[])bytes, (int)j);
            ++d;
            i += 4;
            j += 4;
        }
    }

    private static void encode(int val, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes((int)val, (byte[])bytes, (int)offset);
    }

    public int getMin(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return IntRange.decodeMin((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    public int getMax(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return IntRange.decodeMax((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    static int decodeMin(byte[] b, int dimension) {
        int offset = dimension * 4;
        return NumericUtils.sortableBytesToInt((byte[])b, (int)offset);
    }

    static int decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 4;
        return NumericUtils.sortableBytesToInt((byte[])b, (int)offset);
    }

    public static Query newIntersectsQuery(String field, int[] min, int[] max) {
        return IntRange.newRelationQuery((String)field, (int[])min, (int[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, int[] min, int[] max) {
        return IntRange.newRelationQuery((String)field, (int[])min, (int[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, int[] min, int[] max) {
        return IntRange.newRelationQuery((String)field, (int[])min, (int[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, int[] min, int[] max) {
        return IntRange.newRelationQuery((String)field, (int[])min, (int[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, int[] min, int[] max, RangeFieldQuery.QueryType relation) {
        IntRange.checkArgs((int[])min, (int[])max);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        IntRange.toString((byte[])b, (int)0);
        for (int d = 0; d < this.type.pointDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(IntRange.toString((byte[])b, (int)d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Integer.toString(IntRange.decodeMin((byte[])ranges, (int)dimension)) + " : " + Integer.toString(IntRange.decodeMax((byte[])ranges, (int)dimension)) + "]";
    }

    static /* synthetic */ String access$000(byte[] x0, int x1) {
        return IntRange.toString((byte[])x0, (int)x1);
    }
}

