/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.RangeFieldQuery;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FloatRange
extends Field {
    public static final int BYTES = 4;

    public FloatRange(String name, float[] min, float[] max) {
        super(name, (IndexableFieldType)FloatRange.getType((int)min.length));
        this.setRangeValues(min, max);
    }

    private static FieldType getType(int dimensions) {
        if (dimensions > 4) {
            throw new IllegalArgumentException("FloatRange does not support greater than 4 dimensions");
        }
        FieldType ft = new FieldType();
        ft.setDimensions(dimensions * 2, 4);
        ft.freeze();
        return ft;
    }

    public void setRangeValues(float[] min, float[] max) {
        byte[] bytes;
        FloatRange.checkArgs((float[])min, (float[])max);
        if (min.length * 2 != this.type.pointDimensionCount() || max.length * 2 != this.type.pointDimensionCount()) {
            throw new IllegalArgumentException("field (name=" + this.name + ") uses " + this.type.pointDimensionCount() / 2 + " dimensions; cannot change to (incoming) " + min.length + " dimensions");
        }
        if (this.fieldsData == null) {
            bytes = new byte[8 * min.length];
            this.fieldsData = new BytesRef(bytes);
        } else {
            bytes = ((BytesRef)this.fieldsData).bytes;
        }
        FloatRange.verifyAndEncode((float[])min, (float[])max, (byte[])bytes);
    }

    private static void checkArgs(float[] min, float[] max) {
        if (min == null || max == null || min.length == 0 || max.length == 0) {
            throw new IllegalArgumentException("min/max range values cannot be null or empty");
        }
        if (min.length != max.length) {
            throw new IllegalArgumentException("min/max ranges must agree");
        }
        if (min.length > 4) {
            throw new IllegalArgumentException("FloatRange does not support greater than 4 dimensions");
        }
    }

    static byte[] encode(float[] min, float[] max) {
        FloatRange.checkArgs((float[])min, (float[])max);
        byte[] b = new byte[8 * min.length];
        FloatRange.verifyAndEncode((float[])min, (float[])max, (byte[])b);
        return b;
    }

    static void verifyAndEncode(float[] min, float[] max, byte[] bytes) {
        int d = 0;
        int i = 0;
        int j = min.length * 4;
        while (d < min.length) {
            if (Double.isNaN(min[d])) {
                throw new IllegalArgumentException("invalid min value (NaN) in FloatRange");
            }
            if (Double.isNaN(max[d])) {
                throw new IllegalArgumentException("invalid max value (NaN) in FloatRange");
            }
            if (min[d] > max[d]) {
                throw new IllegalArgumentException("min value (" + min[d] + ") is greater than max value (" + max[d] + ")");
            }
            FloatRange.encode((float)min[d], (byte[])bytes, (int)i);
            FloatRange.encode((float)max[d], (byte[])bytes, (int)j);
            ++d;
            i += 4;
            j += 4;
        }
    }

    private static void encode(float val, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes((int)NumericUtils.floatToSortableInt((float)val), (byte[])bytes, (int)offset);
    }

    public float getMin(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return FloatRange.decodeMin((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    public float getMax(int dimension) {
        Objects.checkIndex(dimension, this.type.pointDimensionCount() / 2);
        return FloatRange.decodeMax((byte[])((BytesRef)this.fieldsData).bytes, (int)dimension);
    }

    static float decodeMin(byte[] b, int dimension) {
        int offset = dimension * 4;
        return NumericUtils.sortableIntToFloat((int)NumericUtils.sortableBytesToInt((byte[])b, (int)offset));
    }

    static float decodeMax(byte[] b, int dimension) {
        int offset = b.length / 2 + dimension * 4;
        return NumericUtils.sortableIntToFloat((int)NumericUtils.sortableBytesToInt((byte[])b, (int)offset));
    }

    public static Query newIntersectsQuery(String field, float[] min, float[] max) {
        return FloatRange.newRelationQuery((String)field, (float[])min, (float[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.INTERSECTS);
    }

    public static Query newContainsQuery(String field, float[] min, float[] max) {
        return FloatRange.newRelationQuery((String)field, (float[])min, (float[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CONTAINS);
    }

    public static Query newWithinQuery(String field, float[] min, float[] max) {
        return FloatRange.newRelationQuery((String)field, (float[])min, (float[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.WITHIN);
    }

    public static Query newCrossesQuery(String field, float[] min, float[] max) {
        return FloatRange.newRelationQuery((String)field, (float[])min, (float[])max, (RangeFieldQuery.QueryType)RangeFieldQuery.QueryType.CROSSES);
    }

    private static Query newRelationQuery(String field, float[] min, float[] max, RangeFieldQuery.QueryType relation) {
        FloatRange.checkArgs((float[])min, (float[])max);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" <");
        sb.append(this.name);
        sb.append(':');
        byte[] b = ((BytesRef)this.fieldsData).bytes;
        FloatRange.toString((byte[])b, (int)0);
        for (int d = 0; d < this.type.pointDimensionCount() / 2; ++d) {
            sb.append(' ');
            sb.append(FloatRange.toString((byte[])b, (int)d));
        }
        sb.append('>');
        return sb.toString();
    }

    private static String toString(byte[] ranges, int dimension) {
        return "[" + Float.toString(FloatRange.decodeMin((byte[])ranges, (int)dimension)) + " : " + Float.toString(FloatRange.decodeMax((byte[])ranges, (int)dimension)) + "]";
    }

    static /* synthetic */ String access$000(byte[] x0, int x1) {
        return FloatRange.toString((byte[])x0, (int)x1);
    }
}

