/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.compressing.FieldsIndex;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DirectMonotonicReader;

final class FieldsIndexReader
extends FieldsIndex {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldsIndexReader.class);
    private final int maxDoc;
    private final int blockShift;
    private final int numChunks;
    private final DirectMonotonicReader.Meta docsMeta;
    private final DirectMonotonicReader.Meta startPointersMeta;
    private final IndexInput indexInput;
    private final long docsStartPointer;
    private final long docsEndPointer;
    private final long startPointersStartPointer;
    private final long startPointersEndPointer;
    private final DirectMonotonicReader docs;
    private final DirectMonotonicReader startPointers;
    private final long maxPointer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FieldsIndexReader(Directory dir, String name, String suffix, String extensionPrefix, String codecName, byte[] id) throws IOException {
        try (ChecksumIndexInput metaIn = dir.openChecksumInput(IndexFileNames.segmentFileName((String)name, (String)suffix, (String)(extensionPrefix + "m")), IOContext.READONCE);){
            Throwable priorE = null;
            try {
                CodecUtil.checkIndexHeader((DataInput)metaIn, (String)(codecName + "Meta"), (int)0, (int)0, (byte[])id, (String)suffix);
                this.maxDoc = metaIn.readInt();
                this.blockShift = metaIn.readInt();
                this.numChunks = metaIn.readInt();
                this.docsStartPointer = metaIn.readLong();
                this.docsMeta = DirectMonotonicReader.loadMeta((IndexInput)metaIn, (long)this.numChunks, (int)this.blockShift);
                this.docsEndPointer = this.startPointersStartPointer = metaIn.readLong();
                this.startPointersMeta = DirectMonotonicReader.loadMeta((IndexInput)metaIn, (long)this.numChunks, (int)this.blockShift);
                this.startPointersEndPointer = metaIn.readLong();
                this.maxPointer = metaIn.readLong();
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)metaIn, priorE);
            }
        }
        this.indexInput = dir.openInput(IndexFileNames.segmentFileName((String)name, (String)suffix, (String)(extensionPrefix + "x")), IOContext.READ);
        boolean success = false;
        try {
            CodecUtil.checkIndexHeader((DataInput)this.indexInput, (String)(codecName + "Idx"), (int)0, (int)0, (byte[])id, (String)suffix);
            CodecUtil.retrieveChecksum((IndexInput)this.indexInput);
            success = true;
        }
        finally {
            if (!success) {
                this.indexInput.close();
            }
        }
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)this.docsMeta, (RandomAccessInput)docsSlice);
        this.startPointers = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)this.startPointersMeta, (RandomAccessInput)startPointersSlice);
    }

    private FieldsIndexReader(FieldsIndexReader other) throws IOException {
        this.maxDoc = other.maxDoc;
        this.numChunks = other.numChunks;
        this.blockShift = other.blockShift;
        this.docsMeta = other.docsMeta;
        this.startPointersMeta = other.startPointersMeta;
        this.indexInput = other.indexInput.clone();
        this.docsStartPointer = other.docsStartPointer;
        this.docsEndPointer = other.docsEndPointer;
        this.startPointersStartPointer = other.startPointersStartPointer;
        this.startPointersEndPointer = other.startPointersEndPointer;
        this.maxPointer = other.maxPointer;
        RandomAccessInput docsSlice = this.indexInput.randomAccessSlice(this.docsStartPointer, this.docsEndPointer - this.docsStartPointer);
        RandomAccessInput startPointersSlice = this.indexInput.randomAccessSlice(this.startPointersStartPointer, this.startPointersEndPointer - this.startPointersStartPointer);
        this.docs = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)this.docsMeta, (RandomAccessInput)docsSlice);
        this.startPointers = DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)this.startPointersMeta, (RandomAccessInput)startPointersSlice);
    }

    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + this.docsMeta.ramBytesUsed() + this.startPointersMeta.ramBytesUsed() + this.docs.ramBytesUsed() + this.startPointers.ramBytesUsed();
    }

    public void close() throws IOException {
        this.indexInput.close();
    }

    long getStartPointer(int docID) {
        Objects.checkIndex(docID, this.maxDoc);
        long blockIndex = this.docs.binarySearch(0L, (long)this.numChunks, (long)docID);
        if (blockIndex < 0L) {
            blockIndex = -2L - blockIndex;
        }
        return this.startPointers.get(blockIndex);
    }

    public FieldsIndex clone() {
        try {
            return new FieldsIndexReader(this);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public long getMaxPointer() {
        return this.maxPointer;
    }

    void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile((IndexInput)this.indexInput);
    }
}

