/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.tailer.impl;

import com.streamscape.tools.tailer.impl.RotationFilesListProvider;
import com.streamscape.tools.tailer.impl.RotationResolver;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;

public class SimpleRotationResolver
implements RotationResolver {
    private List<String> processedRotatedFiles;
    private RotationFilesListProvider rotationFilesList;
    private Path filename;

    public SimpleRotationResolver(RotationFilesListProvider rotationFilesList, Path filename) throws IOException {
        this.rotationFilesList = rotationFilesList;
        this.filename = filename;
        this.initProcessedRotatedFiles();
    }

    private static List<String> pathToNames(List<Path> list) {
        return list.stream().map(path -> path.getFileName().toString()).collect(Collectors.toList());
    }

    public void initProcessedRotatedFiles() throws IOException {
        this.processedRotatedFiles = SimpleRotationResolver.pathToNames(this.rotationFilesList.list(this.filename));
    }

    public void clearProcessedRotatedFilesLies() {
        this.processedRotatedFiles.clear();
    }

    public void setFirstNotProcessedRotatedFile(Path rotatedFileName) throws IOException {
        this.initProcessedRotatedFiles();
        if (rotatedFileName == null) {
            return;
        }
        int index = this.processedRotatedFiles.indexOf(rotatedFileName.getFileName().toString());
        if (index >= 0) {
            while (this.processedRotatedFiles.size() > index) {
                this.processedRotatedFiles.remove(this.processedRotatedFiles.size() - 1);
            }
        } else {
            throw new IOException("Rotated file '" + String.valueOf(rotatedFileName) + "' doesn't exist.");
        }
    }

    public void setLastProcessedRotatedFile(Path rotatedFileName) throws IOException {
        this.initProcessedRotatedFiles();
        if (rotatedFileName == null) {
            return;
        }
        int index = this.processedRotatedFiles.indexOf(rotatedFileName.getFileName().toString());
        if (index >= 0) {
            while (this.processedRotatedFiles.size() > index + 1) {
                this.processedRotatedFiles.remove(this.processedRotatedFiles.size() - 1);
            }
        } else {
            throw new IOException("Rotated file '" + String.valueOf(rotatedFileName) + "' doesn't exist.");
        }
    }

    @Override
    public void byteRead(int b) {
    }

    @Override
    public void bytesRead(byte[] bytes, int offset, int length) {
    }

    @Override
    public Path nextRotatedFile() throws IOException {
        Path path;
        String filename;
        int index;
        List<Path> files = this.rotationFilesList.list(this.filename);
        if (files.size() == 0) {
            return null;
        }
        for (index = files.size() - 1; index >= 0 && !this.processedRotatedFiles.contains(filename = (path = files.get(index)).getFileName().toString()); --index) {
        }
        ++index;
        this.processedRotatedFiles.clear();
        for (int i = 0; i <= index && i < files.size(); ++i) {
            this.processedRotatedFiles.add(files.get(i).getFileName().toString());
        }
        if (index < files.size()) {
            return files.get(index);
        }
        return null;
    }

    @Override
    public Path nextRotatedFile(Path rotatedFilename) throws IOException {
        int index;
        List<Path> files = this.rotationFilesList.list(this.filename);
        for (index = 0; index < files.size() && !files.get(index).getFileName().toString().equals(rotatedFilename.getFileName().toString()); ++index) {
        }
        if (++index < files.size()) {
            this.processedRotatedFiles.clear();
            for (int i = 0; i <= index; ++i) {
                this.processedRotatedFiles.add(files.get(i).getFileName().toString());
            }
            return files.get(index);
        }
        this.processedRotatedFiles = SimpleRotationResolver.pathToNames(files);
        return null;
    }
}

