/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.tailer.impl;

import com.streamscape.tools.tailer.impl.RotationFilenameProvider;
import com.streamscape.tools.tailer.impl.RotationFilesListProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RotationFilesListByFilenameProvider
implements RotationFilesListProvider {
    private RotationFilenameProvider filenameProvider;

    public RotationFilesListByFilenameProvider(RotationFilenameProvider filenameProvider) {
        this.filenameProvider = filenameProvider;
    }

    @Override
    public List<Path> list(Path filename) throws IOException {
        try (Stream<Path> stream = Files.list(filename.getParent());){
            List<Path> list = stream.filter(path -> path.toFile().isFile() && this.filenameProvider.isRotation(filename.getFileName().toString(), path.getFileName().toString())).sorted(Comparator.comparingLong(path1 -> path1.toFile().lastModified())).collect(Collectors.toList());
            return list;
        }
    }
}

