/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.tailer.impl;

import com.streamscape.Trace;
import com.streamscape.tools.tailer.FileTailerStateListener;
import com.streamscape.tools.tailer.impl.RotationResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class FileTailerInputStream
extends InputStream {
    private Path filename;
    private boolean checkForRotation = true;
    private int linesOffset;
    private long bytesOffset = -1L;
    private Set<FileTailerStateListener> listeners = new HashSet<FileTailerStateListener>();
    private RotationResolver rotationResolver;
    private RandomAccessFile originalFile;
    private RandomAccessFile rotatedFile;
    private long lastPosition = -1L;
    private volatile boolean isClosed = false;

    public FileTailerInputStream(Path filename, int linesOffset, RotationResolver rotationResolver) {
        this.filename = filename;
        this.linesOffset = linesOffset;
        this.rotationResolver = rotationResolver;
    }

    public void setBytesOffset(long bytesOffset) {
        this.bytesOffset = bytesOffset;
    }

    public void addStateListener(FileTailerStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeStateListener(FileTailerStateListener listener) {
        this.listeners.remove(listener);
    }

    public Path getFilename() {
        return this.filename;
    }

    public long getLastPosition() {
        return this.lastPosition;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed.");
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        try {
            if (this.rotatedFile == null) {
                wasReopened = false;
                if (this.originalFile == null) {
                    this.originalFile = new RandomAccessFile(this.filename.toFile(), "r");
                    wasReopened = true;
                    this.onFileFound(this.filename.getFileName().toString());
                    if (this.checkForRotation && this.rotationResolver != null && (nextRotatedFile = this.rotationResolver.nextRotatedFile()) != null) {
                        Trace.logDebug(this, "Next rotated file {}.", new Object[]{nextRotatedFile.toString()});
                        this.closeAllFiles();
                        this.rotatedFile = new RandomAccessFile(nextRotatedFile.toFile(), "r");
                        if (this.lastPosition == -1L) {
                            this.lastPosition = 0L;
                            this.lastPosition = this.bytesOffset >= 0L ? this.bytesOffset : this.skipLines(this.rotatedFile, this.linesOffset);
                        }
                        if (this.lastPosition >= 0L && this.rotatedFile.length() >= this.lastPosition) {
                            this.rotatedFile.seek(this.lastPosition);
                        }
                        this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$0(java.nio.file.Path com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this, (Path)nextRotatedFile));
                    }
                }
                if (this.originalFile != null) {
                    if (this.lastPosition == -1L) {
                        this.lastPosition = 0L;
                        this.lastPosition = this.bytesOffset >= 0L ? this.bytesOffset : this.skipLines(this.originalFile, this.linesOffset);
                    }
                    if (this.lastPosition >= 0L && wasReopened && this.originalFile.length() >= this.lastPosition) {
                        this.originalFile.seek(this.lastPosition);
                    }
                    if (this.originalFile.length() < this.lastPosition) {
                        if (this.rotationResolver != null) {
                            try {
                                rotatedFilePath = this.rotationResolver.nextRotatedFile();
                                if (rotatedFilePath != null) {
                                    if (rotatedFilePath != null) {
                                        Trace.logDebug(this, "Next rotated file {}.", new Object[]{rotatedFilePath.toString()});
                                    }
                                    this.rotatedFile = new RandomAccessFile(rotatedFilePath.toFile(), "r");
                                    rotatedFileLength = this.rotatedFile.length();
                                    if (rotatedFileLength < this.lastPosition) {
                                        this.rotatedFile = null;
                                        this.lastPosition = 0L;
                                        this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$1(java.nio.file.Path long com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this, (Path)rotatedFilePath, (long)rotatedFileLength));
                                    } else {
                                        this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$2(java.nio.file.Path com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this, (Path)rotatedFilePath));
                                        try {
                                            this.rotatedFile.seek(this.lastPosition);
                                        }
                                        catch (IOException exception) {
                                            throw new IOException("Seeking rotated file failed.", exception);
                                        }
                                        this.closeQuite(this.originalFile);
                                        this.originalFile = null;
                                    }
                                    if (this.rotatedFile != null) ** GOTO lbl70
                                    this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$3(com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this));
                                    if (this.originalFile != null) ** GOTO lbl70
                                    this.originalFile = new RandomAccessFile(this.filename.toFile(), "r");
                                }
                                this.lastPosition = 0L;
                                this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$4(com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this));
                            }
                            catch (IOException exception) {
                                this.lastPosition = 0L;
                                throw exception;
                            }
                        } else {
                            this.lastPosition = 0L;
                            this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$5(com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((FileTailerInputStream)this));
                            this.originalFile.seek(0L);
                        }
                    }
                }
            }
lbl70:
            // 11 sources

            if (this.rotatedFile != null) {
                try {
                    count = this.rotatedFile.read(b, off, len);
                    if (count == -1) {
                        this.closeQuite(this.rotatedFile);
                        this.rotatedFile = null;
                        this.lastPosition = 0L;
                        this.checkForRotation = true;
                    } else {
                        this.lastPosition += (long)count;
                    }
                    return count;
                }
                catch (IOException exception) {
                    this.lastPosition = 0L;
                    throw exception;
                }
            }
            if (this.originalFile != null) {
                count = this.originalFile.read(b, off, len);
                if (count >= 0) {
                    this.lastPosition += (long)count;
                    if (this.rotationResolver != null) {
                        this.rotationResolver.bytesRead(b, off, len);
                    }
                } else {
                    this.closeQuite(this.originalFile);
                    this.originalFile = null;
                }
                this.checkForRotation = false;
                return count;
            }
            throw new IOException("No one original or rotated files opened.");
        }
        catch (FileNotFoundException exception) {
            this.onFileNotFound(this.filename.getFileName().toString());
            this.closeAllFiles();
            throw exception;
        }
        catch (IOException exception) {
            this.forEachListenerSafe((Consumer<FileTailerStateListener>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$read$6(java.io.IOException com.streamscape.tools.tailer.FileTailerStateListener ), (Lcom/streamscape/tools/tailer/FileTailerStateListener;)V)((IOException)exception));
            this.closeAllFiles();
            throw exception;
        }
    }

    private void onFileNotFound(String name) {
        this.forEachListenerSafe(l -> l.onFileNotFound(name));
    }

    private void onFileFound(String name) {
        this.forEachListenerSafe(l -> l.onFileFound(name));
    }

    private long skipLines(RandomAccessFile originalFile, int linesCount) throws IOException {
        long position;
        if (linesCount == 0) {
            return originalFile.length();
        }
        if (linesCount == 1) {
            return 0L;
        }
        if (linesCount > 1) {
            byte[] buffer = new byte[4096];
            boolean seenCR = false;
            int count = 0;
            long position2 = 0L;
            long resultPosition = 0L;
            while (linesCount > 1 && (count = originalFile.read(buffer)) != -1) {
                for (int i = 0; i < count; ++i) {
                    switch (buffer[i]) {
                        case 10: {
                            --linesCount;
                            resultPosition = position2 + (long)i + 1L;
                            break;
                        }
                        case 13: {
                            int next;
                            --linesCount;
                            resultPosition = position2 + (long)i + 1L;
                            if (++i < count) {
                                next = buffer[i];
                            } else {
                                next = originalFile.read();
                                position2 += (long)count;
                                count = 1;
                            }
                            if (next != 10) break;
                            ++resultPosition;
                            break;
                        }
                    }
                    if (linesCount == 1) break;
                }
                position2 += (long)count;
            }
            if (linesCount > 1) {
                resultPosition = position2;
            }
            return resultPosition;
        }
        byte[] buffer = new byte[4096];
        boolean seenNL = false;
        long resultPosition = position = originalFile.length();
        long fileLength = position;
        while (position > 0L && linesCount < 0) {
            int length = buffer.length;
            if (position - (long)length < 0L) {
                length = (int)position;
            }
            long currentPosition = position - (long)length;
            originalFile.seek(currentPosition);
            int count = originalFile.read(buffer, 0, length);
            for (int i = count - 1; i >= 0; --i) {
                switch (buffer[i]) {
                    case 10: {
                        seenNL = true;
                        if (currentPosition + (long)i + 1L == fileLength) break;
                        ++linesCount;
                        resultPosition = currentPosition + (long)i + 1L;
                        break;
                    }
                    case 13: {
                        if (seenNL) {
                            seenNL = false;
                            break;
                        }
                        if (currentPosition + (long)i + 1L == fileLength) break;
                        ++linesCount;
                        resultPosition = currentPosition + (long)i + 1L;
                        break;
                    }
                    default: {
                        seenNL = false;
                    }
                }
                if (linesCount == 0) break;
            }
            if ((position -= (long)length) >= 0L) continue;
            position = 0L;
        }
        if (linesCount < 0) {
            resultPosition = 0L;
        }
        return resultPosition;
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.isClosed) {
            throw new IOException("Stream is closed.");
        }
        byte[] bytes = new byte[1];
        int count = this.read(bytes, 0, 1);
        if (count > 0) {
            return bytes[0] & 0xFF;
        }
        return count;
    }

    private void closeQuite(RandomAccessFile file) {
        try {
            if (file != null) {
                file.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeAllFiles() {
        this.closeQuite(this.originalFile);
        this.originalFile = null;
        this.closeQuite(this.rotatedFile);
        this.rotatedFile = null;
    }

    @Override
    public synchronized void close() throws IOException {
        this.isClosed = true;
        this.closeAllFiles();
    }

    void forEachListenerSafe(Consumer<FileTailerStateListener> executor) {
        this.listeners.forEach(listener -> {
            try {
                executor.accept((FileTailerStateListener)listener);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private static /* synthetic */ void lambda$read$6(IOException exception, FileTailerStateListener l) {
        l.onException(exception);
    }

    private /* synthetic */ void lambda$read$5(FileTailerStateListener l) {
        l.onFileTruncated(this.filename.getFileName().toString());
    }

    private /* synthetic */ void lambda$read$4(FileTailerStateListener l) {
        l.onFileTruncated(this.filename.getFileName().toString());
    }

    private /* synthetic */ void lambda$read$3(FileTailerStateListener l) {
        l.onFileRotated(this.filename.getFileName().toString(), null);
    }

    private /* synthetic */ void lambda$read$2(Path rotatedFilePath, FileTailerStateListener l) {
        l.onFileRotated(this.filename.getFileName().toString(), rotatedFilePath.getFileName().toString());
    }

    private /* synthetic */ void lambda$read$1(Path rotatedFilePath, long rotatedFileLength, FileTailerStateListener l) {
        l.onException(new IOException("Invalid rotated file '" + rotatedFilePath.toString() + "'. File length " + rotatedFileLength + " less that last position " + this.lastPosition + "."));
    }

    private /* synthetic */ void lambda$read$0(Path nextRotatedFile, FileTailerStateListener l) {
        l.onFileRotated(this.filename.getFileName().toString(), nextRotatedFile.getFileName().toString());
    }
}

