/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.tailer.impl;

import com.streamscape.tools.tailer.FileTailerByteListener;
import com.streamscape.tools.tailer.FileTailerListener;
import com.streamscape.tools.tailer.FileTailerStateListener;
import com.streamscape.tools.tailer.FileTailerStringListener;
import com.streamscape.tools.tailer.impl.FileTailerInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class FileTailerExecutor {
    private int maxBlockSize = 0xA00000;
    private int maxReadOnOneExecute = 0xA00000;
    private Set<FileTailerStateListener> stateListeners = new HashSet<FileTailerStateListener>();
    private Set<FileTailerByteListener> byteListeners = new HashSet<FileTailerByteListener>();
    private Set<FileTailerStringListener> stringListeners = new HashSet<FileTailerStringListener>();
    private FileTailerInputStream inputStream;
    private byte[] buffer;
    private static final int BUFFER_MIN_SIZE = 1024;

    public FileTailerExecutor(FileTailerInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public void setMaxBlockSize(int maxBlockSize) {
        this.maxBlockSize = maxBlockSize;
    }

    public int getMaxReadOnOneExecute() {
        return this.maxReadOnOneExecute;
    }

    public void setMaxReadOnOneExecute(int maxReadOnOneExecute) {
        this.maxReadOnOneExecute = maxReadOnOneExecute;
    }

    public Path getFilename() {
        return this.inputStream.getFilename();
    }

    public void addListener(FileTailerListener listener) {
        if (listener instanceof FileTailerStateListener) {
            this.stateListeners.add((FileTailerStateListener)listener);
            this.inputStream.addStateListener((FileTailerStateListener)listener);
        }
        if (listener instanceof FileTailerByteListener) {
            this.byteListeners.add((FileTailerByteListener)listener);
        }
        if (listener instanceof FileTailerStringListener) {
            this.stringListeners.add((FileTailerStringListener)listener);
        }
    }

    public void removeListener(FileTailerListener listener) {
        if (listener instanceof FileTailerStateListener) {
            this.stateListeners.remove(listener);
            this.inputStream.removeStateListener((FileTailerStateListener)listener);
        }
        if (listener instanceof FileTailerByteListener) {
            this.byteListeners.remove(listener);
        }
        if (listener instanceof FileTailerStringListener) {
            this.stringListeners.remove(listener);
        }
    }

    public int execute() {
        int exceptionsCount = 0;
        int totalRead = 0;
        block6: while (true) {
            try {
                while (totalRead < this.maxReadOnOneExecute) {
                    int length = 0;
                    int offset = 0;
                    if (this.buffer == null) {
                        this.buffer = new byte[1024];
                    }
                    IOException readException = null;
                    while (true) {
                        int count;
                        try {
                            count = this.inputStream.read(this.buffer, offset, this.maxBlockSize > this.buffer.length - offset ? this.buffer.length - offset : this.maxBlockSize);
                            if (count == -1) break;
                            offset += count;
                        }
                        catch (IOException exception) {
                            readException = exception;
                            break;
                        }
                        if ((length += count) >= this.maxBlockSize) break;
                        if (length != this.buffer.length) continue;
                        int newLength = this.buffer.length * 2 + 1;
                        if (newLength > this.maxBlockSize) {
                            newLength = this.maxBlockSize;
                        }
                        this.buffer = Arrays.copyOf(this.buffer, newLength);
                    }
                    if (length > 0) {
                        exceptionsCount = 0;
                        totalRead += length;
                        if (this.byteListeners.size() > 0) {
                            byte[] subBuffer = this.buffer;
                            if (length != subBuffer.length) {
                                subBuffer = Arrays.copyOf(subBuffer, length);
                            }
                            for (FileTailerByteListener fileTailerByteListener : this.byteListeners) {
                                fileTailerByteListener.onNewBlock(subBuffer, this.inputStream.getLastPosition() - (long)length);
                            }
                        }
                        if (this.stringListeners.size() <= 0) continue;
                        String str = new String(this.buffer, 0, length);
                        for (FileTailerStringListener fileTailerStringListener : this.stringListeners) {
                            fileTailerStringListener.onNewBlock(str, this.inputStream.getLastPosition() - (long)length);
                        }
                        continue;
                    }
                    if (readException == null) break block6;
                    if (++exceptionsCount >= 2) {
                        if (this.buffer.length <= 1024) break block6;
                        this.buffer = null;
                        break block6;
                    }
                    try {
                        Thread.sleep(100L);
                        continue block6;
                    }
                    catch (InterruptedException exception) {
                        Thread.currentThread().interrupt();
                        break block6;
                    }
                }
                break;
            }
            catch (Exception exception) {
                this.stateListeners.forEach(l -> {
                    try {
                        l.onException(exception);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                });
                break;
            }
        }
        return totalRead;
    }

    public void close() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

