/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang.model;

import com.streamscape.Trace;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.lib.fs.client.FileInfo;
import com.streamscape.lib.utils.NonCloseableInputStream;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.omf.json.jackson.JsonNotation;
import com.streamscape.omf.json.jackson.JsonNotationLevel;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MlmUtils {
    public static final String COMMON_PROPERTY_NAME = "name";
    public static final String COMMON_PROPERTY_DESCRIPTION = "description";
    public static final String COMMON_PROPERTY_VERSION = "version";
    public static final String COMMON_PROPERTY_VENDOR = "vendor";
    public static final String COMMON_PROPERTY_LICENSE = "license";
    public static final String COMMON_PROPERTY_ISSYSTEM = "isSystem";
    public static final String COMMON_PROPERTY_SERVICETYPE = "serviceType";
    public static final String COMMON_PROPERTY_FILENAME = "filename";
    public static final String COMMON_PROPERTY_LASTMODIFIED = "lastModified";
    public static final String COMMON_PROPERTY_CREATEDAT = "createdAt";
    public static final String STTEXT_PROPERTY_ZIPFILENAME = "zipFilename";
    public static final String STTEXT_PROPERTY_ZIPFILESIZE = "zipFilesize";
    public static final String STTEXT_PROPERTY_UNPACKEDSIZE = "unpackedSize";
    public static final String STTEXT_PROPERTY_README = "readme";
    public static final String STTEXT_PROPERTY_CONF = "conf";
    public static final String CAS_PROPERTY_PROVIDERNAME = "providerName";
    public static final String CAS_PROPERTY_BINFILENAME = "binFilename";
    public static final String CAS_PROPERTY_FILESIZE = "fileSize";
    public static final String CAS_PROPERTY_LOADEDTIMESTAMP = "loadedTimestamp";
    public static final String CAS_PROPERTY_ALGORITHMINFO = "algorithmInfo";
    public static final String CAS_PROPERTY_MODELREADONLYSETTINGS = "modelReadOnlySettings";
    public static final String STTEXT_MODEL_INFO_FILENAME = "sttextmodelinfo.json";
    public static final String CAS_MODEL_INFO_FILENAME = "casmodelinfo.json";
    public static final String ROOT_DIRECTORY = ".mlcache";
    public static final String MLCACHE_MODELS_PATH = ".mlcache/sys/models";
    public static final String MODELS_PATH_IN_MLCACHE = "sys/models";

    protected static String getModelLocation(String serviceType) {
        return ".mlcache/sys/models/" + serviceType;
    }

    public static List<String> getServiceTypes(String root) throws IOException {
        File file = new File(root, MLCACHE_MODELS_PATH);
        if (file.exists()) {
            return Files.list(file.toPath()).map(p -> p.toFile().getName()).filter(n -> !n.startsWith(".")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static List<String> listModelFilenamesByServiceType(String serviceType) {
        return MlmUtils.listModelFilenamesInLocation(MlmUtils.getModelLocation(serviceType));
    }

    public static List<String> listModelFilenamesInLocation(String location) {
        if (!new File(location).exists() || !new File(location).isDirectory()) {
            return new ArrayList<String>();
        }
        try {
            return Files.list(Paths.get(location, new String[0])).filter(path -> path.toFile().isFile()).filter(path -> path.getFileName().toString().endsWith(".mlm")).map(path -> path.getFileName().toString()).collect(Collectors.toList());
        }
        catch (IOException exception) {
            return new ArrayList<String>();
        }
    }

    public static List<Map<String, Object>> getModelInfos(String serviceType) {
        return MlmUtils.listModelFilenamesByServiceType(serviceType).stream().map(name -> MlmUtils.getModelInfoFromMlm(MlmUtils.getModelLocation(serviceType) + "/" + name, serviceType)).filter(m -> m != null).collect(Collectors.toList());
    }

    public static Map<String, Object> getModelInfoFromMlm(String modelPath, String serviceType) {
        Map info;
        File file = new File(modelPath);
        if (!file.exists() || file.isDirectory()) {
            throw new RuntimeException("Model doesn't exist.");
        }
        try {
            info = MlmUtils.getModelEntity(file, (InputStream inputStream) -> MlmUtils.deserializeCASModelInfo(inputStream));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read model. " + exception.toString());
        }
        if (info == null) {
            return null;
        }
        info.put(COMMON_PROPERTY_FILENAME, file.getName());
        if (file.exists()) {
            info.put(STTEXT_PROPERTY_ZIPFILESIZE, file.length());
            info.put(CAS_PROPERTY_FILESIZE, file.length());
            if (info.get(COMMON_PROPERTY_LASTMODIFIED) == null || String.valueOf(info.get(COMMON_PROPERTY_LASTMODIFIED)) == "0") {
                info.put(COMMON_PROPERTY_LASTMODIFIED, file.lastModified());
            }
        }
        if (serviceType != null && info.get(COMMON_PROPERTY_SERVICETYPE) == null) {
            info.put(COMMON_PROPERTY_SERVICETYPE, serviceType);
        } else {
            String st = (String)info.get(COMMON_PROPERTY_SERVICETYPE);
            if (st != null) {
                st = st.substring(st.lastIndexOf(46) + 1);
                info.put(COMMON_PROPERTY_SERVICETYPE, st);
            }
        }
        return info;
    }

    public static Map<String, Object> getModelInfoFromMlm(SLFileUtils file) {
        Map info;
        try (SLFileInputStream inputStream = file.createSLFileInputStream();){
            inputStream.open();
            info = MlmUtils.getModelEntity(inputStream, (InputStream i) -> MlmUtils.deserializeCASModelInfo(i));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to read model. " + exception.toString());
        }
        if (info == null) {
            return null;
        }
        try {
            FileInfo fileInfo = file.getFileInfo(null);
            info.put(STTEXT_PROPERTY_ZIPFILESIZE, fileInfo.getSize());
            info.put(CAS_PROPERTY_FILESIZE, fileInfo.getSize());
            if (info.get(COMMON_PROPERTY_LASTMODIFIED) == null || String.valueOf(info.get(COMMON_PROPERTY_LASTMODIFIED)) == "0") {
                info.put(COMMON_PROPERTY_LASTMODIFIED, fileInfo.getModificationTime());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get file info. " + e.toString());
        }
        info.put(COMMON_PROPERTY_FILENAME, new File(file.getFilename()).getName());
        String st = (String)info.get(COMMON_PROPERTY_SERVICETYPE);
        if (st != null) {
            st = st.substring(st.lastIndexOf(46) + 1);
            info.put(COMMON_PROPERTY_SERVICETYPE, st);
        }
        return info;
    }

    public static <T> T getModelEntity(File file, Function<InputStream, T> deserializer) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Object object = MlmUtils.getModelEntity(fileInputStream, (InputStream i) -> deserializer.apply((InputStream)i));
            return (T)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <T> T getModelEntity(InputStream inputStream, Function<InputStream, T> deserializer) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                InputStream inputStream2;
                if (!CAS_MODEL_INFO_FILENAME.equals(entry.getName()) && !STTEXT_MODEL_INFO_FILENAME.equals(entry.getName())) continue;
                try {
                    inputStream2 = deserializer.apply(new NonCloseableInputStream(zipInputStream));
                }
                catch (Throwable throwable) {
                    try {
                        zipInputStream.closeEntry();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                        return null;
                    }
                }
                zipInputStream.closeEntry();
                return (T)inputStream2;
            }
        }
    }

    protected static Map<String, Object> deserializeCASModelInfo(InputStream inputStream) {
        try {
            return MlmUtils.getJsonSerializer().deserialize(Map.class, (Reader)new InputStreamReader(inputStream));
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to load model add info.", exception);
        }
    }

    public static JSONSerializer getJsonSerializer() {
        try {
            RuntimeContext context = RuntimeState.isActive() ? RuntimeContext.getInstance() : (ClientState.isActive() ? ClientContext.getInstance() : null);
            JSONSerializerFactory factory = context != null ? context.getJSONSerializerFactory() : JSONSerializerFactory.getInstance();
            return factory.createSerializerDefaultBuilderLazy("JSONSerializer$HTTPUtilsForMlm").apply(builder -> {
                builder.setJsonNotation(JsonNotation.TYPE);
                builder.setJsonNotationLevel(JsonNotationLevel.NONE);
            }).getOrBuild();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setModelMissingProperties(Map<String, Object> info) {
        if (info.get(COMMON_PROPERTY_SERVICETYPE) == null) {
            if (info.get(CAS_PROPERTY_PROVIDERNAME) != null) {
                String serviceType = null;
                String providerName = info.getOrDefault(CAS_PROPERTY_PROVIDERNAME, "").toString();
                if (providerName.equals("DeepLearning4j")) {
                    serviceType = "TXSemagraph";
                } else if (providerName.equals("Smile")) {
                    serviceType = "TXCluster";
                } else if (providerName.equals("CoreNLP")) {
                    serviceType = "CTExtractor";
                } else if (providerName.equals("MITIE")) {
                    serviceType = "CMExtractor";
                }
                info.put(COMMON_PROPERTY_SERVICETYPE, serviceType);
            } else {
                info.put(COMMON_PROPERTY_SERVICETYPE, "STText");
            }
        }
        if (info.get(CAS_PROPERTY_PROVIDERNAME) == null && MlmUtils.isSttext(info)) {
            info.put(CAS_PROPERTY_PROVIDERNAME, "StreamScape");
        }
    }

    public static boolean isSttext(Map<String, Object> info) {
        String serviceType = info.getOrDefault(COMMON_PROPERTY_SERVICETYPE, "").toString();
        return serviceType != null && serviceType.endsWith("STText");
    }

    public static List<String> getMlmUsageServices(RuntimeContext context, Map<String, Object> info) {
        String modelName = (String)info.get(COMMON_PROPERTY_NAME);
        return MlmUtils.getMlmUsageServices(context, MlmUtils.getServiceType(info), modelName);
    }

    public static String getServiceType(Map<String, Object> info) {
        int dotIndex;
        String serviceType = (String)info.get(COMMON_PROPERTY_SERVICETYPE);
        if (serviceType != null && (dotIndex = serviceType.lastIndexOf(46)) > 0) {
            serviceType = serviceType.substring(dotIndex + 1);
        }
        return serviceType;
    }

    private static List<String> getMlmUsageServices(RuntimeContext context, String serviceType, String modelName) {
        ArrayList<String> services = new ArrayList<String>();
        try {
            RepositoryAccessor accessor = context.getRepositoryAccessor();
            for (String serviceName : accessor.listServicesByType(serviceType)) {
                try {
                    String trainingFlow;
                    ServiceConfigurationObject sco = accessor.loadServiceConfiguration(serviceName, serviceType);
                    String modelName1 = sco.getPropertyNames().contains("sttext.model.name") ? (String)sco.getProperty("sttext.model.name").getValue() : null;
                    String modelName2 = sco.getPropertyNames().contains("model.name") ? (String)sco.getProperty("model.name").getValue() : null;
                    String modelName3 = sco.getPropertyNames().contains("sttext.punctuation.model.name") ? (String)sco.getProperty("sttext.punctuation.model.name").getValue() : null;
                    String opertationFlow = sco.getPropertyNames().contains("operating.flow") ? (String)sco.getProperty("operating.flow").getValue() : null;
                    String string = trainingFlow = sco.getPropertyNames().contains("trainig.flow") ? (String)sco.getProperty("trainig.flow").getValue() : null;
                    if (!modelName.equals(modelName1) && !modelName.equals(modelName2) && !modelName.equals(modelName3) && (opertationFlow == null || opertationFlow.indexOf(modelName) < 0) && (trainingFlow == null || trainingFlow.indexOf(modelName) < 0)) continue;
                    services.add(serviceName);
                }
                catch (Exception e) {
                    Trace.logException(MlmUtils.class, e, true);
                }
            }
        }
        catch (Exception e) {
            Trace.logException(MlmUtils.class, e, true);
        }
        return services;
    }

    public static class Settings {
        protected LinkedHashMap<String, Object> settings;
        protected LinkedHashMap<String, PropertyMeta> descriptions;

        public static class PropertyMeta {
            private final String range;
            private final String description;

            public PropertyMeta() {
                this("n/a", "n/a");
            }

            public PropertyMeta(String range, String description) {
                this.range = range;
                this.description = description;
            }

            public String getRange() {
                return this.range;
            }

            public String getDescription() {
                return this.description;
            }
        }
    }
}

