/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang.model;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.tools.slang.model.DescribeMlmSessionOperation;
import com.streamscape.tools.slang.model.MlmUtils;
import java.util.ArrayList;
import java.util.Map;

public class ListMlmOperation
extends AbstractOperation<RuntimeContext> {
    public static final String NAME = "list mlm";

    public ListMlmOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("LIST MLM").addModifier((AbstractModifier)((Modifier)new Modifier("SERVICE TYPE").addParameter(new IdentifierParameter("type"))).setRequired(false));
        this.syntax.setDescription("List all (or for specified service) MLMs available in the node.");
        this.syntax.setExamples("list mlm\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("type").getValue());
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return ListMlmOperation.doInvoke((RuntimeContext)this.callable, statement, session, timeout);
    }

    public static <T> SLResponse doInvoke(T callable, SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ArrayList<String> serviceTypes = new ArrayList<String>();
        if (definition.type != null) {
            serviceTypes.add(definition.type);
        } else {
            serviceTypes.addAll(MlmUtils.getServiceTypes("."));
        }
        ArrayList<Map<String, Object>> infos = new ArrayList<Map<String, Object>>();
        for (String serviceType : serviceTypes) {
            infos.addAll(MlmUtils.getModelInfos(serviceType));
        }
        RowMetaData rowMetaData = new RowMetaData().addColumn("Name", String.class).addColumn("File Name", String.class).addColumn("Provider", String.class).addColumn("Path", String.class).addColumn("Service Type", String.class).addColumn("Size", String.class).addColumn("Unpacked Size", String.class).addColumn("Last Modified", String.class).addColumn("Description", String.class).addColumn("Version", String.class).addColumn("Licence", String.class).addColumn("Vendor", String.class).addColumn("System", String.class).addColumn("Usage", String.class);
        RowSet rowSet = new RowSet(rowMetaData);
        for (Map map : infos) {
            MlmUtils.setModelMissingProperties(map);
            String sizeS = "n/a";
            String unpackedSizeS = "n/a";
            if (MlmUtils.isSttext(map)) {
                size = DescribeMlmSessionOperation.longOrZero(map.get("zipFilesize"));
                sizeS = size != 0L ? SizeUnit.convertToBestFractional(size, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a";
                long unpackedSize = DescribeMlmSessionOperation.longOrZero(map.get("unpackedSize"));
                unpackedSizeS = unpackedSize != 0L ? SizeUnit.convertToBestFractional(unpackedSize, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a";
            } else {
                size = DescribeMlmSessionOperation.longOrZero(map.get("fileSize"));
                sizeS = size != 0L ? SizeUnit.convertToBestFractional(size, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a";
            }
            rowSet.addToRowSet(new Object[]{DescribeMlmSessionOperation.stringOrEmpty(map.get("name")), DescribeMlmSessionOperation.stringOrEmpty(map.get("filename")), DescribeMlmSessionOperation.stringOrEmpty(map.get("providerName")), "sys/models/" + String.valueOf(DescribeMlmSessionOperation.stringOrEmpty(map.get("serviceType"))), DescribeMlmSessionOperation.stringOrEmpty(map.get("serviceType")), sizeS, unpackedSizeS, DescribeMlmSessionOperation.longOrZero(map.get("lastModified")) != 0L ? ListMlmOperation.formatDate(DescribeMlmSessionOperation.longOrZero(map.get("lastModified"))) : "n/a", DescribeMlmSessionOperation.stringOrEmpty(map.get("description")), DescribeMlmSessionOperation.stringOrEmpty(map.get("version")), DescribeMlmSessionOperation.stringOrEmpty(map.get("license")), DescribeMlmSessionOperation.stringOrEmpty(map.get("vendor")), DescribeMlmSessionOperation.stringOrEmpty(map.get("isSystem")), MlmUtils.getMlmUsageServices(callable instanceof RuntimeContext ? (RuntimeContext)callable : RuntimeContext.getInstance(), map).size()});
        }
        return new SLResponse(rowSet);
    }

    public static class Definition
    extends AbstractSLStatement {
        private String type;

        Definition(String type) {
            super(ListMlmOperation.NAME);
            this.type = type;
        }
    }
}

