/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang.model;

import com.streamscape.omf.json.jackson.JSONSerializer;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.LocalLocationModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.SizeUnit;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.tools.slang.AbstractSessionOperation;
import com.streamscape.tools.slang.model.MlmUtils;
import java.io.File;
import java.util.Map;

public class DescribeMlmSessionOperation
extends AbstractSessionOperation {
    public static final String NAME = "describe mlm";

    public DescribeMlmSessionOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE MLM").addModifier((AbstractModifier)new LocalLocationModifier().setSyntaxHintSpace());
        this.syntax.addModifier((AbstractModifier)((ChoiceModifier)((ChoiceModifier)((ChoiceModifier)new ChoiceModifier().addModifier(new Modifier("README"))).addModifier(new Modifier("LICENSE"))).addModifier(new Modifier("CONF"))).setRequired(false));
        this.syntax.setDescription("Shows information about the mlm.");
        this.syntax.setExamples("describe mlm at './models/mymodel.mlm'\n");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(NAME, statement.getParameter("Location").getValue(), statement.existsModifier("README"), statement.existsModifier("LICENSE"), statement.existsModifier("CONF"));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        File file = new File(definition.location);
        if (!file.exists() || file.isDirectory()) {
            throw new RuntimeException("Model doesn't exist.");
        }
        Map<String, Object> info = MlmUtils.getModelInfoFromMlm(definition.location, null);
        if (info == null) {
            throw new Exception("Failed to read model or model not found.");
        }
        return DescribeMlmSessionOperation.doInvoke(info, definition.conf, definition.license, definition.readme);
    }

    public static <T> SLResponse doInvoke(Map<String, Object> info, boolean conf, boolean license, boolean readme) throws Exception {
        MlmUtils.setModelMissingProperties(info);
        if (readme) {
            Object readmeText = info.get("readme");
            return new SLResponse(readmeText != null ? readmeText.toString() : "");
        }
        if (conf) {
            JSONSerializer serializer = MlmUtils.getJsonSerializer().withPrettyPrint(true);
            if (MlmUtils.isSttext(info)) {
                Object confText = info.get("conf");
                return new SLResponse(confText != null ? serializer.serialize(confText) : "");
            }
            Object algInfo = info.get("algorithmInfo");
            Object settings = info.get("modelReadOnlySettings");
            return new SLResponse((algInfo != null ? serializer.serialize(algInfo) : "") + "\n" + (settings != null ? serializer.serialize(settings) : ""));
        }
        if (license) {
            Object licenceText = info.get("license");
            return new SLResponse(licenceText != null ? licenceText.toString() : "");
        }
        RowSet result = new RowSet(DescribeMlmSessionOperation.createResultDescriptor());
        result.addToRowSet(new Object[]{"Name", DescribeMlmSessionOperation.stringOrEmpty(info.get("name"))});
        result.addToRowSet(new Object[]{"Description", DescribeMlmSessionOperation.stringOrEmpty(info.get("description"))});
        result.addToRowSet(new Object[]{"Provider", DescribeMlmSessionOperation.stringOrEmpty(info.get("providerName"))});
        result.addToRowSet(new Object[]{"File Name", DescribeMlmSessionOperation.stringOrEmpty(info.get("filename"))});
        result.addToRowSet(new Object[]{"Vendor", DescribeMlmSessionOperation.stringOrEmpty(info.get("vendor"))});
        result.addToRowSet(new Object[]{"Path", "sys/models/" + String.valueOf(DescribeMlmSessionOperation.stringOrEmpty(info.get("serviceType")))});
        result.addToRowSet(new Object[]{"Service Type", MlmUtils.getServiceType(info)});
        result.addToRowSet(new Object[]{"Created At", DescribeMlmSessionOperation.toDate(info.get("createdAt"))});
        result.addToRowSet(new Object[]{"Last Modified At", DescribeMlmSessionOperation.toDate(info.get("lastModified"))});
        result.addToRowSet(new Object[]{"Version", DescribeMlmSessionOperation.stringOrEmpty(info.get("version"))});
        result.addToRowSet(new Object[]{"License", DescribeMlmSessionOperation.stringOrEmpty(info.get("license"))});
        result.addToRowSet(new Object[]{"System", DescribeMlmSessionOperation.stringOrEmpty(info.get("isSystem"))});
        if (MlmUtils.isSttext(info)) {
            long size = DescribeMlmSessionOperation.longOrZero(info.get("zipFilesize"));
            result.addToRowSet(new Object[]{"Packed Size", size != 0L ? SizeUnit.convertToBestFractional(size, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a"});
            long unpackedSize = DescribeMlmSessionOperation.longOrZero(info.get("unpackedSize"));
            result.addToRowSet(new Object[]{"Unpacked Size", unpackedSize != 0L ? SizeUnit.convertToBestFractional(unpackedSize, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a"});
        } else {
            long size = DescribeMlmSessionOperation.longOrZero(info.get("fileSize"));
            result.addToRowSet(new Object[]{"Packed Size", size != 0L ? SizeUnit.convertToBestFractional(size, SizeUnit.BYTES).toStringWithPrecision(2) : "n/a"});
        }
        result.addToRowSet(new Object[]{"Usage", MlmUtils.getMlmUsageServices(RuntimeContext.getInstance(), info).size()});
        return new SLResponse(result);
    }

    public static Object stringOrEmpty(Object o) {
        return o != null ? o : "";
    }

    public static Long longOrZero(Object o) {
        if (o == null) {
            return 0L;
        }
        return Long.valueOf(String.valueOf(o));
    }

    public static Object toDate(Object o) {
        Long n = DescribeMlmSessionOperation.longOrZero(o);
        if (n == 0L) {
            return "n/a";
        }
        return DescribeMlmSessionOperation.formatDate(n);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeMlmSessionOperation.addColumn(result, "Property");
        DescribeMlmSessionOperation.addColumn(result, "Value");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private final String location;
        private final boolean readme;
        private final boolean license;
        private final boolean conf;

        Definition(String name, String location, boolean readme, boolean license, boolean conf) {
            super(name);
            this.location = location;
            this.readme = readme;
            this.license = license;
            this.conf = conf;
        }
    }
}

