/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.tools.slang;

import com.streamscape.Trace;
import com.streamscape.tools.console.AbstractJavaConsole;
import com.streamscape.tools.console.Console;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.slang.SLANGTool;
import java.io.BufferedReader;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;

class WrappedSLANGTool
extends SLANGTool {
    public static final String FAKE_CHECK_STATUS_OPERATION = "__FAKE_CHECK_STATUS_OPERATION__";

    WrappedSLANGTool() throws IOException {
    }

    public static void main(String[] args) throws Exception {
        try {
            ConsoleConfiguration.initializeDefault();
            ConsoleConfiguration.instance().setSaveToFile(false);
            args = new String[]{"-noprompt", "-java-console"};
            WrappedSLANGTool.parseArgs(args);
            new WrappedSLANGTool().run();
        }
        catch (Exception exception) {
            Trace.logException(SLANGTool.class, exception, true);
            System.err.println("ERROR: " + WrappedSLANGTool.formatException(exception));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void run() throws IOException {
        this.printDelimiter(StreamDelimiter.SLANG_STARTED);
        this.isRunning = true;
        while (true) {
            if (!this.isRunning) {
                this.exit();
                return;
            }
            boolean operationStarted = false;
            try {
                String command = this.console.readCommand(this.getPrompt());
                if (command == null) {
                    this.exit();
                }
                if (command.length() == 0 || command.equals(FAKE_CHECK_STATUS_OPERATION)) continue;
                this.printDelimiter(StreamDelimiter.SLANG_OPERATION_STARTED);
                operationStarted = true;
                if (this.processCommand(command)) continue;
                this.console.waitForInterrupt(null);
                continue;
            }
            catch (ReadInterruptedException command) {
                continue;
            }
            catch (NoSuchElementException exception) {
                this.isRunning = false;
                continue;
            }
            catch (IOError exception) {
                this.isRunning = false;
                continue;
            }
            catch (Throwable exception) {
                this.printError(WrappedSLANGTool.formatException(exception));
                continue;
            }
            finally {
                if (!operationStarted) continue;
                this.printDelimiter(StreamDelimiter.SLANG_OPERATION_ENDED);
                continue;
            }
            break;
        }
    }

    @Override
    protected Console createConsole() {
        return new WrappedSLANGToolConsole();
    }

    @Override
    public void exit() {
        this.printDelimiter(StreamDelimiter.SLANG_EXITED);
        super.exit();
    }

    protected void printDelimiter(StreamDelimiter delimiter) {
        this.println("\n" + delimiter.name);
    }

    @Override
    public void setConsoleCCSID(Charset ccsid) throws UnsupportedEncodingException {
    }

    public static enum StreamDelimiter {
        NO_DELIMITER("__NO_DELIMITER__"),
        SLANG_STARTED("__SLANG_STARTED__"),
        SLANG_EXITED("__SLANG_EXITED__"),
        SLANG_OPERATION_STARTED("__SLANG_OPERATION_STARTED__"),
        SLANG_OPERATION_ENDED("__SLANG_OPERATION_ENDED__");

        private String name;

        private StreamDelimiter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public static StreamDelimiter parse(String delimiter) {
            for (StreamDelimiter value : StreamDelimiter.values()) {
                if (!value.name.equals(delimiter)) continue;
                return value;
            }
            return NO_DELIMITER;
        }
    }

    public static class WrappedSLANGToolConsole
    extends AbstractJavaConsole {
        private BufferedReader in;

        WrappedSLANGToolConsole() {
            this(System.in);
        }

        WrappedSLANGToolConsole(InputStream input) {
            this.in = new BufferedReader(new InputStreamReader(input));
        }

        @Override
        protected String readLine(String prompt) {
            try {
                return this.in.readLine();
            }
            catch (IOException exception) {
                throw new IOError(exception);
            }
        }

        @Override
        public String readUser(String prompt) {
            this.getPrintStream().println("Interactive operations not allowed in wrapped slang tool.");
            return "";
        }

        @Override
        public String readPassword(String prompt) {
            this.getPrintStream().println("Interactive operations not allowed in wrapped slang tool.");
            return "";
        }

        @Override
        public boolean interrupt() {
            return false;
        }

        @Override
        public void waitForInterrupt(String allowedChars) {
            this.readLine("");
        }
    }
}

